/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.common.properties.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import org.picketlink.common.properties.FieldProperty;
import org.picketlink.common.properties.MethodProperty;
import org.picketlink.common.properties.Property;

public class PropertyAdapter<V>
implements Property<V> {
    private FieldProperty<V> fieldProperty;
    private MethodProperty<V> methodProperty;
    private Property<V> property;

    PropertyAdapter(FieldProperty fieldProperty) {
        if (fieldProperty == null) {
            throw new IllegalStateException("The field property must be defined.");
        }
        this.fieldProperty = fieldProperty;
    }

    PropertyAdapter(MethodProperty methodProperty) {
        if (methodProperty == null) {
            throw new IllegalStateException("The method property must be defined.");
        }
        this.methodProperty = methodProperty;
    }

    @Override
    public String getName() {
        return this.getProperty().getName();
    }

    @Override
    public Type getBaseType() {
        return this.getProperty().getBaseType();
    }

    @Override
    public Class<V> getJavaClass() {
        return this.getProperty().getJavaClass();
    }

    @Override
    public AnnotatedElement getAnnotatedElement() {
        return this.getProperty().getAnnotatedElement();
    }

    @Override
    public Member getMember() {
        return this.getProperty().getMember();
    }

    @Override
    public V getValue(Object instance) {
        return this.getProperty().getValue(instance);
    }

    @Override
    public void setValue(Object instance, V value) {
        this.getProperty().setValue(instance, value);
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.getProperty().getDeclaringClass();
    }

    @Override
    public boolean isReadOnly() {
        return this.getProperty().isReadOnly();
    }

    @Override
    public void setAccessible() {
        this.getProperty().setAccessible();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        return this.isPropertyAnnotated(this.fieldProperty, annotation) || this.isPropertyAnnotated(this.methodProperty, annotation);
    }

    private boolean isPropertyAnnotated(Property<V> property, Class<? extends Annotation> annotation) {
        return property != null && property.getAnnotatedElement() != null && property.isAnnotationPresent(annotation);
    }

    public String toString() {
        return this.getProperty().toString();
    }

    public int hashCode() {
        return this.getProperty().hashCode();
    }

    public boolean equals(Object obj) {
        return this.getProperty().equals(obj);
    }

    void setProperty(Property<V> property) {
        this.checkPropertySet(this.fieldProperty, property);
        this.checkPropertySet(this.methodProperty, property);
        if (FieldProperty.class.isInstance(property)) {
            this.fieldProperty = (FieldProperty)property;
        } else if (MethodProperty.class.isInstance(property)) {
            this.methodProperty = (MethodProperty)property;
        } else {
            throw new IllegalArgumentException("Invalid property type [" + property + "].");
        }
    }

    private Property<V> getProperty() {
        if (this.methodProperty != null) {
            return this.methodProperty;
        }
        return this.fieldProperty;
    }

    private void checkPropertySet(Property<V> currentProperty, Property<V> newProperty) {
        if (newProperty == null) {
            throw new IllegalArgumentException("You must provide a property.");
        }
        if (currentProperty != null && currentProperty.getClass().equals(newProperty)) {
            if (!currentProperty.equals(this.property)) {
                throw new IllegalArgumentException("Property mismatch. Current [" + currentProperty + "]. Provided [" + newProperty + ".");
            }
            throw new IllegalArgumentException("Property [" + currentProperty + "] already set.");
        }
    }
}

