/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManager;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManagerService;
import org.jboss.as.domain.management.security.AbstractKeyManagerService;
import org.jboss.as.domain.management.security.AbstractTrustManagerService;
import org.jboss.as.domain.management.security.AdvancedUserSearchResourceDefintion;
import org.jboss.as.domain.management.security.AuthenticationValidatingHandler;
import org.jboss.as.domain.management.security.AuthorizationValidatingHandler;
import org.jboss.as.domain.management.security.BaseLdapGroupSearchResource;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.as.domain.management.security.ClientCertCallbackHandler;
import org.jboss.as.domain.management.security.DomainManagedServerCallbackHandler;
import org.jboss.as.domain.management.security.FileKeyManagerService;
import org.jboss.as.domain.management.security.FileTrustManagerService;
import org.jboss.as.domain.management.security.GroupToPrincipalResourceDefinition;
import org.jboss.as.domain.management.security.JaasAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.JaasCallbackHandler;
import org.jboss.as.domain.management.security.KerberosAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.KerberosCallbackHandler;
import org.jboss.as.domain.management.security.KeystoreAttributes;
import org.jboss.as.domain.management.security.KeytabIdentityFactoryService;
import org.jboss.as.domain.management.security.KeytabResourceDefinition;
import org.jboss.as.domain.management.security.KeytabService;
import org.jboss.as.domain.management.security.LdapAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.LdapAuthorizationResourceDefinition;
import org.jboss.as.domain.management.security.LdapCacheResourceDefinition;
import org.jboss.as.domain.management.security.LdapCacheService;
import org.jboss.as.domain.management.security.LdapEntry;
import org.jboss.as.domain.management.security.LdapGroupSearcherFactory;
import org.jboss.as.domain.management.security.LdapSearcher;
import org.jboss.as.domain.management.security.LdapSearcherCache;
import org.jboss.as.domain.management.security.LdapSubjectSupplementalService;
import org.jboss.as.domain.management.security.LdapUserSearcherFactory;
import org.jboss.as.domain.management.security.LocalAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.LocalCallbackHandlerService;
import org.jboss.as.domain.management.security.PlugInAuthenticationCallbackHandler;
import org.jboss.as.domain.management.security.PlugInAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.PlugInAuthorizationResourceDefinition;
import org.jboss.as.domain.management.security.PlugInLoaderService;
import org.jboss.as.domain.management.security.PlugInSubjectSupplemental;
import org.jboss.as.domain.management.security.PrincipalToGroupResourceDefinition;
import org.jboss.as.domain.management.security.PropertiesAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.PropertiesAuthorizationResourceDefinition;
import org.jboss.as.domain.management.security.PropertiesCallbackHandler;
import org.jboss.as.domain.management.security.PropertiesSubjectSupplemental;
import org.jboss.as.domain.management.security.PropertyResourceDefinition;
import org.jboss.as.domain.management.security.ProviderKeyManagerService;
import org.jboss.as.domain.management.security.ProviderTrustManagerService;
import org.jboss.as.domain.management.security.SSLContextService;
import org.jboss.as.domain.management.security.SSLServerIdentityResourceDefinition;
import org.jboss.as.domain.management.security.SecretIdentityService;
import org.jboss.as.domain.management.security.SecretServerIdentityResourceDefinition;
import org.jboss.as.domain.management.security.SecurityRealmResourceDefinition;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.domain.management.security.SubjectSupplementalService;
import org.jboss.as.domain.management.security.UserDomainCallbackHandler;
import org.jboss.as.domain.management.security.UserIsDnResourceDefintion;
import org.jboss.as.domain.management.security.UserLdapCallbackHandler;
import org.jboss.as.domain.management.security.UserResourceDefinition;
import org.jboss.as.domain.management.security.UserSearchResourceDefintion;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.credential.source.CredentialSource;

public class SecurityRealmAddHandler
extends AbstractAddStepHandler {
    private static final String ELYTRON_CAPABILITY = "org.wildfly.security.elytron";
    private static final String PATH_MANAGER_CAPABILITY = "org.wildfly.management.path-manager";
    public static final SecurityRealmAddHandler INSTANCE = new SecurityRealmAddHandler();

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        super.populateModel(operation, model);
        SecurityRealmResourceDefinition.MAP_GROUPS_TO_ROLES.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        if (!context.isBooting() && context.getProcessType() == ProcessType.EMBEDDED_SERVER && context.getRunningMode() == RunningMode.ADMIN_ONLY) {
            context.reloadRequired();
        } else {
            context.addStep((OperationStepHandler)ServiceInstallStepHandler.INSTANCE, OperationContext.Stage.RUNTIME);
        }
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        if (!context.isBooting() && context.getProcessType() == ProcessType.EMBEDDED_SERVER && context.getRunningMode() == RunningMode.ADMIN_ONLY) {
            context.revertReloadRequired();
        }
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        super.execute(context, operation);
        ModelNode validationOp = AuthenticationValidatingHandler.createOperation(operation);
        context.addStep(validationOp, (OperationStepHandler)AuthenticationValidatingHandler.INSTANCE, OperationContext.Stage.MODEL);
        validationOp = AuthorizationValidatingHandler.createOperation(operation);
        context.addStep(validationOp, (OperationStepHandler)AuthorizationValidatingHandler.INSTANCE, OperationContext.Stage.MODEL);
    }

    protected void installServices(OperationContext context, String realmName, ModelNode model) throws OperationFailedException {
        Supplier<CallbackHandlerService> chsSupplier;
        ModelNode plugIns = model.hasDefined("plug-in") ? model.get("plug-in") : null;
        ModelNode authentication = model.hasDefined("authentication") ? model.get("authentication") : null;
        ModelNode authorization = model.hasDefined("authorization") ? model.get("authorization") : null;
        ModelNode serverIdentities = model.hasDefined("server-identity") ? model.get("server-identity") : null;
        ServiceTarget serviceTarget = context.getServiceTarget();
        boolean mapGroupsToRoles = SecurityRealmResourceDefinition.MAP_GROUPS_TO_ROLES.resolveModelAttribute(context, model).asBoolean();
        ServiceName realmServiceName = SecurityRealm.ServiceUtil.createServiceName(realmName);
        ServiceBuilder realmBuilder = serviceTarget.addService(realmServiceName);
        HashSet<Supplier<CallbackHandlerService>> callbackHandlerServices = new HashSet<Supplier<CallbackHandlerService>>();
        Consumer securityRealmConsumer = realmBuilder.provides(new ServiceName[]{realmServiceName, SecurityRealm.ServiceUtil.createLegacyServiceName(realmName)});
        ServiceName tmpDirPath = ServiceName.JBOSS.append(new String[]{"server", "path", "jboss.controller.temp.dir"});
        boolean shareLdapConnections = this.shareLdapConnection(context, authentication, authorization);
        ModelNode authTruststore = null;
        if (plugIns != null) {
            this.addPlugInLoaderService(realmName, plugIns, serviceTarget);
        }
        if (!context.getProcessType().isServer() && (chsSupplier = this.addDomainManagedServersService(context, realmBuilder)) != null) {
            callbackHandlerServices.add(chsSupplier);
        }
        if (authentication != null) {
            if (authentication.hasDefined("truststore")) {
                authTruststore = authentication.require("truststore");
                callbackHandlerServices.add(this.addClientCertService(realmName, serviceTarget, realmBuilder));
            }
            if (authentication.hasDefined("local")) {
                callbackHandlerServices.add(this.addLocalService(context, authentication.require("local"), realmName, serviceTarget, realmBuilder));
            }
            if (authentication.hasDefined("kerberos")) {
                callbackHandlerServices.add(this.addKerberosService(context, authentication.require("kerberos"), realmName, serviceTarget, realmBuilder));
            }
            if (authentication.hasDefined("jaas")) {
                callbackHandlerServices.add(this.addJaasService(context, authentication.require("jaas"), realmName, serviceTarget, context.isNormalServer(), realmBuilder));
            } else if (authentication.hasDefined("ldap")) {
                callbackHandlerServices.add(this.addLdapService(context, authentication.require("ldap"), realmName, serviceTarget, realmBuilder, shareLdapConnections));
            } else if (authentication.hasDefined("plug-in")) {
                callbackHandlerServices.add(this.addPlugInAuthenticationService(context, authentication.require("plug-in"), realmName, realmName, serviceTarget, realmBuilder));
            } else if (authentication.hasDefined("properties")) {
                callbackHandlerServices.add(this.addPropertiesAuthenticationService(context, authentication.require("properties"), realmName, serviceTarget, realmBuilder));
            } else if (authentication.hasDefined("users")) {
                callbackHandlerServices.add(this.addUsersService(context, authentication.require("users"), realmName, serviceTarget, realmBuilder));
            }
        }
        Supplier<SubjectSupplementalService> subjectSupplementalSupplier = null;
        if (authorization != null) {
            if (authorization.hasDefined("properties")) {
                subjectSupplementalSupplier = this.addPropertiesAuthorizationService(context, authorization.require("properties"), realmName, serviceTarget, realmBuilder);
            } else if (authorization.hasDefined("plug-in")) {
                subjectSupplementalSupplier = this.addPlugInAuthorizationService(context, authorization.require("plug-in"), realmName, serviceTarget, realmBuilder);
            } else if (authorization.hasDefined("ldap")) {
                subjectSupplementalSupplier = this.addLdapAuthorizationService(context, authorization.require("ldap"), realmName, serviceTarget, realmBuilder, shareLdapConnections);
            }
        }
        ModelNode ssl = null;
        Supplier<CallbackHandlerFactory> secretCallbackFactorySupplier = null;
        Supplier<KeytabIdentityFactoryService> keytabFactorySupplier = null;
        if (serverIdentities != null) {
            if (serverIdentities.hasDefined("ssl")) {
                ssl = serverIdentities.require("ssl");
            }
            if (serverIdentities.hasDefined("secret")) {
                secretCallbackFactorySupplier = this.addSecretService(context, serverIdentities.require("secret"), realmName, serviceTarget, realmBuilder);
            }
            if (serverIdentities.hasDefined("kerberos")) {
                keytabFactorySupplier = this.addKerberosIdentityServices(context, serverIdentities.require("kerberos"), realmName, serviceTarget, realmBuilder);
            }
        }
        Supplier<SSLContext> sslContextSupplier = null;
        if (ssl != null || authTruststore != null) {
            sslContextSupplier = this.addSSLServices(context, ssl, authTruststore, realmName, serviceTarget, realmBuilder);
        }
        Supplier tmpDirPathSupplier = realmBuilder.requires(tmpDirPath);
        SecurityRealmService securityRealmService = new SecurityRealmService(securityRealmConsumer, subjectSupplementalSupplier, secretCallbackFactorySupplier, keytabFactorySupplier, sslContextSupplier, tmpDirPathSupplier, callbackHandlerServices, realmName, mapGroupsToRoles);
        realmBuilder.setInstance((Service)securityRealmService);
        realmBuilder.install();
    }

    private boolean shareLdapConnection(OperationContext context, ModelNode authentication, ModelNode authorization) throws OperationFailedException {
        if (authentication == null || authorization == null || !authentication.hasDefined("ldap") || !authorization.hasDefined("ldap")) {
            return false;
        }
        String authConnectionManager = LdapAuthenticationResourceDefinition.CONNECTION.resolveModelAttribute(context, authentication.require("ldap")).asString();
        String authzConnectionManager = LdapAuthorizationResourceDefinition.CONNECTION.resolveModelAttribute(context, authorization.require("ldap")).asString();
        return authConnectionManager.equals(authzConnectionManager);
    }

    private void addPlugInLoaderService(String realmName, ModelNode plugInModel, ServiceTarget serviceTarget) {
        ServiceName plugInLoaderName = PlugInLoaderService.ServiceUtil.createServiceName(realmName);
        List plugIns = plugInModel.asPropertyList();
        ArrayList<String> knownNames = new ArrayList<String>(plugIns.size());
        for (Property current : plugIns) {
            knownNames.add(current.getName());
        }
        ServiceBuilder builder = serviceTarget.addService(plugInLoaderName);
        Consumer pilsConsumer = builder.provides(new ServiceName[]{plugInLoaderName});
        builder.setInstance((Service)new PlugInLoaderService(pilsConsumer, Collections.unmodifiableList(knownNames)));
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private Supplier<CallbackHandlerService> addClientCertService(String realmName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder) {
        ServiceName clientCertServiceName = ClientCertCallbackHandler.ServiceUtil.createServiceName(realmName);
        ServiceBuilder builder = serviceTarget.addService(clientCertServiceName);
        Consumer chsConsumer = builder.provides(new ServiceName[]{clientCertServiceName});
        builder.setInstance((Service)new ClientCertCallbackHandler(chsConsumer));
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
        return CallbackHandlerService.ServiceUtil.requires(realmBuilder, clientCertServiceName);
    }

    private Supplier<CallbackHandlerService> addKerberosService(OperationContext context, ModelNode kerberos, String realmName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder) throws OperationFailedException {
        ServiceName kerberosServiceName = KerberosCallbackHandler.ServiceUtil.createServiceName(realmName);
        boolean removeRealm = KerberosAuthenticationResourceDefinition.REMOVE_REALM.resolveModelAttribute(context, kerberos).asBoolean();
        ServiceBuilder builder = serviceTarget.addService(kerberosServiceName);
        Consumer chsConsumer = builder.provides(new ServiceName[]{kerberosServiceName});
        builder.setInstance((Service)new KerberosCallbackHandler(chsConsumer, removeRealm));
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
        return CallbackHandlerService.ServiceUtil.requires(realmBuilder, kerberosServiceName);
    }

    private Supplier<CallbackHandlerService> addJaasService(OperationContext context, ModelNode jaas, String realmName, ServiceTarget serviceTarget, boolean injectServerManager, ServiceBuilder<?> realmBuilder) throws OperationFailedException {
        ServiceName jaasServiceName = JaasCallbackHandler.ServiceUtil.createServiceName(realmName);
        String name = JaasAuthenticationResourceDefinition.NAME.resolveModelAttribute(context, jaas).asString();
        boolean assignGroups = JaasAuthenticationResourceDefinition.ASSIGN_GROUPS.resolveModelAttribute(context, jaas).asBoolean();
        ServiceBuilder builder = serviceTarget.addService(jaasServiceName);
        Consumer chsConsumer = builder.provides(new ServiceName[]{jaasServiceName});
        Supplier smSupplier = injectServerManager ? builder.requires(ServiceName.JBOSS.append(new String[]{"security", "simple-security-manager"})) : null;
        builder.setInstance((Service)new JaasCallbackHandler(chsConsumer, smSupplier, realmName, name, assignGroups));
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
        return CallbackHandlerService.ServiceUtil.requires(realmBuilder, jaasServiceName);
    }

    private <R, K> LdapCacheService<R, K> createCacheService(Consumer<LdapSearcherCache<R, K>> ldapSearchCacheConsumer, OperationContext context, LdapSearcher<R, K> searcher, ModelNode cache) throws OperationFailedException {
        if (cache != null && cache.isDefined()) {
            ModelNode cacheDefinition = null;
            boolean byAccessTime = false;
            if (cache.hasDefined("by-access-time")) {
                cacheDefinition = cache.require("by-access-time");
                byAccessTime = true;
            } else if (cache.hasDefined("by-search-time")) {
                cacheDefinition = cache.require("by-search-time");
            }
            if (cacheDefinition != null) {
                int evictionTime = LdapCacheResourceDefinition.EVICTION_TIME.resolveModelAttribute(context, cacheDefinition).asInt();
                boolean cacheFailures = LdapCacheResourceDefinition.CACHE_FAILURES.resolveModelAttribute(context, cacheDefinition).asBoolean();
                int maxSize = LdapCacheResourceDefinition.MAX_CACHE_SIZE.resolveModelAttribute(context, cacheDefinition).asInt();
                return byAccessTime ? LdapCacheService.createByAccessCacheService(ldapSearchCacheConsumer, searcher, evictionTime, cacheFailures, maxSize) : LdapCacheService.createBySearchCacheService(ldapSearchCacheConsumer, searcher, evictionTime, cacheFailures, maxSize);
            }
        }
        return LdapCacheService.createNoCacheService(ldapSearchCacheConsumer, searcher);
    }

    private Supplier<CallbackHandlerService> addLdapService(OperationContext context, ModelNode ldap, String realmName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder, boolean shareConnection) throws OperationFailedException {
        ServiceName ldapServiceName = UserLdapCallbackHandler.ServiceUtil.createServiceName(realmName);
        String baseDn = LdapAuthenticationResourceDefinition.BASE_DN.resolveModelAttribute(context, ldap).asString();
        ModelNode node = LdapAuthenticationResourceDefinition.USERNAME_FILTER.resolveModelAttribute(context, ldap);
        String usernameAttribute = node.isDefined() ? node.asString() : null;
        node = LdapAuthenticationResourceDefinition.ADVANCED_FILTER.resolveModelAttribute(context, ldap);
        String advancedFilter = node.isDefined() ? node.asString() : null;
        node = LdapAuthenticationResourceDefinition.USERNAME_LOAD.resolveModelAttribute(context, ldap);
        String usernameLoad = node.isDefined() ? node.asString() : null;
        boolean recursive = LdapAuthenticationResourceDefinition.RECURSIVE.resolveModelAttribute(context, ldap).asBoolean();
        boolean allowEmptyPasswords = LdapAuthenticationResourceDefinition.ALLOW_EMPTY_PASSWORDS.resolveModelAttribute(context, ldap).asBoolean();
        String userDn = LdapAuthenticationResourceDefinition.USER_DN.resolveModelAttribute(context, ldap).asString();
        LdapSearcher<LdapEntry, String> userSearcher = usernameAttribute != null ? LdapUserSearcherFactory.createForUsernameFilter(baseDn, recursive, userDn, usernameAttribute, usernameLoad) : LdapUserSearcherFactory.createForAdvancedFilter(baseDn, recursive, userDn, advancedFilter, usernameLoad);
        ServiceName userSearcherCacheName = LdapSearcherCache.ServiceUtil.createServiceName(true, true, realmName);
        ServiceBuilder userSearchCacheBuilder = serviceTarget.addService(userSearcherCacheName);
        Consumer lscConsumer = userSearchCacheBuilder.provides(new ServiceName[]{userSearcherCacheName});
        userSearchCacheBuilder.setInstance(this.createCacheService(lscConsumer, context, userSearcher, ldap.get("cache")));
        userSearchCacheBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        userSearchCacheBuilder.install();
        ServiceBuilder builder = serviceTarget.addService(ldapServiceName);
        Consumer chsConsumer = builder.provides(new ServiceName[]{ldapServiceName});
        String connectionManager = LdapAuthenticationResourceDefinition.CONNECTION.resolveModelAttribute(context, ldap).asString();
        Supplier<LdapConnectionManager> lcmSupplier = LdapConnectionManagerService.ServiceUtil.requires(builder, connectionManager);
        Supplier<LdapSearcherCache<LdapEntry, String>> uscSupplier = LdapSearcherCache.ServiceUtil.requires(builder, true, true, realmName);
        builder.setInstance((Service)new UserLdapCallbackHandler(chsConsumer, lcmSupplier, uscSupplier, allowEmptyPasswords, shareConnection));
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
        return CallbackHandlerService.ServiceUtil.requires(realmBuilder, ldapServiceName);
    }

    private Supplier<CallbackHandlerService> addLocalService(OperationContext context, ModelNode local, String realmName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder) throws OperationFailedException {
        ServiceName localServiceName = LocalCallbackHandlerService.ServiceUtil.createServiceName(realmName);
        ModelNode node = LocalAuthenticationResourceDefinition.DEFAULT_USER.resolveModelAttribute(context, local);
        String defaultUser = node.isDefined() ? node.asString() : null;
        node = LocalAuthenticationResourceDefinition.ALLOWED_USERS.resolveModelAttribute(context, local);
        String allowedUsers = node.isDefined() ? node.asString() : null;
        node = LocalAuthenticationResourceDefinition.SKIP_GROUP_LOADING.resolveModelAttribute(context, local);
        boolean skipGroupLoading = node.asBoolean();
        ServiceBuilder builder = serviceTarget.addService(localServiceName);
        Consumer chsConsumer = builder.provides(new ServiceName[]{localServiceName});
        builder.setInstance((Service)new LocalCallbackHandlerService(chsConsumer, defaultUser, allowedUsers, skipGroupLoading));
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
        return CallbackHandlerService.ServiceUtil.requires(realmBuilder, localServiceName);
    }

    private Supplier<CallbackHandlerService> addDomainManagedServersService(OperationContext context, ServiceBuilder<?> realmBuilder) {
        ServiceRegistry registry = context.getServiceRegistry(false);
        ServiceController serviceController = registry.getService(DomainManagedServerCallbackHandler.SERVICE_NAME);
        if (serviceController != null) {
            return CallbackHandlerService.ServiceUtil.requires(realmBuilder, DomainManagedServerCallbackHandler.SERVICE_NAME);
        }
        return null;
    }

    private Supplier<CallbackHandlerService> addPlugInAuthenticationService(OperationContext context, ModelNode model, String realmName, String registryName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder) throws OperationFailedException {
        ServiceName plugInServiceName = PlugInAuthenticationCallbackHandler.ServiceUtil.createServiceName(realmName);
        String pluginName = PlugInAuthorizationResourceDefinition.NAME.resolveModelAttribute(context, model).asString();
        Map<String, String> properties = SecurityRealmAddHandler.resolveProperties(context, model);
        String mechanismName = PlugInAuthenticationResourceDefinition.MECHANISM.resolveModelAttribute(context, model).asString();
        AuthMechanism mechanism = AuthMechanism.valueOf(mechanismName);
        ServiceBuilder plugInBuilder = serviceTarget.addService(plugInServiceName);
        Consumer chsConsumer = plugInBuilder.provides(new ServiceName[]{plugInServiceName});
        Supplier<PlugInLoaderService> pilSupplier = PlugInLoaderService.ServiceUtil.requires(plugInBuilder, realmName);
        plugInBuilder.setInstance((Service)new PlugInAuthenticationCallbackHandler(chsConsumer, pilSupplier, registryName, pluginName, properties, mechanism));
        plugInBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        plugInBuilder.install();
        return CallbackHandlerService.ServiceUtil.requires(realmBuilder, plugInServiceName);
    }

    private Supplier<CallbackHandlerService> addPropertiesAuthenticationService(OperationContext context, ModelNode properties, String realmName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder) throws OperationFailedException {
        ServiceName propsServiceName = PropertiesCallbackHandler.ServiceUtil.createServiceName(realmName);
        String path = PropertiesAuthenticationResourceDefinition.PATH.resolveModelAttribute(context, properties).asString();
        ModelNode relativeToNode = PropertiesAuthenticationResourceDefinition.RELATIVE_TO.resolveModelAttribute(context, properties);
        boolean plainText = PropertiesAuthenticationResourceDefinition.PLAIN_TEXT.resolveModelAttribute(context, properties).asBoolean();
        String relativeTo = relativeToNode.isDefined() ? relativeToNode.asString() : null;
        ServiceBuilder builder = serviceTarget.addService(propsServiceName);
        Consumer chsConsumer = builder.provides(new ServiceName[]{propsServiceName});
        Supplier pmSupplier = null;
        if (relativeTo != null) {
            pmSupplier = builder.requires(context.getCapabilityServiceName(PATH_MANAGER_CAPABILITY, PathManager.class));
            builder.requires(SecurityRealmAddHandler.pathName(relativeTo));
        }
        builder.setInstance((Service)new PropertiesCallbackHandler(chsConsumer, pmSupplier, realmName, path, relativeTo, plainText));
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
        return CallbackHandlerService.ServiceUtil.requires(realmBuilder, propsServiceName);
    }

    private Supplier<SubjectSupplementalService> addPropertiesAuthorizationService(OperationContext context, ModelNode properties, String realmName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder) throws OperationFailedException {
        ServiceName propsServiceName = PropertiesSubjectSupplemental.ServiceUtil.createServiceName(realmName);
        String path = PropertiesAuthorizationResourceDefinition.PATH.resolveModelAttribute(context, properties).asString();
        ModelNode relativeToNode = PropertiesAuthorizationResourceDefinition.RELATIVE_TO.resolveModelAttribute(context, properties);
        String relativeTo = relativeToNode.isDefined() ? relativeToNode.asString() : null;
        ServiceBuilder builder = serviceTarget.addService(propsServiceName);
        Consumer sssConsumer = builder.provides(new ServiceName[]{propsServiceName});
        Supplier pmSupplier = null;
        if (relativeTo != null) {
            pmSupplier = builder.requires(context.getCapabilityServiceName(PATH_MANAGER_CAPABILITY, PathManager.class));
            builder.requires(SecurityRealmAddHandler.pathName(relativeTo));
        }
        builder.setInstance((Service)new PropertiesSubjectSupplemental(sssConsumer, pmSupplier, realmName, path, relativeTo));
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
        return SubjectSupplementalService.ServiceUtil.requires(realmBuilder, propsServiceName);
    }

    private Supplier<SubjectSupplementalService> addPlugInAuthorizationService(OperationContext context, ModelNode model, String realmName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder) throws OperationFailedException {
        ServiceName plugInServiceName = PlugInSubjectSupplemental.ServiceUtil.createServiceName(realmName);
        String pluginName = PlugInAuthorizationResourceDefinition.NAME.resolveModelAttribute(context, model).asString();
        Map<String, String> properties = SecurityRealmAddHandler.resolveProperties(context, model);
        ServiceBuilder builder = serviceTarget.addService(plugInServiceName);
        Consumer sssConsumer = builder.provides(new ServiceName[]{plugInServiceName});
        Supplier<PlugInLoaderService> pilSupplier = PlugInLoaderService.ServiceUtil.requires(builder, realmName);
        builder.setInstance((Service)new PlugInSubjectSupplemental(sssConsumer, pilSupplier, realmName, pluginName, properties));
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
        return SubjectSupplementalService.ServiceUtil.requires(realmBuilder, plugInServiceName);
    }

    private Supplier<SubjectSupplementalService> addLdapAuthorizationService(OperationContext context, ModelNode ldap, String realmName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder, boolean shareConnection) throws OperationFailedException {
        LdapSearcher<LdapEntry[], LdapEntry> groupSearcher;
        ServiceName ldapName = LdapSubjectSupplementalService.ServiceUtil.createServiceName(realmName);
        LdapSearcher<LdapEntry, String> userSearcher = null;
        boolean forceUserDnSearch = false;
        ModelNode userCache = null;
        if (ldap.hasDefined("username-to-dn")) {
            String userDnAttribute;
            boolean recursive;
            String baseDn;
            ModelNode usernameToDn = ldap.require("username-to-dn");
            if (usernameToDn.hasDefined("username-is-dn")) {
                ModelNode usernameIsDn = usernameToDn.require("username-is-dn");
                userCache = usernameIsDn.get("cache");
                forceUserDnSearch = UserIsDnResourceDefintion.FORCE.resolveModelAttribute(context, usernameIsDn).asBoolean();
                userSearcher = LdapUserSearcherFactory.createForUsernameIsDn();
            } else if (usernameToDn.hasDefined("username-filter")) {
                ModelNode usernameFilter = usernameToDn.require("username-filter");
                userCache = usernameFilter.get("cache");
                forceUserDnSearch = UserSearchResourceDefintion.FORCE.resolveModelAttribute(context, usernameFilter).asBoolean();
                baseDn = UserSearchResourceDefintion.BASE_DN.resolveModelAttribute(context, usernameFilter).asString();
                recursive = UserSearchResourceDefintion.RECURSIVE.resolveModelAttribute(context, usernameFilter).asBoolean();
                userDnAttribute = UserSearchResourceDefintion.USER_DN_ATTRIBUTE.resolveModelAttribute(context, usernameFilter).asString();
                String usernameAttribute = UserSearchResourceDefintion.ATTRIBUTE.resolveModelAttribute(context, usernameFilter).asString();
                userSearcher = LdapUserSearcherFactory.createForUsernameFilter(baseDn, recursive, userDnAttribute, usernameAttribute, null);
            } else if (usernameToDn.hasDefined("advanced-filter")) {
                ModelNode advancedFilter = usernameToDn.require("advanced-filter");
                userCache = advancedFilter.get("cache");
                forceUserDnSearch = AdvancedUserSearchResourceDefintion.FORCE.resolveModelAttribute(context, advancedFilter).asBoolean();
                baseDn = AdvancedUserSearchResourceDefintion.BASE_DN.resolveModelAttribute(context, advancedFilter).asString();
                recursive = AdvancedUserSearchResourceDefintion.RECURSIVE.resolveModelAttribute(context, advancedFilter).asBoolean();
                userDnAttribute = AdvancedUserSearchResourceDefintion.USER_DN_ATTRIBUTE.resolveModelAttribute(context, advancedFilter).asString();
                String filter = AdvancedUserSearchResourceDefintion.FILTER.resolveModelAttribute(context, advancedFilter).asString();
                userSearcher = LdapUserSearcherFactory.createForAdvancedFilter(baseDn, recursive, userDnAttribute, filter, null);
            }
        }
        if (userSearcher != null) {
            ServiceName userSearcherCacheName = LdapSearcherCache.ServiceUtil.createServiceName(false, true, realmName);
            ServiceBuilder userSearchCacheBuilder = serviceTarget.addService(userSearcherCacheName);
            Consumer lscConsumer = userSearchCacheBuilder.provides(new ServiceName[]{userSearcherCacheName});
            userSearchCacheBuilder.setInstance(this.createCacheService(lscConsumer, context, userSearcher, userCache));
            userSearchCacheBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND);
            userSearchCacheBuilder.install();
        }
        ModelNode groupSearch = ldap.require("group-search");
        boolean iterative = false;
        BaseLdapGroupSearchResource.GroupName groupName = BaseLdapGroupSearchResource.GroupName.DISTINGUISHED_NAME;
        ModelNode groupCache = null;
        if (groupSearch.hasDefined("group-to-principal")) {
            ModelNode groupToPrincipal = groupSearch.require("group-to-principal");
            groupCache = groupToPrincipal.get("cache");
            String baseDn = GroupToPrincipalResourceDefinition.BASE_DN.resolveModelAttribute(context, groupToPrincipal).asString();
            String groupDnAttribute = GroupToPrincipalResourceDefinition.GROUP_DN_ATTRIBUTE.resolveModelAttribute(context, groupToPrincipal).asString();
            groupName = BaseLdapGroupSearchResource.GroupName.valueOf(GroupToPrincipalResourceDefinition.GROUP_NAME.resolveModelAttribute(context, groupToPrincipal).asString());
            String groupNameAttribute = GroupToPrincipalResourceDefinition.GROUP_NAME_ATTRIBUTE.resolveModelAttribute(context, groupToPrincipal).asString();
            iterative = GroupToPrincipalResourceDefinition.ITERATIVE.resolveModelAttribute(context, groupToPrincipal).asBoolean();
            String principalAttribute = GroupToPrincipalResourceDefinition.PRINCIPAL_ATTRIBUTE.resolveModelAttribute(context, groupToPrincipal).asString();
            boolean recursive = GroupToPrincipalResourceDefinition.RECURSIVE.resolveModelAttribute(context, groupToPrincipal).asBoolean();
            BaseLdapGroupSearchResource.GroupName searchBy = BaseLdapGroupSearchResource.GroupName.valueOf(GroupToPrincipalResourceDefinition.SEARCH_BY.resolveModelAttribute(context, groupToPrincipal).asString());
            boolean preferOriginalConnection = GroupToPrincipalResourceDefinition.PREFER_ORIGINAL_CONNECTION.resolveModelAttribute(context, groupToPrincipal).asBoolean();
            groupSearcher = LdapGroupSearcherFactory.createForGroupToPrincipal(baseDn, groupDnAttribute, groupNameAttribute, principalAttribute, recursive, searchBy, preferOriginalConnection);
        } else {
            ModelNode principalToGroup = groupSearch.require("principal-to-group");
            groupCache = principalToGroup.get("cache");
            String groupAttribute = PrincipalToGroupResourceDefinition.GROUP_ATTRIBUTE.resolveModelAttribute(context, principalToGroup).asString();
            boolean preferOriginalConnection = PrincipalToGroupResourceDefinition.PREFER_ORIGINAL_CONNECTION.resolveModelAttribute(context, principalToGroup).asBoolean();
            String groupDnAttribute = PrincipalToGroupResourceDefinition.GROUP_DN_ATTRIBUTE.resolveModelAttribute(context, principalToGroup).asString();
            groupName = BaseLdapGroupSearchResource.GroupName.valueOf(PrincipalToGroupResourceDefinition.GROUP_NAME.resolveModelAttribute(context, principalToGroup).asString());
            String groupNameAttribute = PrincipalToGroupResourceDefinition.GROUP_NAME_ATTRIBUTE.resolveModelAttribute(context, principalToGroup).asString();
            iterative = PrincipalToGroupResourceDefinition.ITERATIVE.resolveModelAttribute(context, principalToGroup).asBoolean();
            boolean skipMissingGroups = PrincipalToGroupResourceDefinition.SKIP_MISSING_GROUPS.resolveModelAttribute(context, principalToGroup).asBoolean();
            boolean shouldParseGroupFromDN = PrincipalToGroupResourceDefinition.PARSE_ROLES_FROM_DN.resolveModelAttribute(context, principalToGroup).asBoolean();
            groupSearcher = LdapGroupSearcherFactory.createForPrincipalToGroup(groupAttribute, groupNameAttribute, preferOriginalConnection, skipMissingGroups, BaseLdapGroupSearchResource.GroupName.SIMPLE == groupName, shouldParseGroupFromDN);
        }
        ServiceName groupCacheServiceName = LdapSearcherCache.ServiceUtil.createServiceName(false, false, realmName);
        ServiceBuilder groupCacheBuilder = serviceTarget.addService(groupCacheServiceName);
        Consumer lscConsumer = groupCacheBuilder.provides(new ServiceName[]{groupCacheServiceName});
        groupCacheBuilder.setInstance(this.createCacheService(lscConsumer, context, groupSearcher, groupCache));
        groupCacheBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        groupCacheBuilder.install();
        String connectionName = LdapAuthorizationResourceDefinition.CONNECTION.resolveModelAttribute(context, ldap).asString();
        ServiceBuilder ldapBuilder = serviceTarget.addService(ldapName);
        Consumer sssConsumer = ldapBuilder.provides(new ServiceName[]{ldapName});
        Supplier<LdapConnectionManager> lcmSupplier = LdapConnectionManagerService.ServiceUtil.requires(ldapBuilder, connectionName);
        Supplier<LdapSearcherCache<LdapEntry, String>> usSupplier = null;
        if (userSearcher != null) {
            usSupplier = LdapSearcherCache.ServiceUtil.requires(ldapBuilder, false, true, realmName);
        }
        Supplier<LdapSearcherCache<LdapEntry[], LdapEntry>> gsSupplier = LdapSearcherCache.ServiceUtil.requires(ldapBuilder, false, false, realmName);
        ldapBuilder.setInstance((Service)new LdapSubjectSupplementalService(sssConsumer, lcmSupplier, usSupplier, gsSupplier, realmName, shareConnection, forceUserDnSearch, iterative, groupName));
        ldapBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        ldapBuilder.install();
        return SubjectSupplementalService.ServiceUtil.requires(realmBuilder, ldapName);
    }

    private Supplier<SSLContext> addSSLServices(OperationContext context, ModelNode ssl, ModelNode trustStore, String realmName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder) throws OperationFailedException {
        Consumer sslContextConsumer;
        ssl = ssl == null ? new ModelNode() : ssl;
        ServiceName keyManagerServiceName = null;
        String provider = KeystoreAttributes.KEYSTORE_PROVIDER.resolveModelAttribute(context, ssl).asString();
        if (ssl.hasDefined("keystore-path") || !"JKS".equalsIgnoreCase(provider)) {
            keyManagerServiceName = AbstractKeyManagerService.ServiceUtil.createServiceName(SecurityRealm.ServiceUtil.createServiceName(realmName));
            this.addKeyManagerService(context, ssl, keyManagerServiceName, serviceTarget);
        }
        ServiceName trustManagerServiceName = null;
        if (trustStore != null) {
            trustManagerServiceName = AbstractTrustManagerService.ServiceUtil.createServiceName(SecurityRealm.ServiceUtil.createServiceName(realmName));
            this.addTrustManagerService(context, trustStore, trustManagerServiceName, serviceTarget);
        }
        String protocol = SSLServerIdentityResourceDefinition.PROTOCOL.resolveModelAttribute(context, ssl).asString();
        HashSet<String> enabledCipherSuites = new HashSet<String>();
        ModelNode suitesNode = SSLServerIdentityResourceDefinition.ENABLED_CIPHER_SUITES.resolveModelAttribute(context, ssl);
        if (suitesNode.isDefined()) {
            List list = suitesNode.asList();
            for (ModelNode current : list) {
                enabledCipherSuites.add(current.asString());
            }
        }
        HashSet<String> enabledProtocols = new HashSet<String>();
        ModelNode protocolsNode = SSLServerIdentityResourceDefinition.ENABLED_PROTOCOLS.resolveModelAttribute(context, ssl);
        if (protocolsNode.isDefined()) {
            List list = protocolsNode.asList();
            for (ModelNode current : list) {
                enabledProtocols.add(current.asString());
            }
        }
        ServiceName fullServiceName = SSLContextService.ServiceUtil.createServiceName(SecurityRealm.ServiceUtil.createServiceName(realmName), false);
        ServiceName trustOnlyServiceName = SSLContextService.ServiceUtil.createServiceName(SecurityRealm.ServiceUtil.createServiceName(realmName), true);
        Consumer serviceBuilderConsumer = s -> {};
        try {
            serviceBuilderConsumer = (Consumer)context.getCapabilityRuntimeAPI(ELYTRON_CAPABILITY, Consumer.class);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (keyManagerServiceName != null) {
            ServiceBuilder fullBuilder = serviceTarget.addService(fullServiceName);
            sslContextConsumer = fullBuilder.provides(new ServiceName[]{fullServiceName});
            Supplier<AbstractKeyManagerService> keyManagersSupplier = AbstractKeyManagerService.ServiceUtil.requires(fullBuilder, SecurityRealm.ServiceUtil.createServiceName(realmName));
            Supplier<TrustManager[]> trustManagersSupplier = trustManagerServiceName != null ? AbstractTrustManagerService.ServiceUtil.requires(fullBuilder, SecurityRealm.ServiceUtil.createServiceName(realmName)) : null;
            fullBuilder.setInstance((Service)new SSLContextService(sslContextConsumer, keyManagersSupplier, trustManagersSupplier, protocol, enabledCipherSuites, enabledProtocols));
            serviceBuilderConsumer.accept(fullBuilder);
            fullBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND);
            fullBuilder.install();
        }
        ServiceBuilder trustBuilder = serviceTarget.addService(trustOnlyServiceName);
        sslContextConsumer = keyManagerServiceName != null ? trustBuilder.provides(new ServiceName[]{trustOnlyServiceName}) : trustBuilder.provides(new ServiceName[]{trustOnlyServiceName, fullServiceName});
        Supplier<TrustManager[]> trustManagersSupplier = trustManagerServiceName != null ? AbstractTrustManagerService.ServiceUtil.requires(trustBuilder, SecurityRealm.ServiceUtil.createServiceName(realmName)) : null;
        trustBuilder.setInstance((Service)new SSLContextService(sslContextConsumer, null, trustManagersSupplier, protocol, enabledCipherSuites, enabledProtocols));
        serviceBuilderConsumer.accept(trustBuilder);
        trustBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        trustBuilder.install();
        return SSLContextService.ServiceUtil.requires(realmBuilder, SecurityRealm.ServiceUtil.createServiceName(realmName), false);
    }

    private void addKeyManagerService(OperationContext context, ModelNode ssl, ServiceName serviceName, ServiceTarget serviceTarget) throws OperationFailedException {
        ServiceBuilder serviceBuilder;
        ModelNode pathNode;
        ModelNode keystorePasswordNode = KeystoreAttributes.KEYSTORE_PASSWORD.resolveModelAttribute(context, ssl);
        char[] keystorePassword = keystorePasswordNode.isDefined() ? keystorePasswordNode.asString().toCharArray() : null;
        ModelNode providerNode = KeystoreAttributes.KEYSTORE_PROVIDER.resolveModelAttribute(context, ssl);
        String provider = providerNode.isDefined() ? providerNode.asString() : null;
        String autoGenerateCertHostName = null;
        ModelNode autoGenerateCertHostNode = KeystoreAttributes.GENERATE_SELF_SIGNED_CERTIFICATE_HOST.resolveModelAttribute(context, ssl);
        if (autoGenerateCertHostNode.isDefined()) {
            autoGenerateCertHostName = autoGenerateCertHostNode.asString();
        }
        if (!(pathNode = KeystoreAttributes.KEYSTORE_PATH.resolveModelAttribute(context, ssl)).isDefined()) {
            serviceBuilder = serviceTarget.addService(serviceName);
            Consumer kmsConsumer = serviceBuilder.provides(new ServiceName[]{serviceName});
            serviceBuilder.setInstance((Service)new ProviderKeyManagerService((Consumer<AbstractKeyManagerService>)kmsConsumer, null, null, provider, keystorePassword));
        } else {
            String path = pathNode.asString();
            ModelNode keyPasswordNode = KeystoreAttributes.KEY_PASSWORD.resolveModelAttribute(context, ssl);
            char[] keyPassword = keyPasswordNode.isDefined() ? keyPasswordNode.asString().toCharArray() : null;
            ModelNode relativeToNode = KeystoreAttributes.KEYSTORE_RELATIVE_TO.resolveModelAttribute(context, ssl);
            String relativeTo = relativeToNode.isDefined() ? relativeToNode.asString() : null;
            ModelNode aliasNode = KeystoreAttributes.ALIAS.resolveModelAttribute(context, ssl);
            String alias = aliasNode.isDefined() ? aliasNode.asString() : null;
            serviceBuilder = serviceTarget.addService(serviceName);
            Consumer kmsConsumer = serviceBuilder.provides(new ServiceName[]{serviceName});
            Supplier pathManagerSupplier = null;
            if (relativeTo != null) {
                pathManagerSupplier = serviceBuilder.requires(context.getCapabilityServiceName(PATH_MANAGER_CAPABILITY, PathManager.class));
                serviceBuilder.requires(SecurityRealmAddHandler.pathName(relativeTo));
            }
            ExceptionSupplier keyCredentialSourceSupplier = null;
            ExceptionSupplier keystoreCredentialSourceSupplier = null;
            if (ssl.hasDefined("keystore-password-credential-reference")) {
                keyCredentialSourceSupplier = CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)KeystoreAttributes.KEYSTORE_PASSWORD_CREDENTIAL_REFERENCE, (ModelNode)ssl, (ServiceBuilder)serviceBuilder);
            }
            if (ssl.hasDefined("key-password-credential-reference")) {
                keystoreCredentialSourceSupplier = CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)KeystoreAttributes.KEY_PASSWORD_CREDENTIAL_REFERENCE, (ModelNode)ssl, (ServiceBuilder)serviceBuilder);
            }
            serviceBuilder.setInstance((Service)new FileKeyManagerService(kmsConsumer, pathManagerSupplier, (ExceptionSupplier<CredentialSource, Exception>)keyCredentialSourceSupplier, (ExceptionSupplier<CredentialSource, Exception>)keystoreCredentialSourceSupplier, provider, path, relativeTo, keystorePassword, keyPassword, alias, autoGenerateCertHostName));
        }
        serviceBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        serviceBuilder.install();
    }

    private void addTrustManagerService(OperationContext context, ModelNode ssl, ServiceName serviceName, ServiceTarget serviceTarget) throws OperationFailedException {
        ServiceBuilder serviceBuilder;
        ModelNode keystorePasswordNode = KeystoreAttributes.KEYSTORE_PASSWORD.resolveModelAttribute(context, ssl);
        char[] keystorePassword = keystorePasswordNode.isDefined() ? keystorePasswordNode.asString().toCharArray() : null;
        String provider = KeystoreAttributes.KEYSTORE_PROVIDER.resolveModelAttribute(context, ssl).asString();
        if (!"JKS".equalsIgnoreCase(provider)) {
            serviceBuilder = serviceTarget.addService(serviceName);
            Consumer trustManagersConsumer = serviceBuilder.provides(new ServiceName[]{serviceName});
            ExceptionSupplier credentialSourceSupplier = null;
            if (ssl.hasDefined("keystore-password-credential-reference")) {
                credentialSourceSupplier = CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)KeystoreAttributes.KEYSTORE_PASSWORD_CREDENTIAL_REFERENCE, (ModelNode)ssl, (ServiceBuilder)serviceBuilder);
            }
            serviceBuilder.setInstance((Service)new ProviderTrustManagerService(trustManagersConsumer, (ExceptionSupplier<CredentialSource, Exception>)credentialSourceSupplier, provider, keystorePassword));
        } else {
            String path = KeystoreAttributes.KEYSTORE_PATH.resolveModelAttribute(context, ssl).asString();
            ModelNode relativeToNode = KeystoreAttributes.KEYSTORE_RELATIVE_TO.resolveModelAttribute(context, ssl);
            String relativeTo = relativeToNode.isDefined() ? relativeToNode.asString() : null;
            serviceBuilder = serviceTarget.addService(serviceName);
            Consumer trustManagersConsumer = serviceBuilder.provides(new ServiceName[]{serviceName});
            Supplier pathManagerSupplier = null;
            if (relativeTo != null) {
                pathManagerSupplier = serviceBuilder.requires(context.getCapabilityServiceName(PATH_MANAGER_CAPABILITY, PathManager.class));
                serviceBuilder.requires(SecurityRealmAddHandler.pathName(relativeTo));
            }
            ExceptionSupplier credentialSourceSupplier = null;
            if (ssl.hasDefined("keystore-password-credential-reference")) {
                credentialSourceSupplier = CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)KeystoreAttributes.KEYSTORE_PASSWORD_CREDENTIAL_REFERENCE, (ModelNode)ssl, (ServiceBuilder)serviceBuilder);
            }
            serviceBuilder.setInstance((Service)new FileTrustManagerService(trustManagersConsumer, pathManagerSupplier, (ExceptionSupplier<CredentialSource, Exception>)credentialSourceSupplier, provider, path, relativeTo, keystorePassword));
        }
        serviceBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        serviceBuilder.install();
    }

    private Supplier<CallbackHandlerFactory> addSecretService(OperationContext context, ModelNode secret, String realmName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder) throws OperationFailedException {
        ServiceName secretServiceName = SecretIdentityService.ServiceUtil.createServiceName(realmName);
        ModelNode resolvedValueNode = SecretServerIdentityResourceDefinition.VALUE.resolveModelAttribute(context, secret);
        boolean base64 = secret.get(SecretServerIdentityResourceDefinition.VALUE.getName()).getType() != ModelType.EXPRESSION;
        ServiceBuilder builder = serviceTarget.addService(secretServiceName);
        Consumer chfConsumer = builder.provides(new ServiceName[]{secretServiceName});
        ExceptionSupplier credentialSourceSupplier = null;
        if (secret.hasDefined("credential-reference")) {
            credentialSourceSupplier = CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)SecretServerIdentityResourceDefinition.CREDENTIAL_REFERENCE, (ModelNode)secret, (ServiceBuilder)builder);
        }
        SecretIdentityService sis = secret.hasDefined("credential-reference") ? new SecretIdentityService(chfConsumer, (ExceptionSupplier<CredentialSource, Exception>)credentialSourceSupplier, resolvedValueNode.asString(), false) : new SecretIdentityService(chfConsumer, (ExceptionSupplier<CredentialSource, Exception>)credentialSourceSupplier, resolvedValueNode.asString(), base64);
        builder.setInstance((Service)sis);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
        return CallbackHandlerFactory.ServiceUtil.requires(realmBuilder, secretServiceName);
    }

    private Supplier<KeytabIdentityFactoryService> addKerberosIdentityServices(OperationContext context, ModelNode kerberos, String realmName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder) throws OperationFailedException {
        ServiceName keyIdentityName = KeytabIdentityFactoryService.ServiceUtil.createServiceName(realmName);
        ServiceBuilder kifsBuilder = serviceTarget.addService(keyIdentityName);
        Consumer kifsConsumer = kifsBuilder.provides(new ServiceName[]{keyIdentityName});
        KeytabIdentityFactoryService kifs = new KeytabIdentityFactoryService(kifsConsumer);
        kifsBuilder.setInstance((Service)kifs);
        kifsBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        if (kerberos.hasDefined("keytab")) {
            List keytabList = kerberos.get("keytab").asPropertyList();
            for (Property current : keytabList) {
                String[] forHostsValues;
                String principal = current.getName();
                ModelNode keytab = current.getValue();
                String path = KeytabResourceDefinition.PATH.resolveModelAttribute(context, keytab).asString();
                ModelNode relativeToNode = KeytabResourceDefinition.RELATIVE_TO.resolveModelAttribute(context, keytab);
                String relativeTo = relativeToNode.isDefined() ? relativeToNode.asString() : null;
                boolean debug = KeytabResourceDefinition.DEBUG.resolveModelAttribute(context, keytab).asBoolean();
                ModelNode forHosts = KeytabResourceDefinition.FOR_HOSTS.resolveModelAttribute(context, keytab);
                if (forHosts.isDefined()) {
                    List list = forHosts.asList();
                    forHostsValues = new String[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        forHostsValues[i] = ((ModelNode)list.get(i)).asString();
                    }
                } else {
                    forHostsValues = new String[]{};
                }
                ServiceName keytabName = KeytabService.ServiceUtil.createServiceName(realmName, principal);
                ServiceBuilder keytabBuilder = serviceTarget.addService(keytabName);
                Consumer ksConsumer = keytabBuilder.provides(new ServiceName[]{keytabName});
                Supplier pathManagerSupplier = null;
                if (relativeTo != null) {
                    pathManagerSupplier = keytabBuilder.requires(context.getCapabilityServiceName(PATH_MANAGER_CAPABILITY, PathManager.class));
                    keytabBuilder.requires(SecurityRealmAddHandler.pathName(relativeTo));
                }
                keytabBuilder.setInstance((Service)new KeytabService(ksConsumer, pathManagerSupplier, principal, path, relativeTo, forHostsValues, debug));
                keytabBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND);
                keytabBuilder.install();
                kifs.addKeytabSupplier(KeytabService.ServiceUtil.requires(kifsBuilder, realmName, principal));
            }
        }
        kifsBuilder.install();
        return KeytabIdentityFactoryService.ServiceUtil.requires(realmBuilder, realmName);
    }

    private Supplier<CallbackHandlerService> addUsersService(OperationContext context, ModelNode users, String realmName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder) throws OperationFailedException {
        ServiceName usersServiceName = UserDomainCallbackHandler.ServiceUtil.createServiceName(realmName);
        ServiceBuilder builder = serviceTarget.addService(usersServiceName);
        Consumer chsConsumer = builder.provides(new ServiceName[]{usersServiceName});
        builder.setInstance((Service)new UserDomainCallbackHandler(chsConsumer, this.unmaskUsersCredentials(context, builder, users.clone()), realmName, this.unmaskUsersPasswords(context, users)));
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
        return CallbackHandlerService.ServiceUtil.requires(realmBuilder, usersServiceName);
    }

    private static ServiceName pathName(String relativeTo) {
        return ServiceName.JBOSS.append(new String[]{"server", "path", relativeTo});
    }

    private ModelNode unmaskUsersPasswords(OperationContext context, ModelNode users) throws OperationFailedException {
        users = users.clone();
        for (Property property : users.get("user").asPropertyList()) {
            ModelNode user = users.get(new String[]{"user", property.getName()});
            if (!user.hasDefined("password")) continue;
            user.set("password", context.resolveExpressions(user.get("password")).asString());
        }
        return users;
    }

    private Map<String, ExceptionSupplier<CredentialSource, Exception>> unmaskUsersCredentials(OperationContext context, ServiceBuilder<?> serviceBuilder, ModelNode users) throws OperationFailedException {
        HashMap<String, ExceptionSupplier<CredentialSource, Exception>> suppliers = new HashMap<String, ExceptionSupplier<CredentialSource, Exception>>();
        for (Property property : users.get("user").asPropertyList()) {
            ModelNode user = users.get(new String[]{"user", property.getName()});
            if (!user.hasDefined("credential-reference")) continue;
            suppliers.put(property.getName(), (ExceptionSupplier<CredentialSource, Exception>)CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)UserResourceDefinition.CREDENTIAL_REFERENCE, (ModelNode)user, serviceBuilder));
        }
        return suppliers;
    }

    private static Map<String, String> resolveProperties(OperationContext context, ModelNode model) throws OperationFailedException {
        Map<String, String> configurationProperties;
        if (model.hasDefined("property")) {
            List propertyList = model.require("property").asPropertyList();
            configurationProperties = new HashMap<String, String>(propertyList.size());
            for (Property current : propertyList) {
                String propertyName = current.getName();
                ModelNode valueNode = PropertyResourceDefinition.VALUE.resolveModelAttribute(context, current.getValue());
                String value = valueNode.isDefined() ? valueNode.asString() : null;
                configurationProperties.put(propertyName, value);
            }
            configurationProperties = Collections.unmodifiableMap(configurationProperties);
        } else {
            configurationProperties = Collections.emptyMap();
        }
        return configurationProperties;
    }

    private static class ServiceInstallStepHandler
    implements OperationStepHandler {
        private static final ServiceInstallStepHandler INSTANCE = new ServiceInstallStepHandler();

        private ServiceInstallStepHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
            INSTANCE.installServices(context, context.getCurrentAddressValue(), model);
        }
    }
}

