/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.opentracing;

import io.jaegertracing.Configuration;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopTracer;
import io.opentracing.noop.NoopTracerFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.common.ServletContextAttribute;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.as.weld.WeldCapability;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.DispatcherType;
import org.jboss.metadata.web.spec.FilterMappingMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.FiltersMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.wildfly.extension.microprofile.opentracing.TracingExtensionLogger;
import org.wildfly.microprofile.opentracing.smallrye.TracingLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

public class TracingDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final AttachmentKey<Tracer> ATTACHMENT_KEY = AttachmentKey.create(Tracer.class);

    public void deploy(DeploymentPhaseContext deploymentPhaseContext) throws DeploymentUnitProcessingException {
        TracingExtensionLogger.ROOT_LOGGER.processingDeployment();
        DeploymentUnit deploymentUnit = deploymentPhaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        try {
            WeldCapability weldCapability = (WeldCapability)support.getCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class);
            if (!weldCapability.isPartOfWeldDeployment(deploymentUnit)) {
                TracingExtensionLogger.ROOT_LOGGER.noCdiDeployment();
                return;
            }
        }
        catch (CapabilityServiceSupport.NoSuchCapabilityException e) {
            throw new DeploymentUnitProcessingException(TracingExtensionLogger.ROOT_LOGGER.deploymentRequiresCapability(deploymentPhaseContext.getDeploymentUnit().getName(), "org.wildfly.weld"));
        }
        this.setServiceName(deploymentUnit);
        this.injectTracer(deploymentPhaseContext, support);
    }

    private void setServiceName(DeploymentUnit deploymentUnit) {
        JBossWebMetaData jbossWebMetaData = this.getJBossWebMetaData(deploymentUnit);
        if (null == jbossWebMetaData) {
            return;
        }
        String serviceName = this.getServiceName(deploymentUnit);
        ParamValueMetaData serviceNameContextParameter = new ParamValueMetaData();
        serviceNameContextParameter.setParamName("smallrye.opentracing.serviceName");
        serviceNameContextParameter.setParamValue(serviceName);
        this.addContextParameter(jbossWebMetaData, serviceNameContextParameter);
    }

    private JBossWebMetaData getJBossWebMetaData(DeploymentUnit deploymentUnit) {
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (null == warMetaData) {
            return null;
        }
        return warMetaData.getMergedJBossWebMetaData();
    }

    private void addContextParameter(JBossWebMetaData jbossWebMetaData, ParamValueMetaData restEasyProvider) {
        ArrayList<ParamValueMetaData> contextParams = jbossWebMetaData.getContextParams();
        if (null == contextParams) {
            contextParams = new ArrayList<ParamValueMetaData>();
        }
        contextParams.add(restEasyProvider);
        jbossWebMetaData.setContextParams(contextParams);
    }

    private String getServiceName(DeploymentUnit deploymentUnit) {
        String serviceName = WildFlySecurityManager.getPropertyPrivileged((String)"JAEGER_SERVICE_NAME", (String)"");
        if (null == serviceName || serviceName.isEmpty()) {
            serviceName = WildFlySecurityManager.getEnvPropertyPrivileged((String)"JAEGER_SERVICE_NAME", (String)"");
        }
        if (null == serviceName || serviceName.isEmpty()) {
            serviceName = null != deploymentUnit.getParent() ? deploymentUnit.getParent().getServiceName().getSimpleName() + "!" + deploymentUnit.getServiceName().getSimpleName() : deploymentUnit.getServiceName().getSimpleName();
            TracingExtensionLogger.ROOT_LOGGER.serviceNameDerivedFromDeploymentUnit(serviceName);
        }
        return serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void injectTracer(DeploymentPhaseContext deploymentPhaseContext, CapabilityServiceSupport support) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = deploymentPhaseContext.getDeploymentUnit();
        NoopTracer tracer = null;
        ClassLoader initialCl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
            ModuleClassLoader moduleCL = module.getClassLoader();
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)moduleCL);
            Class globalTracerClass = moduleCL.loadClass("io.opentracing.util.GlobalTracer");
            boolean isRegistered = (Boolean)globalTracerClass.getMethod("isRegistered", new Class[0]).invoke(null, new Object[0]);
            if (isRegistered) {
                TracingLogger.ROOT_LOGGER.alreadyRegistered();
                return;
            }
            Class tracerResolverClass = moduleCL.loadClass("io.opentracing.contrib.tracerresolver.TracerResolver");
            tracer = (Tracer)tracerResolverClass.getMethod("resolveTracer", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            TracingExtensionLogger.ROOT_LOGGER.errorResolvingTracer(ex);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)initialCl);
        }
        String serviceName = this.getServiceName(deploymentUnit);
        if (null == tracer) {
            if (null == serviceName || serviceName.isEmpty()) {
                TracingLogger.ROOT_LOGGER.noServiceName();
                tracer = NoopTracerFactory.create();
            } else {
                tracer = Configuration.fromEnv((String)serviceName).getTracerBuilder().withManualShutdown().build();
            }
        }
        deploymentUnit.addToAttachmentList(ServletContextAttribute.ATTACHMENT_KEY, (Object)new ServletContextAttribute("smallrye.opentracing.serviceName", (Object)serviceName));
        deploymentUnit.addToAttachmentList(ServletContextAttribute.ATTACHMENT_KEY, (Object)new ServletContextAttribute("smallrye.opentracing.tracer", (Object)tracer));
        deploymentUnit.addToAttachmentList(ServletContextAttribute.ATTACHMENT_KEY, (Object)new ServletContextAttribute("smallrye.opentracing.tracer.managed", (Object)true));
        deploymentUnit.putAttachment(ATTACHMENT_KEY, (Object)tracer);
        TracingLogger.ROOT_LOGGER.registeringTracer(tracer.getClass().getName());
        this.addJaxRsIntegration(deploymentUnit);
        TracingLogger.ROOT_LOGGER.initializing(tracer.toString());
    }

    private void addJaxRsIntegration(DeploymentUnit deploymentUnit) {
        JBossWebMetaData jbossWebMetaData = this.getJBossWebMetaData(deploymentUnit);
        if (jbossWebMetaData == null) {
            return;
        }
        ParamValueMetaData restEasyDynamicFeature = new ParamValueMetaData();
        restEasyDynamicFeature.setParamName("resteasy.providers");
        restEasyDynamicFeature.setParamValue("org.wildfly.microprofile.opentracing.smallrye.TracerDynamicFeature");
        this.addContextParameter(jbossWebMetaData, restEasyDynamicFeature);
        if (jbossWebMetaData.getFilters() == null) {
            jbossWebMetaData.setFilters(new FiltersMetaData());
        }
        FilterMetaData filter = new FilterMetaData();
        filter.setFilterClass("io.opentracing.contrib.jaxrs2.server.SpanFinishingFilter");
        filter.setAsyncSupported(true);
        filter.setFilterName("io.opentracing.contrib.jaxrs2.server.SpanFinishingFilter");
        jbossWebMetaData.getFilters().add((MappableMetaData)filter);
        FilterMappingMetaData mapping = new FilterMappingMetaData();
        mapping.setFilterName("io.opentracing.contrib.jaxrs2.server.SpanFinishingFilter");
        mapping.setDispatchers(Collections.singletonList(DispatcherType.REQUEST));
        mapping.setUrlPatterns(Collections.singletonList("*"));
        if (jbossWebMetaData.getFilterMappings() == null) {
            jbossWebMetaData.setFilterMappings(new ArrayList());
        }
        jbossWebMetaData.getFilterMappings().add(mapping);
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        Tracer tracer = (Tracer)deploymentUnit.getAttachment(ATTACHMENT_KEY);
        if (tracer instanceof AutoCloseable) {
            try {
                ((AutoCloseable)tracer).close();
            }
            catch (Exception ex) {
                TracingLogger.ROOT_LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        deploymentUnit.removeAttachment(ATTACHMENT_KEY);
    }
}

