/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.coarse;

import java.io.NotSerializableException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.marshalling.spi.Marshallability;
import org.wildfly.clustering.web.cache.session.SessionActivationNotifier;
import org.wildfly.clustering.web.cache.session.SessionAttributes;
import org.wildfly.clustering.web.cache.session.coarse.CoarseImmutableSessionAttributes;

public class CoarseSessionAttributes
extends CoarseImmutableSessionAttributes
implements SessionAttributes {
    private final Map<String, Object> attributes;
    private final Set<String> mutations = ConcurrentHashMap.newKeySet();
    private final Mutator mutator;
    private final Marshallability marshallability;
    private final Immutability immutability;
    private final CacheProperties properties;
    private final SessionActivationNotifier notifier;

    public CoarseSessionAttributes(Map<String, Object> attributes, Mutator mutator, Marshallability marshallability, Immutability immutability, CacheProperties properties, SessionActivationNotifier notifier) {
        super(attributes);
        this.attributes = attributes;
        this.mutator = mutator;
        this.marshallability = marshallability;
        this.immutability = immutability;
        this.properties = properties;
        this.notifier = notifier;
        if (this.properties.isPersistent()) {
            this.notifier.postActivate();
        }
    }

    public Object removeAttribute(String name) {
        Object value = this.attributes.remove(name);
        if (value != null) {
            this.mutations.add(name);
        }
        return value;
    }

    public Object setAttribute(String name, Object value) {
        if (value == null) {
            return this.removeAttribute(name);
        }
        if (this.properties.isMarshalling() && !this.marshallability.isMarshallable(value)) {
            throw new IllegalArgumentException(new NotSerializableException(value.getClass().getName()));
        }
        Object old = this.attributes.put(name, value);
        this.mutations.add(name);
        return old;
    }

    @Override
    public Object getAttribute(String name) {
        Object value = this.attributes.get(name);
        if (!this.immutability.test(value)) {
            this.mutations.add(name);
        }
        return value;
    }

    @Override
    public void close() {
        if (this.properties.isPersistent()) {
            this.notifier.prePassivate();
        }
        if (!this.mutations.isEmpty()) {
            this.mutator.mutate();
        }
        this.mutations.clear();
    }
}

