/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActiveMQLockAcquisitionTimeoutException;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.utils.UUID;
import org.jboss.logging.Logger;

public class FileLockNodeManager
extends NodeManager {
    private static final Logger logger = Logger.getLogger(FileLockNodeManager.class);
    private static final long STATE_LOCK_POS = 0L;
    private static final long LIVE_LOCK_POS = 1L;
    private static final long BACKUP_LOCK_POS = 2L;
    private static final long LOCK_LENGTH = 1L;
    private static final byte LIVE = 76;
    private static final byte FAILINGBACK = 70;
    private static final byte PAUSED = 80;
    private static final byte NOT_STARTED = 78;
    private static final long LOCK_ACCESS_FAILURE_WAIT_TIME = 2000L;
    private FileLock liveLock;
    private FileLock backupLock;
    protected long lockAcquisitionTimeout = -1L;
    protected boolean interrupted = false;

    public FileLockNodeManager(File directory, boolean replicatedBackup) {
        super(replicatedBackup, directory);
    }

    public FileLockNodeManager(File directory, boolean replicatedBackup, long lockAcquisitionTimeout) {
        super(replicatedBackup, directory);
        this.lockAcquisitionTimeout = lockAcquisitionTimeout;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isStarted()) {
            return;
        }
        if (!this.replicatedBackup) {
            this.setUpServerLockFile();
        }
        super.start();
    }

    @Override
    public boolean isAwaitingFailback() throws Exception {
        return this.getState() == 70;
    }

    @Override
    public boolean isBackupLive() throws Exception {
        FileLock liveAttemptLock = this.tryLock(1L);
        if (liveAttemptLock == null) {
            return true;
        }
        liveAttemptLock.release();
        return false;
    }

    public boolean isLiveLocked() {
        return this.liveLock != null;
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    @Override
    public final void releaseBackup() throws Exception {
        if (this.backupLock != null) {
            this.backupLock.release();
            this.backupLock = null;
        }
    }

    @Override
    public void awaitLiveNode() throws Exception {
        byte state;
        logger.debug((Object)"awaiting live node...");
        while (true) {
            state = this.getState();
            while (state == 78 || state == 48) {
                logger.debug((Object)("awaiting live node startup state='" + state + "'"));
                Thread.sleep(2000L);
                state = this.getState();
            }
            this.liveLock = this.lock(1L);
            if (this.interrupted) {
                this.interrupted = false;
                throw new InterruptedException("Lock was interrupted");
            }
            state = this.getState();
            if (state == 80) {
                this.liveLock.release();
                logger.debug((Object)"awaiting live node restarting");
                Thread.sleep(2000L);
                continue;
            }
            if (state == 70) {
                this.liveLock.release();
                logger.debug((Object)"awaiting live node failing back");
                Thread.sleep(2000L);
                continue;
            }
            if (state == 76) break;
        }
        logger.debug((Object)("acquired live node lock state = " + (char)state));
    }

    @Override
    public void startBackup() throws Exception {
        assert (!this.replicatedBackup);
        ActiveMQServerLogger.LOGGER.waitingToBecomeBackup();
        this.backupLock = this.lock(2L);
        ActiveMQServerLogger.LOGGER.gotBackupLock();
        if (this.getUUID() == null) {
            this.readNodeId();
        }
    }

    @Override
    public ActivateCallback startLiveNode() throws Exception {
        this.setFailingBack();
        String timeoutMessage = this.lockAcquisitionTimeout == -1L ? "indefinitely" : this.lockAcquisitionTimeout + " milliseconds";
        ActiveMQServerLogger.LOGGER.waitingToObtainLiveLock(timeoutMessage);
        this.liveLock = this.lock(1L);
        ActiveMQServerLogger.LOGGER.obtainedLiveLock();
        return new ActivateCallback(){

            @Override
            public void activationComplete() {
                try {
                    FileLockNodeManager.this.setLive();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.warn(e.getMessage(), e);
                }
            }
        };
    }

    @Override
    public void pauseLiveServer() throws Exception {
        this.setPaused();
        if (this.liveLock != null) {
            this.liveLock.release();
        }
    }

    @Override
    public void crashLiveServer() throws Exception {
        if (this.liveLock != null) {
            this.liveLock.release();
            this.liveLock = null;
        }
    }

    @Override
    public void awaitLiveStatus() throws Exception {
        while (this.getState() != 76) {
            Thread.sleep(2000L);
        }
    }

    private void setLive() throws Exception {
        this.writeFileLockStatus((byte)76);
    }

    private void setFailingBack() throws Exception {
        this.writeFileLockStatus((byte)70);
    }

    private void setPaused() throws Exception {
        this.writeFileLockStatus((byte)80);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileLockStatus(byte status) throws Exception {
        if (this.replicatedBackup && this.channel == null) {
            return;
        }
        logger.debug((Object)("writing status: " + status));
        ByteBuffer bb = ByteBuffer.allocateDirect(1);
        bb.put(status);
        bb.position(0);
        if (!this.channel.isOpen()) {
            this.setUpServerLockFile();
        }
        FileLock lock = null;
        try {
            lock = this.lock(0L);
            this.channel.write(bb, 0L);
            this.channel.force(true);
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte getState() throws Exception {
        byte result;
        logger.debug((Object)"getting state...");
        ByteBuffer bb = ByteBuffer.allocateDirect(1);
        FileLock lock = null;
        try {
            lock = this.lock(0L);
            int read = this.channel.read(bb, 0L);
            result = read <= 0 ? (byte)78 : (byte)bb.get(0);
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
        logger.debug((Object)("state: " + result));
        return result;
    }

    @Override
    public final SimpleString readNodeId() throws ActiveMQIllegalStateException, IOException {
        ByteBuffer id = ByteBuffer.allocateDirect(16);
        int read = this.channel.read(id, 3L);
        if (read != 16) {
            throw new ActiveMQIllegalStateException("live server did not write id to file");
        }
        byte[] bytes = new byte[16];
        id.position(0);
        id.get(bytes);
        this.setUUID(new UUID(1, bytes));
        return this.getNodeId();
    }

    protected FileLock tryLock(long lockPos) throws IOException {
        try {
            logger.debug((Object)("trying to lock position: " + lockPos));
            FileLock lock = this.channel.tryLock(lockPos, 1L, false);
            if (lock != null) {
                logger.debug((Object)("locked position: " + lockPos));
            } else {
                logger.debug((Object)("failed to lock position: " + lockPos));
            }
            return lock;
        }
        catch (OverlappingFileLockException ex) {
            return null;
        }
    }

    protected FileLock lock(long lockPosition) throws Exception {
        long start = System.currentTimeMillis();
        boolean isRecurringFailure = false;
        while (!this.interrupted) {
            try {
                FileLock lock = this.tryLock(lockPosition);
                isRecurringFailure = false;
                if (lock == null) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        return null;
                    }
                    if (this.lockAcquisitionTimeout == -1L || System.currentTimeMillis() - start <= this.lockAcquisitionTimeout) continue;
                    throw new ActiveMQLockAcquisitionTimeoutException("timed out waiting for lock");
                }
                return lock;
            }
            catch (IOException e) {
                logger.log(isRecurringFailure ? Logger.Level.DEBUG : Logger.Level.WARN, (Object)"Failure when accessing a lock file", (Throwable)e);
                isRecurringFailure = true;
                long waitTime = 2000L;
                if (this.lockAcquisitionTimeout != -1L) {
                    long remainingTime = this.lockAcquisitionTimeout - (System.currentTimeMillis() - start);
                    if (remainingTime <= 0L) {
                        throw new ActiveMQLockAcquisitionTimeoutException("timed out waiting for lock");
                    }
                    waitTime = Math.min(waitTime, remainingTime);
                }
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException interrupt) {
                    return null;
                }
            }
        }
        return null;
    }
}

