/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.expiration.impl.InternalExpirationManager;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class ExpirationManagerImpl<K, V>
implements InternalExpirationManager<K, V> {
    private static final Log log = LogFactory.getLog(ExpirationManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    @ComponentName(value="org.infinispan.executors.expiration")
    protected ScheduledExecutorService executor;
    @Inject
    protected Configuration configuration;
    @Inject
    protected PersistenceManager persistenceManager;
    @Inject
    protected ComponentRef<InternalDataContainer<K, V>> dataContainer;
    @Inject
    protected CacheNotifier<K, V> cacheNotifier;
    @Inject
    protected TimeService timeService;
    @Inject
    protected KeyPartitioner keyPartitioner;
    protected boolean enabled;
    protected String cacheName;
    protected ConcurrentMap<K, Object> expiring = new ConcurrentHashMap<K, Object>();
    protected ScheduledFuture<?> expirationTask;

    void initialize(ScheduledExecutorService executor, String cacheName, Configuration cfg) {
        this.executor = executor;
        this.configuration = cfg;
        this.cacheName = cacheName;
    }

    @Start(priority=55)
    public void start() {
        this.enabled = this.configuration.expiration().reaperEnabled();
        if (this.enabled) {
            long expWakeUpInt = this.configuration.expiration().wakeUpInterval();
            if (expWakeUpInt <= 0L) {
                log.notStartingEvictionThread();
                this.enabled = false;
            } else {
                this.expirationTask = this.executor.scheduleWithFixedDelay(new ScheduledTask(), expWakeUpInt, expWakeUpInt, TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public void processExpiration() {
        long start = 0L;
        if (!Thread.currentThread().isInterrupted()) {
            try {
                if (trace) {
                    log.trace("Purging data container of expired entries");
                    start = this.timeService.time();
                }
                long currentTimeMillis = this.timeService.wallClockTime();
                Iterator purgeCandidates = this.dataContainer.running().iteratorIncludingExpired();
                while (purgeCandidates.hasNext()) {
                    InternalCacheEntry e = purgeCandidates.next();
                    if (!e.isExpired(currentTimeMillis)) continue;
                    this.entryExpiredInMemory(e, currentTimeMillis, false);
                }
                if (trace) {
                    log.tracef("Purging data container completed in %s", Util.prettyPrintTime((long)this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)));
                }
            }
            catch (Exception e) {
                log.exceptionPurgingDataContainer(e);
            }
        }
        if (!Thread.currentThread().isInterrupted()) {
            this.persistenceManager.purgeExpired();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public CompletableFuture<Boolean> entryExpiredInMemory(InternalCacheEntry<K, V> entry, long currentTime, boolean hasLock) {
        this.dataContainer.running().compute(entry.getKey(), (k, oldEntry, factory) -> {
            if (oldEntry != null) {
                InternalCacheEntry internalCacheEntry = oldEntry;
                synchronized (internalCacheEntry) {
                    if (!oldEntry.isExpired(currentTime)) {
                        return oldEntry;
                    }
                    this.deleteFromStoresAndNotify(k, oldEntry.getValue(), oldEntry.getMetadata());
                }
            }
            return null;
        });
        return CompletableFutures.completedTrue();
    }

    @Override
    public CompletableFuture<Boolean> entryExpiredInMemoryFromIteration(InternalCacheEntry<K, V> entry, long currentTime) {
        return this.entryExpiredInMemory(entry, currentTime, false);
    }

    @Override
    public void handleInMemoryExpiration(InternalCacheEntry<K, V> entry, long currentTime) {
        this.entryExpiredInMemory(entry, currentTime, false).join();
    }

    @Override
    public void handleInStoreExpiration(K key) {
        this.handleInStoreExpiration(key, null, null);
    }

    @Override
    public void handleInStoreExpiration(MarshalledEntry<K, V> marshalledEntry) {
        this.handleInStoreExpiration(marshalledEntry.getKey(), marshalledEntry.getValue(), marshalledEntry.getMetadata());
    }

    private void handleInStoreExpiration(K key, V value, Metadata metadata) {
        this.dataContainer.running().compute(key, (oldKey, oldEntry, factory) -> {
            long time;
            boolean shouldRemove = false;
            if (oldEntry == null) {
                shouldRemove = true;
                this.deleteFromStoresAndNotify(key, value, metadata);
            } else if (oldEntry.canExpire() && oldEntry.isExpired(time = this.timeService.time())) {
                InternalCacheEntry internalCacheEntry = oldEntry;
                synchronized (internalCacheEntry) {
                    if (oldEntry.isExpired(time) && (shouldRemove = !(metadata != null && !oldEntry.getMetadata().equals(metadata) || value != null && !value.equals(oldEntry.getValue())))) {
                        this.deleteFromStoresAndNotify(key, value, metadata);
                    }
                }
            }
            if (shouldRemove) {
                return null;
            }
            return oldEntry;
        });
    }

    private void deleteFromStoresAndNotify(K key, V value, Metadata metadata) {
        this.deleteFromStores(key);
        if (this.cacheNotifier != null) {
            this.cacheNotifier.notifyCacheEntryExpired(key, value, metadata, null);
        }
    }

    private void deleteFromStores(K key) {
        this.persistenceManager.deleteFromAllStores(key, this.keyPartitioner.getSegment(key), PersistenceManager.AccessMode.BOTH);
    }

    protected Long localLastAccess(Object key, Object value, int segment) {
        InternalCacheEntry<K, V> ice = this.dataContainer.running().peek(segment, key);
        if (ice != null && (value == null || value.equals(ice.getValue())) && !ice.isExpired(this.timeService.wallClockTime())) {
            return ice.getLastUsed();
        }
        return null;
    }

    @Override
    public CompletableFuture<Long> retrieveLastAccess(Object key, Object value, int segment) {
        Long lastAccess = this.localLastAccess(key, value, segment);
        if (lastAccess != null) {
            return CompletableFuture.completedFuture(lastAccess);
        }
        return CompletableFutures.completedNull();
    }

    @Stop(priority=5)
    public void stop() {
        if (this.expirationTask != null) {
            this.expirationTask.cancel(true);
        }
    }

    class ScheduledTask
    implements Runnable {
        ScheduledTask() {
        }

        @Override
        public void run() {
            LogFactory.pushNDC(ExpirationManagerImpl.this.cacheName, trace);
            try {
                ExpirationManagerImpl.this.processExpiration();
            }
            finally {
                LogFactory.popNDC(trace);
            }
        }
    }
}

