/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.Cache;
import org.infinispan.IllegalLifecycleStateException;
import org.infinispan.Version;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.ClassWhiteList;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.Immutables;
import org.infinispan.configuration.ConfigurationManager;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.format.PropertyFormatter;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.InternalCacheFactory;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.globalstate.GlobalConfigurationManager;
import org.infinispan.health.Health;
import org.infinispan.health.impl.HealthImpl;
import org.infinispan.health.impl.jmx.HealthJMXExposerImpl;
import org.infinispan.health.jmx.HealthJMXExposer;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.DefaultCacheManagerAdmin;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.manager.EmbeddedCacheManagerStartupException;
import org.infinispan.manager.impl.ClusterExecutors;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.security.AuditContext;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.impl.AuthorizationHelper;
import org.infinispan.security.impl.PrincipalRoleMapperContextImpl;
import org.infinispan.security.impl.SecureCacheImpl;
import org.infinispan.stats.CacheContainerStats;
import org.infinispan.stats.impl.CacheContainerStatsImpl;
import org.infinispan.util.CyclicDependencyException;
import org.infinispan.util.DependencyGraph;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
@SurvivesRestarts
@MBean(objectName="CacheManager", description="Component that acts as a manager, factory and container for caches in the system.")
public class DefaultCacheManager
implements EmbeddedCacheManager {
    public static final String OBJECT_NAME = "CacheManager";
    private static final Log log = LogFactory.getLog(DefaultCacheManager.class);
    private final ConcurrentMap<String, CompletableFuture<Cache<?, ?>>> caches = CollectionFactory.makeConcurrentMap();
    private final GlobalComponentRegistry globalComponentRegistry;
    private final AuthorizationHelper authzHelper;
    private final DependencyGraph<String> cacheDependencyGraph = new DependencyGraph();
    private final CacheContainerStats stats;
    private final Health health;
    private final ConfigurationManager configurationManager;
    private final String defaultCacheName;
    private final Lock lifecycleLock = new ReentrantLock();
    private final Condition lifecycleCondition = this.lifecycleLock.newCondition();
    private volatile ComponentStatus status = ComponentStatus.INSTANTIATED;
    private final DefaultCacheManagerAdmin cacheManagerAdmin;
    private final ClassWhiteList classWhiteList = new ClassWhiteList();
    private volatile Transport transport;

    public DefaultCacheManager() {
        this(null, null, true);
    }

    public DefaultCacheManager(boolean start) {
        this(null, null, start);
    }

    public DefaultCacheManager(Configuration defaultConfiguration) {
        this(null, defaultConfiguration, true);
    }

    public DefaultCacheManager(Configuration defaultConfiguration, boolean start) {
        this(null, defaultConfiguration, start);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration) {
        this(globalConfiguration, null, true);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration, boolean start) {
        this(globalConfiguration, null, start);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration, Configuration defaultConfiguration) {
        this(globalConfiguration, defaultConfiguration, true);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration, Configuration defaultConfiguration, boolean start) {
        globalConfiguration = globalConfiguration == null ? new GlobalConfigurationBuilder().build() : globalConfiguration;
        this.configurationManager = new ConfigurationManager(globalConfiguration);
        if (defaultConfiguration != null) {
            if (globalConfiguration.defaultCacheName().isPresent()) {
                this.defaultCacheName = globalConfiguration.defaultCacheName().get();
            } else {
                log.defaultCacheConfigurationWithoutName();
                this.defaultCacheName = "___defaultcache";
            }
            this.configurationManager.putConfiguration(this.defaultCacheName, defaultConfiguration);
        } else {
            if (globalConfiguration.defaultCacheName().isPresent()) {
                throw log.missingDefaultCacheDeclaration(globalConfiguration.defaultCacheName().get());
            }
            this.defaultCacheName = null;
        }
        this.globalComponentRegistry = new GlobalComponentRegistry(globalConfiguration, this, this.caches.keySet(), this.configurationManager);
        this.globalComponentRegistry.registerComponent(this.cacheDependencyGraph, "org.infinispan.CacheDependencyGraph", false);
        this.authzHelper = new AuthorizationHelper(globalConfiguration.security(), AuditContext.CACHEMANAGER, globalConfiguration.globalJmxStatistics().cacheManagerName());
        this.globalComponentRegistry.registerComponent((Object)this.authzHelper, AuthorizationHelper.class);
        this.stats = new CacheContainerStatsImpl(this);
        this.globalComponentRegistry.registerComponent((Object)this.stats, CacheContainerStats.class);
        this.health = new HealthImpl(this, this.globalComponentRegistry.getComponent(InternalCacheRegistry.class));
        this.globalComponentRegistry.registerComponent((Object)new HealthJMXExposerImpl(this.health), HealthJMXExposer.class);
        this.cacheManagerAdmin = new DefaultCacheManagerAdmin(this, this.authzHelper, EnumSet.noneOf(CacheContainerAdmin.AdminFlag.class), this.globalComponentRegistry.getComponent(GlobalConfigurationManager.class));
        if (start) {
            this.start();
        }
    }

    public DefaultCacheManager(String configurationFile) throws IOException {
        this(configurationFile, true);
    }

    public DefaultCacheManager(String configurationFile, boolean start) throws IOException {
        this(FileLookupFactory.newInstance().lookupFileStrict(configurationFile, Thread.currentThread().getContextClassLoader()), start);
    }

    public DefaultCacheManager(InputStream configurationStream) throws IOException {
        this(configurationStream, true);
    }

    public DefaultCacheManager(InputStream configurationStream, boolean start) throws IOException {
        this(new ParserRegistry().parse(configurationStream), start);
    }

    public DefaultCacheManager(ConfigurationBuilderHolder holder, boolean start) {
        try {
            this.configurationManager = new ConfigurationManager(holder);
            GlobalConfiguration globalConfiguration = this.configurationManager.getGlobalConfiguration();
            this.defaultCacheName = globalConfiguration.defaultCacheName().orElse(null);
            this.globalComponentRegistry = new GlobalComponentRegistry(globalConfiguration, this, this.caches.keySet(), this.configurationManager);
            this.globalComponentRegistry.registerComponent(this.cacheDependencyGraph, "org.infinispan.CacheDependencyGraph", false);
            this.stats = new CacheContainerStatsImpl(this);
            this.globalComponentRegistry.registerComponent((Object)this, CacheContainerStats.class);
            this.health = new HealthImpl(this, this.globalComponentRegistry.getComponent(InternalCacheRegistry.class));
            this.globalComponentRegistry.registerComponent((Object)new HealthJMXExposerImpl(this.health), HealthJMXExposer.class);
            this.authzHelper = new AuthorizationHelper(globalConfiguration.security(), AuditContext.CACHEMANAGER, globalConfiguration.globalJmxStatistics().cacheManagerName());
            this.globalComponentRegistry.registerComponent((Object)this.authzHelper, AuthorizationHelper.class);
            this.cacheManagerAdmin = new DefaultCacheManagerAdmin(this, this.authzHelper, EnumSet.noneOf(CacheContainerAdmin.AdminFlag.class), this.globalComponentRegistry.getComponent(GlobalConfigurationManager.class));
        }
        catch (CacheConfigurationException ce) {
            throw ce;
        }
        catch (RuntimeException re) {
            throw new CacheConfigurationException((Exception)re);
        }
        if (start) {
            this.start();
        }
    }

    @Override
    public Configuration defineConfiguration(String name, Configuration configuration) {
        return this.doDefineConfiguration(name, configuration);
    }

    @Override
    public Configuration defineConfiguration(String name, String template, Configuration configurationOverride) {
        if (template != null) {
            Configuration c = this.configurationManager.getConfiguration(template, true);
            if (c == null) {
                throw log.undeclaredConfiguration(template, name);
            }
            if (configurationOverride == null) {
                return this.doDefineConfiguration(name, c);
            }
            return this.doDefineConfiguration(name, c, configurationOverride);
        }
        return this.doDefineConfiguration(name, configurationOverride);
    }

    private Configuration doDefineConfiguration(String name, Configuration ... configurations) {
        this.authzHelper.checkPermission(AuthorizationPermission.ADMIN);
        this.assertIsNotTerminated();
        if (name == null || configurations == null) {
            throw new NullPointerException("Null arguments not allowed");
        }
        if (name.equals("___defaultcache")) {
            throw log.illegalCacheName("___defaultcache");
        }
        Configuration existing = this.configurationManager.getConfiguration(name, false);
        if (existing != null) {
            throw log.configAlreadyDefined(name);
        }
        ConfigurationBuilder builder = new ConfigurationBuilder();
        boolean template = true;
        for (Configuration configuration : configurations) {
            if (configuration == null) {
                throw new NullPointerException("Null arguments not allowed");
            }
            builder.read(configuration);
            template = template && configuration.isTemplate();
        }
        builder.template(template);
        return this.configurationManager.putConfiguration(name, builder);
    }

    @Override
    public void undefineConfiguration(String configurationName) {
        this.authzHelper.checkPermission(AuthorizationPermission.ADMIN);
        if (configurationName.equals("___defaultcache")) {
            throw log.illegalCacheName("___defaultcache");
        }
        Configuration existing = this.configurationManager.getConfiguration(configurationName, false);
        if (existing != null) {
            for (CompletableFuture cacheFuture : this.caches.values()) {
                Cache cache = (Cache)((CompletableFuture)cacheFuture.exceptionally(t -> null)).join();
                if (cache == null || cache.getCacheConfiguration() != existing || cache.getStatus() == ComponentStatus.TERMINATED) continue;
                throw log.configurationInUse(configurationName);
            }
            this.configurationManager.removeConfiguration(configurationName);
            this.globalComponentRegistry.removeCache(configurationName);
        }
    }

    @Override
    public <K, V> Cache<K, V> createCache(String name, Configuration configuration) {
        this.defineConfiguration(name, configuration);
        return this.getCache(name);
    }

    @Override
    public <K, V> Cache<K, V> getCache() {
        if (this.defaultCacheName == null) {
            throw log.noDefaultCache();
        }
        return this.internalGetCache(this.defaultCacheName, this.defaultCacheName);
    }

    @Override
    public <K, V> Cache<K, V> getCache(String cacheName) {
        return this.getCache(cacheName, cacheName);
    }

    @Override
    public <K, V> Cache<K, V> getCache(String cacheName, String configurationName) {
        if (cacheName == null) {
            throw new NullPointerException("Null arguments not allowed");
        }
        if ("___defaultcache".equals(cacheName)) {
            if (this.defaultCacheName == null) {
                throw log.noDefaultCache();
            }
            cacheName = this.defaultCacheName;
            log.deprecatedDefaultCache();
        }
        return this.internalGetCache(cacheName, configurationName);
    }

    public <K, V> Cache<K, V> internalGetCache(String cacheName, String configurationName) {
        this.assertIsNotTerminated();
        this.internalStart(false);
        CompletableFuture cacheFuture = (CompletableFuture)this.caches.get(cacheName);
        if (cacheFuture != null) {
            try {
                return (Cache)cacheFuture.join();
            }
            catch (CompletionException e) {
                throw (CacheException)e.getCause();
            }
        }
        return this.createCache(cacheName, configurationName);
    }

    @Override
    public boolean cacheExists(String cacheName) {
        return this.caches.containsKey(cacheName);
    }

    @Override
    public <K, V> Cache<K, V> getCache(String cacheName, boolean createIfAbsent) {
        return this.getCache(cacheName, cacheName, createIfAbsent);
    }

    @Override
    public <K, V> Cache<K, V> getCache(String cacheName, String configurationTemplate, boolean createIfAbsent) {
        boolean cacheExists = this.cacheExists(cacheName);
        if (!cacheExists && !createIfAbsent) {
            return null;
        }
        return this.getCache(cacheName, configurationTemplate);
    }

    @Override
    public EmbeddedCacheManager startCaches(String ... cacheNames) {
        this.authzHelper.checkPermission(AuthorizationPermission.LIFECYCLE);
        this.internalStart(false);
        HashMap<String, 1> threads = new HashMap<String, 1>(cacheNames.length);
        final AtomicReference<Object> exception = new AtomicReference<Object>(null);
        for (final String cacheName : cacheNames) {
            if (threads.containsKey(cacheName)) continue;
            String threadName = "CacheStartThread," + this.configurationManager.getGlobalConfiguration().transport().nodeName() + "," + cacheName;
            Thread thread = new Thread(threadName){

                @Override
                public void run() {
                    try {
                        DefaultCacheManager.this.createCache(cacheName, cacheName);
                    }
                    catch (RuntimeException e) {
                        exception.set(e);
                    }
                    catch (Throwable t) {
                        exception.set(new RuntimeException(t));
                    }
                }
            };
            thread.start();
            threads.put(cacheName, thread);
        }
        try {
            for (Thread thread : threads.values()) {
                thread.join();
            }
        }
        catch (InterruptedException e) {
            throw new CacheException("Interrupted while waiting for the caches to start");
        }
        RuntimeException runtimeException = exception.get();
        if (runtimeException != null) {
            throw runtimeException;
        }
        return this;
    }

    @Override
    public void removeCache(String cacheName) {
        this.cacheManagerAdmin.removeCache(cacheName);
    }

    @Override
    public List<Address> getMembers() {
        Transport t = this.getTransport();
        return t == null ? null : t.getMembers();
    }

    @Override
    public Address getAddress() {
        Transport t = this.getTransport();
        return t == null ? null : t.getAddress();
    }

    @Override
    public Address getCoordinator() {
        Transport t = this.getTransport();
        return t == null ? null : t.getCoordinator();
    }

    @ManagedAttribute(description="The logical address of the cluster's coordinator", displayName="Coordinator address", displayType=DisplayType.SUMMARY)
    public String getCoordinatorAddress() {
        Transport t = this.getTransport();
        return t == null ? "N/A" : t.getCoordinator().toString();
    }

    @Override
    @ManagedAttribute(description="Indicates whether this node is coordinator", displayName="Is coordinator?", displayType=DisplayType.SUMMARY)
    public boolean isCoordinator() {
        Transport t = this.getTransport();
        return t != null && t.isCoordinator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> Cache<K, V> createCache(String cacheName, String configurationName) {
        boolean trace = log.isTraceEnabled();
        LogFactory.pushNDC(cacheName, trace);
        try {
            Cache<K, V> cache = this.wireAndStartCache(cacheName, configurationName);
            return cache;
        }
        finally {
            LogFactory.popNDC(trace);
        }
    }

    private <K, V> Cache<K, V> wireAndStartCache(String cacheName, String configurationName) {
        Configuration definedConfig;
        boolean sameCache = cacheName.equals(configurationName);
        Configuration c = this.configurationManager.getConfiguration(configurationName, this.defaultCacheName);
        if (c == null) {
            throw log.noSuchCacheConfiguration(configurationName);
        }
        if (!sameCache && (definedConfig = this.configurationManager.getConfiguration(cacheName, true)) != null) {
            log.warnAttemptToOverrideExistingConfiguration(cacheName);
            c = definedConfig;
        }
        if (c.security().authorization().enabled()) {
            this.authzHelper.checkPermission(c.security().authorization(), AuthorizationPermission.LIFECYCLE);
        }
        if (c.isTemplate() && cacheName.equals(configurationName)) {
            throw log.templateConfigurationStartAttempt(cacheName);
        }
        CompletableFuture cacheFuture = new CompletableFuture();
        CompletableFuture oldFuture = this.caches.computeIfAbsent(cacheName, name -> {
            this.assertIsNotTerminated();
            return cacheFuture;
        });
        try {
            if (oldFuture != cacheFuture) {
                return (Cache)oldFuture.join();
            }
        }
        catch (CompletionException ce) {
            throw (CacheException)ce.getCause();
        }
        Cache cache = null;
        try {
            boolean needToNotifyCacheStarted;
            log.tracef("About to wire and start cache %s", cacheName);
            cache = new InternalCacheFactory().createCache(c, this.globalComponentRegistry, cacheName);
            ComponentRegistry cr = cache.getAdvancedCache().getComponentRegistry();
            if (cache.getAdvancedCache().getAuthorizationManager() != null) {
                cache = new SecureCacheImpl(cache.getAdvancedCache());
            }
            boolean notStartedYet = cr.getStatus() != ComponentStatus.RUNNING && cr.getStatus() != ComponentStatus.INITIALIZING;
            cache.start();
            cacheFuture.complete(cache);
            boolean bl = needToNotifyCacheStarted = notStartedYet && cr.getStatus() == ComponentStatus.RUNNING;
            if (needToNotifyCacheStarted) {
                this.globalComponentRegistry.notifyCacheStarted(cacheName);
            }
            log.tracef("Cache %s started", cacheName);
            return cache;
        }
        catch (CacheException e) {
            cacheFuture.completeExceptionally(e);
            throw e;
        }
        catch (Throwable t) {
            cacheFuture.completeExceptionally(new CacheException(t));
            throw t;
        }
    }

    public void start() {
        this.authzHelper.checkPermission(AuthorizationPermission.LIFECYCLE);
        this.internalStart(true);
    }

    private void internalStart(boolean block) {
        this.lifecycleLock.lock();
        try {
            while (block && this.status == ComponentStatus.INITIALIZING) {
                this.lifecycleCondition.await();
            }
            if (this.status != ComponentStatus.INSTANTIATED) {
                return;
            }
            log.debugf("Starting cache manager %s", this.configurationManager.getGlobalConfiguration().transport().nodeName());
            this.updateStatus(ComponentStatus.INITIALIZING);
        }
        catch (InterruptedException e) {
            throw new CacheException("Interrupted waiting for the cache manager to start");
        }
        finally {
            this.lifecycleLock.unlock();
        }
        try {
            GlobalConfiguration globalConfiguration = this.configurationManager.getGlobalConfiguration();
            if (globalConfiguration.security().authorization().enabled() && System.getSecurityManager() == null) {
                log.authorizationEnabledWithoutSecurityManager();
            }
            this.globalComponentRegistry.getComponent(CacheManagerJmxRegistration.class).start();
            String nodeName = globalConfiguration.transport().nodeName();
            if (globalConfiguration.security().authorization().enabled()) {
                globalConfiguration.security().authorization().principalRoleMapper().setContext(new PrincipalRoleMapperContextImpl(this));
            }
            this.globalComponentRegistry.start();
            log.debugf("Started cache manager %s on %s", nodeName, this.getAddress());
        }
        catch (Exception e) {
            throw new EmbeddedCacheManagerStartupException(e);
        }
        finally {
            this.updateStatus(this.globalComponentRegistry.getStatus());
        }
    }

    private void updateStatus(ComponentStatus status) {
        this.lifecycleLock.lock();
        try {
            this.status = status;
            this.lifecycleCondition.signalAll();
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    private void terminate(String cacheName) {
        CompletableFuture cacheFuture = (CompletableFuture)this.caches.get(cacheName);
        if (cacheFuture != null) {
            Cache cache = (Cache)cacheFuture.join();
            this.unregisterCacheMBean(cache);
            if (cache.getStatus().isTerminated()) {
                log.tracef("Ignoring cache %s, it is already terminated.", cacheName);
                return;
            }
            cache.stop();
        }
    }

    public void stop() {
        this.authzHelper.checkPermission(AuthorizationPermission.LIFECYCLE);
        this.internalStop();
    }

    private void internalStop() {
        this.lifecycleLock.lock();
        try {
            while (this.status == ComponentStatus.STOPPING) {
                this.lifecycleCondition.await();
            }
            if (this.status != ComponentStatus.RUNNING && this.status != ComponentStatus.FAILED) {
                log.trace("Ignore call to stop as the cache manager is not running");
                return;
            }
            log.debugf("Stopping cache manager %s on %s", this.configurationManager.getGlobalConfiguration().transport().nodeName(), this.getAddress());
            this.updateStatus(ComponentStatus.STOPPING);
        }
        catch (InterruptedException e) {
            throw new CacheException("Interrupted waiting for the cache manager to stop");
        }
        finally {
            this.lifecycleLock.unlock();
        }
        try {
            this.stopCaches();
            this.globalComponentRegistry.getComponent(CacheManagerJmxRegistration.class).stop();
            this.globalComponentRegistry.stop();
            log.debugf("Stopped cache manager %s", this.configurationManager.getGlobalConfiguration().transport().nodeName());
        }
        finally {
            this.updateStatus(ComponentStatus.TERMINATED);
        }
    }

    private void stopCaches() {
        LinkedHashSet<String> cachesToStop = new LinkedHashSet<String>(this.caches.size());
        try {
            List<String> ordered = this.cacheDependencyGraph.topologicalSort();
            cachesToStop.addAll(ordered);
        }
        catch (CyclicDependencyException e) {
            log.stopOrderIgnored();
        }
        cachesToStop.addAll(this.caches.keySet());
        log.tracef("Cache stop order: %s", cachesToStop);
        for (String cacheName : cachesToStop) {
            try {
                this.terminate(cacheName);
            }
            catch (Throwable t) {
                log.componentFailedToStop(t);
            }
        }
    }

    private void unregisterCacheMBean(Cache<?, ?> cache) {
        this.globalComponentRegistry.getComponent(CacheManagerJmxRegistration.class).unregisterCacheMBean(cache.getName(), cache.getCacheConfiguration().clustering().cacheModeString());
    }

    @Override
    public void addListener(Object listener) {
        this.authzHelper.checkPermission(AuthorizationPermission.LISTEN);
        CacheManagerNotifier notifier = this.globalComponentRegistry.getComponent(CacheManagerNotifier.class);
        notifier.addListener(listener);
    }

    @Override
    public void removeListener(Object listener) {
        this.authzHelper.checkPermission(AuthorizationPermission.LISTEN);
        try {
            CacheManagerNotifier notifier = this.globalComponentRegistry.getComponent(CacheManagerNotifier.class);
            notifier.removeListener(listener);
        }
        catch (IllegalLifecycleStateException illegalLifecycleStateException) {
            // empty catch block
        }
    }

    @Override
    public Set<Object> getListeners() {
        this.authzHelper.checkPermission(AuthorizationPermission.LISTEN);
        CacheManagerNotifier notifier = this.globalComponentRegistry.getComponent(CacheManagerNotifier.class);
        return notifier.getListeners();
    }

    @Override
    public ComponentStatus getStatus() {
        return this.status;
    }

    @Override
    public GlobalConfiguration getCacheManagerConfiguration() {
        this.authzHelper.checkPermission(AuthorizationPermission.ADMIN);
        return this.configurationManager.getGlobalConfiguration();
    }

    @Override
    public Configuration getDefaultCacheConfiguration() {
        this.authzHelper.checkPermission(AuthorizationPermission.ADMIN);
        if (this.defaultCacheName != null) {
            return this.configurationManager.getConfiguration(this.defaultCacheName, true);
        }
        return null;
    }

    @Override
    public Configuration getCacheConfiguration(String name) {
        this.authzHelper.checkPermission(AuthorizationPermission.ADMIN);
        Configuration configuration = this.configurationManager.getConfiguration(name, true);
        if (configuration == null && this.cacheExists(name)) {
            return this.getDefaultCacheConfiguration();
        }
        return configuration;
    }

    public Set<String> getCacheNames() {
        HashSet<String> names = new HashSet<String>(this.configurationManager.getDefinedCaches());
        names.addAll(Immutables.immutableSetConvert(this.caches.keySet()));
        names.remove("___defaultcache");
        InternalCacheRegistry internalCacheRegistry = this.globalComponentRegistry.getComponent(InternalCacheRegistry.class);
        internalCacheRegistry.filterPrivateCaches(names);
        if (names.isEmpty()) {
            return Collections.emptySet();
        }
        return Immutables.immutableSetWrap(names);
    }

    @Override
    public Set<String> getCacheConfigurationNames() {
        HashSet<String> names = new HashSet<String>(this.configurationManager.getDefinedConfigurations());
        names.remove("___defaultcache");
        InternalCacheRegistry internalCacheRegistry = this.globalComponentRegistry.getComponent(InternalCacheRegistry.class);
        internalCacheRegistry.filterPrivateCaches(names);
        if (names.isEmpty()) {
            return Collections.emptySet();
        }
        return Immutables.immutableSetWrap(names);
    }

    @Override
    public boolean isRunning(String cacheName) {
        CompletableFuture cacheFuture = (CompletableFuture)this.caches.get(cacheName);
        boolean started = cacheFuture != null && cacheFuture.isDone() && !cacheFuture.isCompletedExceptionally();
        return started && ((Cache)cacheFuture.join()).getStatus() == ComponentStatus.RUNNING;
    }

    @Override
    public boolean isDefaultRunning() {
        return this.isRunning("___defaultcache");
    }

    @ManagedAttribute(description="The status of the cache manager instance.", displayName="Cache manager status", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getCacheManagerStatus() {
        return this.getStatus().toString();
    }

    @ManagedAttribute(description="The defined cache names and their statuses.  The default cache is not included in this representation.", displayName="List of defined caches", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getDefinedCacheNames() {
        StringBuilder result = new StringBuilder("[");
        for (String cacheName : this.getCacheNames()) {
            boolean started = this.caches.containsKey(cacheName);
            result.append(cacheName).append(started ? "(created)" : "(not created)");
        }
        result.append("]");
        return result.toString();
    }

    @ManagedAttribute(description="The defined cache configuration names.", displayName="List of defined cache configurations", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getDefinedCacheConfigurationNames() {
        StringBuilder result = new StringBuilder("[");
        boolean comma = false;
        for (String cacheName : this.getCacheConfigurationNames()) {
            if (comma) {
                result.append(",");
            } else {
                comma = true;
            }
            result.append(cacheName);
        }
        result.append("]");
        return result.toString();
    }

    @ManagedAttribute(description="The total number of defined cache configurations.", displayName="Number of caches defined", displayType=DisplayType.SUMMARY)
    public String getDefinedCacheCount() {
        return String.valueOf(this.getCacheConfigurationNames().size());
    }

    @ManagedAttribute(description="The total number of created caches, including the default cache.", displayName="Number of caches created", displayType=DisplayType.SUMMARY)
    public String getCreatedCacheCount() {
        InternalCacheRegistry internalCacheRegistry = this.globalComponentRegistry.getComponent(InternalCacheRegistry.class);
        long created = this.caches.keySet().stream().filter(c -> !internalCacheRegistry.isInternalCache((String)c)).count();
        return String.valueOf(created);
    }

    @ManagedAttribute(description="The total number of running caches, including the default cache.", displayName="Number of running caches", displayType=DisplayType.SUMMARY)
    public String getRunningCacheCount() {
        InternalCacheRegistry internalCacheRegistry = this.globalComponentRegistry.getComponent(InternalCacheRegistry.class);
        long running = this.caches.keySet().stream().filter(c -> this.isRunning((String)c) && !internalCacheRegistry.isInternalCache((String)c)).count();
        return String.valueOf(running);
    }

    @ManagedAttribute(description="Returns the version of Infinispan", displayName="Infinispan version", displayType=DisplayType.SUMMARY, dataType=DataType.TRAIT)
    public String getVersion() {
        return Version.getVersion();
    }

    @ManagedAttribute(description="The name of this cache manager", displayName="Cache manager name", displayType=DisplayType.SUMMARY, dataType=DataType.TRAIT)
    public String getName() {
        return this.configurationManager.getGlobalConfiguration().globalJmxStatistics().cacheManagerName();
    }

    @ManagedOperation(description="Starts the default cache associated with this cache manager", displayName="Starts the default cache")
    public void startCache() {
        this.getCache();
    }

    @ManagedOperation(description="Starts a named cache from this cache manager", name="startCache", displayName="Starts a cache with the given name")
    public void startCache(@Parameter(name="cacheName", description="Name of cache to start") String cacheName) {
        this.getCache(cacheName);
    }

    @ManagedAttribute(description="The network address associated with this instance", displayName="Network address", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getNodeAddress() {
        return this.getLogicalAddressString();
    }

    @ManagedAttribute(description="The physical network addresses associated with this instance", displayName="Physical network addresses", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getPhysicalAddresses() {
        Transport t = this.getTransport();
        if (t == null) {
            return "local";
        }
        List<Address> address = t.getPhysicalAddresses();
        return address == null ? "local" : address.toString();
    }

    @ManagedAttribute(description="List of members in the cluster", displayName="Cluster members", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getClusterMembers() {
        Transport t = this.getTransport();
        if (t == null) {
            return "local";
        }
        List<Address> addressList = t.getMembers();
        return addressList.toString();
    }

    @ManagedAttribute(description="Size of the cluster in number of nodes", displayName="Cluster size", displayType=DisplayType.SUMMARY)
    public int getClusterSize() {
        Transport t = this.getTransport();
        if (t == null) {
            return 1;
        }
        return t.getMembers().size();
    }

    @Override
    @ManagedAttribute(description="Cluster name", displayName="Cluster name", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getClusterName() {
        return this.configurationManager.getGlobalConfiguration().transport().clusterName();
    }

    private String getLogicalAddressString() {
        return this.getAddress() == null ? "local" : this.getAddress().toString();
    }

    private void assertIsNotTerminated() {
        if (this.status == ComponentStatus.STOPPING || this.status == ComponentStatus.TERMINATED || this.status == ComponentStatus.FAILED) {
            throw new IllegalLifecycleStateException("Cache container has been stopped and cannot be reused. Recreate the cache container.");
        }
    }

    @Override
    public Transport getTransport() {
        if (this.transport == null) {
            this.lifecycleLock.lock();
            try {
                if (this.transport == null && (this.status == ComponentStatus.RUNNING || this.status == ComponentStatus.INITIALIZING)) {
                    this.transport = this.globalComponentRegistry.getComponent(Transport.class);
                }
            }
            finally {
                this.lifecycleLock.unlock();
            }
        }
        return this.transport;
    }

    @Override
    public GlobalComponentRegistry getGlobalComponentRegistry() {
        this.authzHelper.checkPermission(AuthorizationPermission.ADMIN);
        return this.globalComponentRegistry;
    }

    @Override
    public void addCacheDependency(String from, String to) {
        this.authzHelper.checkPermission(AuthorizationPermission.ADMIN);
        this.cacheDependencyGraph.addDependency(from, to);
    }

    public String toString() {
        return super.toString() + "@Address:" + this.getAddress();
    }

    @ManagedAttribute(description="Global configuration properties", displayName="Global configuration properties", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public Properties getGlobalConfigurationAsProperties() {
        return new PropertyFormatter().format(this.configurationManager.getGlobalConfiguration());
    }

    @Override
    public CacheContainerStats getStats() {
        return this.stats;
    }

    @Override
    public Health getHealth() {
        return this.health;
    }

    @Override
    public ClusterExecutor executor() {
        if (this.globalComponentRegistry.getStatus() != ComponentStatus.RUNNING && this.globalComponentRegistry.getStatus() != ComponentStatus.INITIALIZING) {
            throw new IllegalStateException("CacheManager must be started before retrieving a ClusterExecutor!");
        }
        JGroupsTransport transport = (JGroupsTransport)this.globalComponentRegistry.getComponent(Transport.class);
        if (transport != null) {
            long time = this.getCacheManagerConfiguration().transport().distributedSyncTimeout();
            return ClusterExecutors.allSubmissionExecutor(null, this, transport, time, TimeUnit.MILLISECONDS, this.globalComponentRegistry.getComponent(ExecutorService.class, "org.infinispan.executors.remote"), this.globalComponentRegistry.getComponent(ScheduledExecutorService.class, "org.infinispan.executors.timeout"));
        }
        return ClusterExecutors.allSubmissionExecutor(null, this, null, (Long)TransportConfiguration.DISTRIBUTED_SYNC_TIMEOUT.getDefaultValue(), TimeUnit.MILLISECONDS, ForkJoinPool.commonPool(), this.globalComponentRegistry.getComponent(ScheduledExecutorService.class, "org.infinispan.executors.timeout"));
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }

    @Override
    public ClassWhiteList getClassWhiteList() {
        return this.classWhiteList;
    }

    @Override
    public EmbeddedCacheManagerAdmin administration() {
        this.authzHelper.checkPermission(AuthorizationPermission.ADMIN);
        return this.cacheManagerAdmin;
    }
}

