/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms.bridge;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeMarshallers;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.AttributeParsers;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.InfiniteOrPositiveValidators;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.jms.bridge.JMSBridgeAdd;
import org.wildfly.extension.messaging.activemq.jms.bridge.JMSBridgeHandler;
import org.wildfly.extension.messaging.activemq.jms.bridge.JMSBridgeRemove;

public class JMSBridgeDefinition
extends PersistentResourceDefinition {
    public static final String PAUSE = "pause";
    public static final String RESUME = "resume";
    private static final String SOURCE_CREDENTIAL_REFERENCE_NAME = "source-credential-reference";
    private static final String TARGET_CREDENTIAL_REFERENCE_NAME = "target-credential-reference";
    public static final SimpleAttributeDefinition MODULE = SimpleAttributeDefinitionBuilder.create((String)"module", (ModelType)ModelType.STRING, (boolean)false).build();
    public static final SimpleAttributeDefinition SOURCE_CONNECTION_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"source-connection-factory", (ModelType)ModelType.STRING).setAttributeGroup("source")).setXmlName("connection-factory")).build();
    public static final SimpleAttributeDefinition SOURCE_DESTINATION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"source-destination", (ModelType)ModelType.STRING).setAttributeGroup("source")).setXmlName("destination")).build();
    public static final SimpleAttributeDefinition SOURCE_USER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"source-user", (ModelType)ModelType.STRING).setAttributeGroup("source")).setXmlName("user")).setRequired(false)).setAllowExpression(true)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).build();
    public static final SimpleAttributeDefinition SOURCE_PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"source-password", (ModelType)ModelType.STRING, (boolean)true).setAttributeGroup("source")).setXmlName("password")).setAllowExpression(true)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).setAlternatives(new String[]{"source-credential-reference"})).build();
    public static final ObjectTypeAttributeDefinition SOURCE_CREDENTIAL_REFERENCE = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)CredentialReference.getAttributeBuilder((String)"source-credential-reference", (String)"source-credential-reference", (boolean)true).setAttributeGroup("source")).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).setAlternatives(new String[]{SOURCE_PASSWORD.getName()})).build();
    public static final PropertiesAttributeDefinition SOURCE_CONTEXT = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("source-context", true).setAttributeGroup("source")).setAttributeParser((AttributeParser)new AttributeParsers.PropertiesParser())).setAttributeMarshaller((AttributeMarshaller)new AttributeMarshallers.PropertiesAttributeMarshaller())).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition TARGET_CONNECTION_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"target-connection-factory", (ModelType)ModelType.STRING).setAttributeGroup("target")).setXmlName("connection-factory")).build();
    public static final SimpleAttributeDefinition TARGET_DESTINATION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"target-destination", (ModelType)ModelType.STRING).setAttributeGroup("target")).setXmlName("destination")).build();
    public static final SimpleAttributeDefinition TARGET_USER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"target-user", (ModelType)ModelType.STRING).setAttributeGroup("target")).setXmlName("user")).setRequired(false)).setAllowExpression(true)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).build();
    public static final SimpleAttributeDefinition TARGET_PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"target-password", (ModelType)ModelType.STRING, (boolean)true).setAttributeGroup("target")).setXmlName("password")).setAllowExpression(true)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).setAlternatives(new String[]{"target-credential-reference"})).build();
    public static final ObjectTypeAttributeDefinition TARGET_CREDENTIAL_REFERENCE = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)CredentialReference.getAttributeBuilder((String)"target-credential-reference", (String)"target-credential-reference", (boolean)true).setAttributeGroup("target")).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).setAlternatives(new String[]{TARGET_PASSWORD.getName()})).build();
    public static final PropertiesAttributeDefinition TARGET_CONTEXT = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("target-context", true).setAttributeGroup("target")).setAttributeParser((AttributeParser)new AttributeParsers.PropertiesParser())).setAttributeMarshaller((AttributeMarshaller)new AttributeMarshallers.PropertiesAttributeMarshaller())).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition QUALITY_OF_SERVICE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"quality-of-service", (ModelType)ModelType.STRING, (boolean)true).setValidator((ParameterValidator)new EnumValidator(QualityOfServiceMode.class, EnumSet.allOf(QualityOfServiceMode.class)))).setAllowExpression(true)).setDefaultValue(new ModelNode(QualityOfServiceMode.AT_MOST_ONCE.name()))).build();
    public static final SimpleAttributeDefinition FAILURE_RETRY_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"failure-retry-interval", (ModelType)ModelType.LONG, (boolean)true).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setValidator((ParameterValidator)InfiniteOrPositiveValidators.LONG_INSTANCE)).setAllowExpression(true)).setDefaultValue(new ModelNode(5000L))).build();
    public static final SimpleAttributeDefinition MAX_RETRIES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-retries", (ModelType)ModelType.INT, (boolean)true).setCorrector(InfiniteOrPositiveValidators.NEGATIVE_VALUE_CORRECTOR)).setValidator((ParameterValidator)InfiniteOrPositiveValidators.INT_INSTANCE)).setDefaultValue(new ModelNode(-1))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition MAX_BATCH_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-batch-size", (ModelType)ModelType.INT, (boolean)true).setValidator((ParameterValidator)new IntRangeValidator(0, Integer.MAX_VALUE, false, false))).setAllowExpression(true)).setDefaultValue(new ModelNode(1))).build();
    public static final SimpleAttributeDefinition MAX_BATCH_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-batch-time", (ModelType)ModelType.LONG, (boolean)true).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setCorrector(InfiniteOrPositiveValidators.NEGATIVE_VALUE_CORRECTOR)).setValidator((ParameterValidator)InfiniteOrPositiveValidators.LONG_INSTANCE)).setAllowExpression(true)).setDefaultValue(new ModelNode(-1L))).build();
    public static final SimpleAttributeDefinition SUBSCRIPTION_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"subscription-name", (ModelType)ModelType.STRING).setRequired(false)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition CLIENT_ID = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"client-id", (ModelType)ModelType.STRING).setRequired(false)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition ADD_MESSAGE_ID_IN_HEADER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"add-messageID-in-header", (ModelType)ModelType.BOOLEAN).setRequired(false)).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition STARTED = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"started", (ModelType)ModelType.BOOLEAN).setStorageRuntime()).build();
    public static final SimpleAttributeDefinition ABORTED_MESSAGE_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"aborted-message-count", (ModelType)ModelType.LONG).setStorageRuntime()).setUndefinedMetricValue(new ModelNode(0))).addFlag(AttributeAccess.Flag.COUNTER_METRIC)).build();
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{MODULE, QUALITY_OF_SERVICE, FAILURE_RETRY_INTERVAL, MAX_RETRIES, MAX_BATCH_SIZE, MAX_BATCH_TIME, CommonAttributes.SELECTOR, SUBSCRIPTION_NAME, CommonAttributes.CLIENT_ID, ADD_MESSAGE_ID_IN_HEADER, SOURCE_CONNECTION_FACTORY, SOURCE_DESTINATION, SOURCE_USER, SOURCE_PASSWORD, SOURCE_CREDENTIAL_REFERENCE, SOURCE_CONTEXT, TARGET_CONNECTION_FACTORY, TARGET_DESTINATION, TARGET_USER, TARGET_PASSWORD, TARGET_CREDENTIAL_REFERENCE, TARGET_CONTEXT};
    public static final AttributeDefinition[] READONLY_ATTRIBUTES = new AttributeDefinition[]{STARTED, CommonAttributes.PAUSED};
    public static final AttributeDefinition[] METRICS = new AttributeDefinition[]{CommonAttributes.MESSAGE_COUNT, ABORTED_MESSAGE_COUNT};
    public static final String[] OPERATIONS = new String[]{"start", "stop", "pause", "resume"};
    public static final JMSBridgeDefinition INSTANCE = new JMSBridgeDefinition();

    private JMSBridgeDefinition() {
        super(MessagingExtension.JMS_BRIDGE_PATH, MessagingExtension.getResourceDescriptionResolver("jms-bridge"), (OperationStepHandler)JMSBridgeAdd.INSTANCE, (OperationStepHandler)JMSBridgeRemove.INSTANCE);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        ReloadRequiredWriteAttributeHandler reloadRequiredWriteAttributeHandler = new ReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attr : ATTRIBUTES) {
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)reloadRequiredWriteAttributeHandler);
        }
        for (AttributeDefinition attr : READONLY_ATTRIBUTES) {
            registry.registerReadOnlyAttribute(attr, (OperationStepHandler)JMSBridgeHandler.INSTANCE);
        }
        for (AttributeDefinition attr : METRICS) {
            registry.registerMetric(attr, (OperationStepHandler)JMSBridgeHandler.READ_ONLY_INSTANCE);
        }
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        for (String operationName : OPERATIONS) {
            registry.registerOperationHandler((OperationDefinition)SimpleOperationDefinitionBuilder.of((String)operationName, (ResourceDescriptionResolver)this.getResourceDescriptionResolver()).build(), (OperationStepHandler)JMSBridgeHandler.INSTANCE);
        }
    }

    private static enum QualityOfServiceMode {
        AT_MOST_ONCE,
        DUPLICATES_OK,
        ONCE_AND_ONLY_ONCE;

    }
}

