/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.util.function.Supplier;
import javax.management.MBeanServer;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.JmxAuthorizer;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.extension.RuntimeHostControllerInfoAccessor;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jmx.ExposeModelResourceExpression;
import org.jboss.as.jmx.ExposeModelResourceResolved;
import org.jboss.as.jmx.JMXExtension;
import org.jboss.as.jmx.JMXSubsystemAdd;
import org.jboss.as.jmx.JMXSubsystemRemove;
import org.jboss.as.jmx.JmxAuditLoggerResourceDefinition;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.jmx.PluggableMBeanServerImpl;
import org.jboss.as.jmx.RemotingConnectorResource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.wildfly.security.auth.server.SecurityIdentity;

public class JMXSubsystemRootResource
extends SimpleResourceDefinition {
    public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"subsystem", (String)"jmx");
    private static final SimpleAttributeDefinition SHOW_MODEL_ALIAS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"show-model", (ModelType)ModelType.BOOLEAN, (boolean)true).addFlag(AttributeAccess.Flag.ALIAS)).setDeprecated(ModelVersion.create((int)7, (int)0, (int)0))).build();
    public static final SimpleAttributeDefinition NON_CORE_MBEAN_SENSITIVITY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("non-core-mbean-sensitivity", ModelType.BOOLEAN, true).setAllowExpression(true)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.ACCESS_CONTROL)).setXmlName("non-core-mbeans")).setDefaultValue(ModelNode.FALSE)).build();
    static final String JMX_CAPABILITY_NAME = "org.wildfly.management.jmx";
    static final RuntimeCapability<Void> JMX_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.management.jmx", MBeanServer.class).build();
    private final ManagedAuditLogger auditLogger;
    private final JmxAuthorizer authorizer;
    private final Supplier<SecurityIdentity> securityIdentitySupplier;
    private final RuntimeHostControllerInfoAccessor hostInfoAccessor;

    private JMXSubsystemRootResource(ManagedAuditLogger auditLogger, JmxAuthorizer authorizer, Supplier<SecurityIdentity> securityIdentitySupplier, RuntimeHostControllerInfoAccessor hostInfoAccessor) {
        super(new SimpleResourceDefinition.Parameters(PATH_ELEMENT, JMXExtension.getResourceDescriptionResolver("jmx")).setAddHandler((OperationStepHandler)new JMXSubsystemAdd(auditLogger, authorizer, securityIdentitySupplier, hostInfoAccessor)).setRemoveHandler((OperationStepHandler)new JMXSubsystemRemove(auditLogger, authorizer, securityIdentitySupplier, hostInfoAccessor)).addCapabilities(new RuntimeCapability[]{JMX_CAPABILITY}).setAccessConstraints(new AccessConstraintDefinition[]{JMXExtension.JMX_SENSITIVITY_DEF}));
        this.auditLogger = auditLogger;
        this.authorizer = authorizer;
        this.securityIdentitySupplier = securityIdentitySupplier;
        this.hostInfoAccessor = hostInfoAccessor;
    }

    public static JMXSubsystemRootResource create(ManagedAuditLogger auditLogger, JmxAuthorizer authorizer, Supplier<SecurityIdentity> securityIdentitySupplier, RuntimeHostControllerInfoAccessor hostInfoAccessor) {
        return new JMXSubsystemRootResource(auditLogger, authorizer, securityIdentitySupplier, hostInfoAccessor);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SHOW_MODEL_ALIAS, (OperationStepHandler)ShowModelAliasReadHandler.INSTANCE, (OperationStepHandler)ShowModelAliasWriteHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)NON_CORE_MBEAN_SENSITIVITY, null, (OperationStepHandler)CoreMBeansSensitivityWriteHandler.INSTANCE);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)new ExposeModelResourceResolved(this.auditLogger, this.authorizer, this.securityIdentitySupplier, this.hostInfoAccessor));
        resourceRegistration.registerSubModel((ResourceDefinition)new ExposeModelResourceExpression(this.auditLogger, this.authorizer, this.securityIdentitySupplier, this.hostInfoAccessor));
        resourceRegistration.registerSubModel((ResourceDefinition)RemotingConnectorResource.INSTANCE);
        resourceRegistration.registerSubModel((ResourceDefinition)new JmxAuditLoggerResourceDefinition(this.auditLogger));
    }

    private static class CoreMBeansSensitivityWriteHandler
    extends AbstractWriteAttributeHandler<Boolean> {
        static final CoreMBeansSensitivityWriteHandler INSTANCE = new CoreMBeansSensitivityWriteHandler();

        private CoreMBeansSensitivityWriteHandler() {
            super(new AttributeDefinition[]{NON_CORE_MBEAN_SENSITIVITY});
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Boolean> handbackHolder) throws OperationFailedException {
            this.setPluggableMBeanServerCoreSensitivity(context, resolvedValue.asBoolean());
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Boolean handback) throws OperationFailedException {
            this.setPluggableMBeanServerCoreSensitivity(context, valueToRestore.asBoolean());
        }

        private void setPluggableMBeanServerCoreSensitivity(OperationContext context, boolean sensitivity) {
            ServiceController controller = context.getServiceRegistry(false).getRequiredService(MBeanServerService.SERVICE_NAME);
            PluggableMBeanServerImpl server = (PluggableMBeanServerImpl)controller.getValue();
            server.setNonFacadeMBeansSensitive(sensitivity);
        }
    }

    private static class ShowModelAliasReadHandler
    implements OperationStepHandler {
        static final ShowModelAliasReadHandler INSTANCE = new ShowModelAliasReadHandler();

        private ShowModelAliasReadHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
            context.getResult().set(resource.hasChild(PathElement.pathElement((String)"expose-model", (String)"resolved")));
        }
    }

    private static class ShowModelAliasWriteHandler
    implements OperationStepHandler {
        static final ShowModelAliasWriteHandler INSTANCE = new ShowModelAliasWriteHandler();

        private ShowModelAliasWriteHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            boolean value = operation.get("value").asBoolean(false);
            boolean hasResource = context.readResource(PathAddress.EMPTY_ADDRESS).hasChild(ExposeModelResourceResolved.PATH_ELEMENT);
            if (value) {
                if (!hasResource) {
                    OperationStepHandler handler = context.getResourceRegistration().getOperationEntry(PathAddress.pathAddress((PathElement[])new PathElement[]{ExposeModelResourceResolved.PATH_ELEMENT}), "add").getOperationHandler();
                    ModelNode addOp = new ModelNode();
                    addOp.get("operation").set("add");
                    addOp.get("address").set(context.getCurrentAddress().append(new PathElement[]{ExposeModelResourceResolved.PATH_ELEMENT}).toModelNode());
                    context.addStep(addOp, handler, OperationContext.Stage.MODEL, true);
                }
            } else if (hasResource) {
                OperationStepHandler handler = context.getResourceRegistration().getOperationEntry(PathAddress.pathAddress((PathElement[])new PathElement[]{ExposeModelResourceResolved.PATH_ELEMENT}), "remove").getOperationHandler();
                ModelNode addOp = new ModelNode();
                addOp.get("operation").set("remove");
                addOp.get("address").set(context.getCurrentAddress().append(new PathElement[]{ExposeModelResourceResolved.PATH_ELEMENT}).toModelNode());
                context.addStep(addOp, handler, OperationContext.Stage.MODEL, true);
            }
        }
    }
}

