/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.jboss;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.jar.Manifest;
import org.jboss.migration.core.ProductInfo;
import org.jboss.migration.core.ServerMigrationFailureException;

public class ManifestProductInfo
extends ProductInfo {
    private ManifestProductInfo(String name, String version) {
        super(name, version);
    }

    public static ManifestProductInfo from(InputStream inputStream) throws ServerMigrationFailureException {
        Manifest manifest;
        try {
            manifest = new Manifest(inputStream);
        }
        catch (IOException e) {
            throw new ServerMigrationFailureException("MANIFEST load failure.", e);
        }
        String productName = manifest.getMainAttributes().getValue("JBoss-Product-Release-Name");
        if (productName == null) {
            throw new IllegalArgumentException();
        }
        String productVersion = manifest.getMainAttributes().getValue("JBoss-Product-Release-Version");
        if (productVersion == null) {
            throw new IllegalArgumentException();
        }
        return new ManifestProductInfo(productName.trim(), productVersion.trim());
    }

    public static ManifestProductInfo from(Path path) throws ServerMigrationFailureException {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return null;
        }
        try {
            return ManifestProductInfo.from(Files.newInputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new ServerMigrationFailureException("Manifest file load failed.", e);
        }
    }
}

