/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.cond;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.security.xacml.sunxacml.cond.BaseFunctionFactory;
import org.jboss.security.xacml.sunxacml.cond.BasicFunctionFactoryProxy;
import org.jboss.security.xacml.sunxacml.cond.Function;
import org.jboss.security.xacml.sunxacml.cond.FunctionFactoryProxy;
import org.jboss.security.xacml.sunxacml.cond.FunctionProxy;
import org.jboss.security.xacml.sunxacml.cond.MapFunctionProxy;
import org.jboss.security.xacml.sunxacml.cond.cluster.AbsFunctionCluster;
import org.jboss.security.xacml.sunxacml.cond.cluster.AddFunctionCluster;
import org.jboss.security.xacml.sunxacml.cond.cluster.ComparisonFunctionCluster;
import org.jboss.security.xacml.sunxacml.cond.cluster.ConditionBagFunctionCluster;
import org.jboss.security.xacml.sunxacml.cond.cluster.ConditionSetFunctionCluster;
import org.jboss.security.xacml.sunxacml.cond.cluster.DateMathFunctionCluster;
import org.jboss.security.xacml.sunxacml.cond.cluster.DivideFunctionCluster;
import org.jboss.security.xacml.sunxacml.cond.cluster.EqualFunctionCluster;
import org.jboss.security.xacml.sunxacml.cond.cluster.FloorFunctionCluster;
import org.jboss.security.xacml.sunxacml.cond.cluster.GeneralBagFunctionCluster;
import org.jboss.security.xacml.sunxacml.cond.cluster.GeneralSetFunctionCluster;
import org.jboss.security.xacml.sunxacml.cond.cluster.HigherOrderFunctionCluster;
import org.jboss.security.xacml.sunxacml.cond.cluster.LogicalFunctionCluster;
import org.jboss.security.xacml.sunxacml.cond.cluster.MatchFunctionCluster;
import org.jboss.security.xacml.sunxacml.cond.cluster.ModFunctionCluster;
import org.jboss.security.xacml.sunxacml.cond.cluster.MultiplyFunctionCluster;
import org.jboss.security.xacml.sunxacml.cond.cluster.NOfFunctionCluster;
import org.jboss.security.xacml.sunxacml.cond.cluster.NotFunctionCluster;
import org.jboss.security.xacml.sunxacml.cond.cluster.NumericConvertFunctionCluster;
import org.jboss.security.xacml.sunxacml.cond.cluster.RoundFunctionCluster;
import org.jboss.security.xacml.sunxacml.cond.cluster.StringFunctionCluster;
import org.jboss.security.xacml.sunxacml.cond.cluster.StringNormalizeFunctionCluster;
import org.jboss.security.xacml.sunxacml.cond.cluster.SubtractFunctionCluster;

public class StandardFunctionFactory
extends BaseFunctionFactory {
    private static StandardFunctionFactory targetFactory = null;
    private static StandardFunctionFactory conditionFactory = null;
    private static StandardFunctionFactory generalFactory = null;
    private static Set targetFunctions = null;
    private static Set conditionFunctions = null;
    private static Set generalFunctions = null;
    private static Map targetAbstractFunctions = null;
    private static Map conditionAbstractFunctions = null;
    private static Map generalAbstractFunctions = null;
    private static Set supportedV1Functions;
    private static Set supportedV2Functions;
    private Set supportedFunctions = null;
    private Map supportedAbstractFunctions = null;
    private static final Logger logger;

    private StandardFunctionFactory(Set supportedFunctions, Map supportedAbstractFunctions) {
        super(supportedFunctions, supportedAbstractFunctions);
        this.supportedFunctions = supportedFunctions;
        this.supportedAbstractFunctions = supportedAbstractFunctions;
    }

    private static void initTargetFunctions() {
        logger.config("Initializing standard Target functions");
        targetFunctions = new HashSet();
        targetFunctions.addAll(new EqualFunctionCluster().getSupportedFunctions());
        targetFunctions.addAll(new LogicalFunctionCluster().getSupportedFunctions());
        targetFunctions.addAll(new NOfFunctionCluster().getSupportedFunctions());
        targetFunctions.addAll(new NotFunctionCluster().getSupportedFunctions());
        targetFunctions.addAll(new ComparisonFunctionCluster().getSupportedFunctions());
        targetFunctions.addAll(new MatchFunctionCluster().getSupportedFunctions());
        targetAbstractFunctions = new HashMap();
    }

    private static void initConditionFunctions() {
        logger.config("Initializing standard Condition functions");
        if (targetFunctions == null) {
            StandardFunctionFactory.initTargetFunctions();
        }
        conditionFunctions = new HashSet(targetFunctions);
        conditionFunctions.addAll(new ConditionBagFunctionCluster().getSupportedFunctions());
        conditionFunctions.addAll(new ConditionSetFunctionCluster().getSupportedFunctions());
        conditionFunctions.addAll(new HigherOrderFunctionCluster().getSupportedFunctions());
        conditionAbstractFunctions = new HashMap(targetAbstractFunctions);
    }

    private static void initGeneralFunctions() {
        logger.config("Initializing standard General functions");
        if (conditionFunctions == null) {
            StandardFunctionFactory.initConditionFunctions();
        }
        generalFunctions = new HashSet(conditionFunctions);
        generalFunctions.addAll(new AddFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new SubtractFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new MultiplyFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new DivideFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new ModFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new AbsFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new RoundFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new FloorFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new DateMathFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new GeneralBagFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new NumericConvertFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new StringNormalizeFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new GeneralSetFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new StringFunctionCluster().getSupportedFunctions());
        generalAbstractFunctions = new HashMap(conditionAbstractFunctions);
        try {
            generalAbstractFunctions.put(new URI("urn:oasis:names:tc:xacml:1.0:function:map"), new MapFunctionProxy());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("invalid function name");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StandardFunctionFactory getTargetFactory() {
        if (targetFactory != null) return targetFactory;
        Class<StandardFunctionFactory> clazz = StandardFunctionFactory.class;
        synchronized (StandardFunctionFactory.class) {
            if (targetFunctions == null) {
                StandardFunctionFactory.initTargetFunctions();
            }
            if (targetFactory != null) return targetFactory;
            targetFactory = new StandardFunctionFactory(targetFunctions, targetAbstractFunctions);
            // ** MonitorExit[var0] (shouldn't be in output)
            return targetFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StandardFunctionFactory getConditionFactory() {
        if (conditionFactory != null) return conditionFactory;
        Class<StandardFunctionFactory> clazz = StandardFunctionFactory.class;
        synchronized (StandardFunctionFactory.class) {
            if (conditionFunctions == null) {
                StandardFunctionFactory.initConditionFunctions();
            }
            if (conditionFactory != null) return conditionFactory;
            conditionFactory = new StandardFunctionFactory(conditionFunctions, conditionAbstractFunctions);
            // ** MonitorExit[var0] (shouldn't be in output)
            return conditionFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StandardFunctionFactory getGeneralFactory() {
        if (generalFactory != null) return generalFactory;
        Class<StandardFunctionFactory> clazz = StandardFunctionFactory.class;
        synchronized (StandardFunctionFactory.class) {
            if (generalFunctions != null) return generalFactory;
            StandardFunctionFactory.initGeneralFunctions();
            generalFactory = new StandardFunctionFactory(generalFunctions, generalAbstractFunctions);
            // ** MonitorExit[var0] (shouldn't be in output)
            return generalFactory;
        }
    }

    public static Set getStandardFunctions(String xacmlVersion) {
        throw new RuntimeException("This method isn't implemented yet.");
    }

    public static Map getStandardAbstractFunctions(String xacmlVersion) {
        throw new RuntimeException("This method isn't implemented yet.");
    }

    public static FunctionFactoryProxy getNewFactoryProxy() {
        StandardFunctionFactory.getGeneralFactory();
        BaseFunctionFactory newGeneral = new BaseFunctionFactory(generalFunctions, generalAbstractFunctions);
        BaseFunctionFactory newCondition = new BaseFunctionFactory(newGeneral, conditionFunctions, conditionAbstractFunctions);
        BaseFunctionFactory newTarget = new BaseFunctionFactory(newCondition, targetFunctions, targetAbstractFunctions);
        return new BasicFunctionFactoryProxy(newTarget, newCondition, newGeneral);
    }

    @Override
    public void addFunction(Function function) throws IllegalArgumentException {
        throw new UnsupportedOperationException("a standard factory cannot support new functions");
    }

    @Override
    public void addAbstractFunction(FunctionProxy proxy, URI identity) throws IllegalArgumentException {
        throw new UnsupportedOperationException("a standard factory cannot support new functions");
    }

    static {
        logger = Logger.getLogger(StandardFunctionFactory.class.getName());
    }
}

