/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transaction;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;
import org.infinispan.client.hotrod.impl.transaction.AbstractTransactionTable;
import org.infinispan.client.hotrod.impl.transaction.TransactionContext;
import org.infinispan.client.hotrod.impl.transaction.TransactionalRemoteCacheImpl;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.transaction.manager.RemoteXid;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.tx.Util;

public class SyncModeTransactionTable
extends AbstractTransactionTable {
    private static final Log log = LogFactory.getLog(SyncModeTransactionTable.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Map<Transaction, SynchronizationAdapter> registeredTransactions = new ConcurrentHashMap<Transaction, SynchronizationAdapter>();
    private final UUID uuid = UUID.randomUUID();
    private final Consumer<Transaction> cleanup = this.registeredTransactions::remove;
    private final Function<Transaction, SynchronizationAdapter> constructor = this::createSynchronizationAdapter;

    public SyncModeTransactionTable(long timeout) {
        super(timeout);
    }

    @Override
    Log getLog() {
        return log;
    }

    @Override
    boolean isTraceLogEnabled() {
        return trace;
    }

    @Override
    public <K, V> TransactionContext<K, V> enlist(TransactionalRemoteCacheImpl<K, V> txRemoteCache, Transaction tx) {
        this.assertStartedAndReturnFactory();
        SynchronizationAdapter adapter = this.registeredTransactions.computeIfAbsent(tx, this.constructor);
        TransactionContext context = adapter.registerCache(txRemoteCache);
        if (trace) {
            log.tracef("Xid=%s retrieving context: %s", (Object)adapter.xid, context);
        }
        return context;
    }

    private SynchronizationAdapter createSynchronizationAdapter(Transaction transaction) {
        SynchronizationAdapter adapter = new SynchronizationAdapter(transaction, RemoteXid.create(this.uuid));
        try {
            transaction.registerSynchronization((Synchronization)adapter);
        }
        catch (RollbackException | SystemException e) {
            throw new CacheException(e);
        }
        if (trace) {
            log.tracef("Registered synchronization for transaction %s. Sync=%s", transaction, adapter);
        }
        return adapter;
    }

    private class SynchronizationAdapter
    implements Synchronization {
        private final Map<String, TransactionContext<?, ?>> registeredCaches = new ConcurrentSkipListMap();
        private final Transaction transaction;
        private final RemoteXid xid;

        private SynchronizationAdapter(Transaction transaction, RemoteXid xid) {
            this.transaction = transaction;
            this.xid = xid;
        }

        public String toString() {
            return "SynchronizationAdapter{registeredCaches=" + this.registeredCaches.keySet() + ", transaction=" + this.transaction + ", xid=" + (Object)((Object)this.xid) + '}';
        }

        public void beforeCompletion() {
            if (trace) {
                log.tracef("BeforeCompletion(xid=%s, remote-caches=%s)", (Object)this.xid, this.registeredCaches.keySet());
            }
            if (this.isMarkedRollback()) {
                return;
            }
            block4: for (TransactionContext<?, ?> txContext : this.registeredCaches.values()) {
                switch (txContext.prepareContext((Xid)((Object)this.xid), false, SyncModeTransactionTable.this.getTimeout())) {
                    case 0: 
                    case 3: {
                        continue block4;
                    }
                    case -2147483648: {
                        this.markAsRollback();
                        return;
                    }
                }
                this.markAsRollback();
                return;
            }
        }

        public void afterCompletion(int status) {
            if (trace) {
                log.tracef("AfterCompletion(xid=%s, status=%s, remote-caches=%s)", (Object)this.xid, Util.transactionStatusToString((int)status), this.registeredCaches.keySet());
            }
            try {
                boolean commit = status == 3;
                SyncModeTransactionTable.this.completeTransaction((Xid)((Object)this.xid), commit);
            }
            finally {
                SyncModeTransactionTable.this.forgetTransaction((Xid)((Object)this.xid));
                SyncModeTransactionTable.this.cleanup.accept(this.transaction);
            }
        }

        private void markAsRollback() {
            try {
                this.transaction.setRollbackOnly();
            }
            catch (SystemException e) {
                log.debug("Exception in markAsRollback", e);
            }
        }

        private boolean isMarkedRollback() {
            try {
                return this.transaction.getStatus() == 1;
            }
            catch (SystemException e) {
                log.debug("Exception in isMarkedRollback", e);
                return false;
            }
        }

        private <K, V> TransactionContext<K, V> registerCache(TransactionalRemoteCacheImpl<K, V> txRemoteCache) {
            return this.registeredCaches.computeIfAbsent(txRemoteCache.getName(), s -> this.createTxContext(txRemoteCache));
        }

        private <K, V> TransactionContext<K, V> createTxContext(TransactionalRemoteCacheImpl<K, V> remoteCache) {
            if (trace) {
                log.tracef("Registering remote cache '%s' for transaction xid=%s", remoteCache.getName(), (Object)this.xid);
            }
            return new TransactionContext<K, V>(remoteCache.keyMarshaller(), remoteCache.valueMarshaller(), remoteCache.getOperationsFactory(), remoteCache.getName(), false);
        }
    }
}

