/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr.util;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class WildcardPattern {
    private static final String WILDCARDS = "*";
    private final String[] tokens;

    public WildcardPattern(String pattern) {
        if (!pattern.startsWith(WILDCARDS)) {
            pattern = WILDCARDS + pattern;
        }
        StringTokenizer st = new StringTokenizer(pattern, WILDCARDS, true);
        ArrayList<String> t = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            t.add(st.nextToken());
        }
        this.tokens = t.toArray(new String[t.size()]);
    }

    public boolean matches(String target) {
        int targetIdx = 0;
        int targetEnd = target.length();
        int tokenIdx = 0;
        int tokenEnd = this.tokens.length;
        while (tokenIdx < tokenEnd && targetIdx < targetEnd && targetIdx > -1) {
            if (WILDCARDS.equals(this.tokens[tokenIdx])) {
                if (tokenIdx == tokenEnd - 1) {
                    targetIdx = targetEnd;
                    tokenIdx = tokenEnd;
                    continue;
                }
                targetIdx = target.indexOf(this.tokens[tokenIdx + 1], targetIdx);
                ++tokenIdx;
                continue;
            }
            if (target.substring(targetIdx).startsWith(this.tokens[tokenIdx])) {
                targetIdx += this.tokens[tokenIdx].length();
                ++tokenIdx;
                continue;
            }
            targetIdx = -1;
            break;
        }
        return tokenIdx == tokenEnd && targetIdx == targetEnd;
    }

    public static boolean matches(String pattern, String target) {
        return new WildcardPattern(pattern).matches(target);
    }
}

