/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.common.model.validator.AlternativeAttributeValidationStepHandler;
import org.wildfly.extension.picketlink.common.model.validator.ModelValidationStepHandler;
import org.wildfly.extension.picketlink.idm.model.PartitionManagerAddHandler;
import org.wildfly.extension.picketlink.idm.model.PartitionManagerRemoveHandler;
import org.wildfly.extension.picketlink.idm.service.PartitionManagerService;

public class IDMConfigAddStepHandler
extends RestartParentResourceAddHandler {
    private final AttributeDefinition[] attributes;
    private final List<ModelValidationStepHandler> modelValidators = new ArrayList<ModelValidationStepHandler>();

    IDMConfigAddStepHandler(AttributeDefinition ... attributes) {
        this((ModelValidationStepHandler[])null, attributes);
    }

    IDMConfigAddStepHandler(ModelValidationStepHandler[] modelValidators, AttributeDefinition ... attributes) {
        super(ModelElement.PARTITION_MANAGER.getName());
        this.attributes = attributes != null ? attributes : new AttributeDefinition[]{};
        this.configureModelValidators(modelValidators);
    }

    private void configureModelValidators(ModelValidationStepHandler[] modelValidators) {
        ArrayList<AttributeDefinition> alternativeAttributes = new ArrayList<AttributeDefinition>();
        for (AttributeDefinition attribute : this.attributes) {
            if (attribute.getAlternatives() == null || attribute.getAlternatives().length <= 0) continue;
            alternativeAttributes.add(attribute);
        }
        if (!alternativeAttributes.isEmpty()) {
            this.modelValidators.add(new AlternativeAttributeValidationStepHandler(alternativeAttributes.toArray(new AttributeDefinition[alternativeAttributes.size()]), this.isAlternativesRequired()));
        }
        if (modelValidators != null) {
            this.modelValidators.addAll(Arrays.asList(modelValidators));
        }
        this.modelValidators.add(new ModelValidationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                PathAddress address = IDMConfigAddStepHandler.this.getParentAddress(PathAddress.pathAddress((ModelNode)operation.require("address")));
                Resource resource = context.readResourceFromRoot(address);
                ModelNode parentModel = Resource.Tools.readModel((Resource)resource);
                PartitionManagerAddHandler.INSTANCE.validateModel(context, address.getLastElement().getValue(), parentModel);
            }
        });
    }

    protected boolean isAlternativesRequired() {
        return true;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.performValidation(context);
        super.execute(context, operation);
    }

    protected void performValidation(OperationContext context) {
        for (ModelValidationStepHandler validatonStepHandler : this.modelValidators) {
            context.addStep((OperationStepHandler)validatonStepHandler, OperationContext.Stage.MODEL);
        }
    }

    protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
        String federationName = parentAddress.getLastElement().getValue();
        PartitionManagerRemoveHandler.INSTANCE.removeIdentityStoreServices(context, parentModel, federationName, new String[0]);
        PartitionManagerAddHandler.INSTANCE.createPartitionManagerService(context, parentAddress.getLastElement().getValue(), parentModel, false);
    }

    protected ServiceName getParentServiceName(PathAddress parentAddress) {
        return PartitionManagerService.createServiceName(parentAddress.getLastElement().getValue());
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : this.attributes) {
            attr.validateAndSet(operation, model);
        }
    }
}

