/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.otp;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.provider.util.ProviderUtil;
import org.wildfly.security.sasl.WildFlySasl;
import org.wildfly.security.sasl.otp.OTP;
import org.wildfly.security.sasl.otp.OTPSaslClient;
import org.wildfly.security.sasl.otp.OTPUtil;

public final class OTPSaslClientFactory
implements SaslClientFactory {
    private final Supplier<Provider[]> providers;

    public OTPSaslClientFactory() {
        this.providers = ProviderUtil.INSTALLED_PROVIDERS;
    }

    public OTPSaslClientFactory(Provider provider) {
        this.providers = () -> new Provider[]{provider};
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        Assert.checkNotNullParam((String)"cbh", (Object)cbh);
        if (props == null) {
            props = Collections.emptyMap();
        }
        if (OTP.isMatched(props, false)) {
            for (String mechanism : mechanisms) {
                if (!"OTP".equals(mechanism)) continue;
                Object rngNameValue = props.get("wildfly.sasl.secure-rng");
                String rngName = rngNameValue instanceof String ? (String)rngNameValue : null;
                SecureRandom secureRandom = null;
                if (rngName != null) {
                    try {
                        secureRandom = SecureRandom.getInstance(rngName);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        // empty catch block
                    }
                }
                String alternateDictionaryProperty = (String)props.get("wildfly.sasl.otp.alternate-dictionary");
                String[] alternateDictionary = null;
                if (alternateDictionaryProperty != null && !alternateDictionaryProperty.isEmpty()) {
                    alternateDictionary = OTPSaslClientFactory.dictionaryPropertyToArray(alternateDictionaryProperty);
                    OTPUtil.validateAlternateDictionary(alternateDictionary);
                }
                OTPSaslClient client = new OTPSaslClient(mechanism, secureRandom, alternateDictionary, protocol, serverName, cbh, authorizationId, this.providers);
                client.init();
                return client;
            }
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        String[] stringArray;
        if (OTP.isMatched(props, true)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "OTP";
        } else {
            stringArray = WildFlySasl.NO_NAMES;
        }
        return stringArray;
    }

    public static String dictionaryArrayToProperty(String[] dictionaryArray) {
        StringBuilder dictionary = new StringBuilder();
        for (int i = 0; i < dictionaryArray.length; ++i) {
            if (i != 0) {
                dictionary.append(' ');
            }
            dictionary.append(dictionaryArray[i]);
        }
        return dictionary.toString();
    }

    static String[] dictionaryPropertyToArray(String property) throws SaslException {
        String[] dictionary = new String[2048];
        CodePointIterator cpi = CodePointIterator.ofString((String)property);
        CodePointIterator di = cpi.delimitedBy(new int[]{32});
        for (int i = 0; i < dictionary.length; ++i) {
            dictionary[i] = di.drainToString();
            OTPUtil.skipDelims(di, cpi, 32);
        }
        return dictionary;
    }
}

