/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly13.task.subsystem.elytron;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.wfly11.task.subsystem.elytron.PermissionMapping;
import org.jboss.migration.wfly13.task.subsystem.elytron.PermissionSetMapping;

public class SimplePermissionMapperAddOperationV3 {
    private final PathAddress subsystemPathAddress;
    private final String simplePermissionMapper;
    private String mappingMode;
    private List<PermissionMappingsElement> permissionMappings;

    public SimplePermissionMapperAddOperationV3(PathAddress subsystemPathAddress, String simplePermissionMapper) {
        this.subsystemPathAddress = subsystemPathAddress;
        this.simplePermissionMapper = simplePermissionMapper;
        this.permissionMappings = new ArrayList<PermissionMappingsElement>();
    }

    public SimplePermissionMapperAddOperationV3 mappingMode(String mappingMode) {
        this.mappingMode = mappingMode;
        return this;
    }

    public SimplePermissionMapperAddOperationV3 addPermissionMapping(PermissionMapping permissionMapping) {
        this.permissionMappings.add(() -> permissionMapping.toModelNode());
        return this;
    }

    public SimplePermissionMapperAddOperationV3 addPermissionSetMapping(PermissionSetMapping permissionSetMapping) {
        this.permissionMappings.add(() -> permissionSetMapping.toModelNode());
        return this;
    }

    public ModelNode toModelNode() {
        PathAddress pathAddress = this.subsystemPathAddress.append("simple-permission-mapper", this.simplePermissionMapper);
        ModelNode operation = Util.createAddOperation((PathAddress)pathAddress);
        if (this.mappingMode != null) {
            operation.get("mapping-mode").set(this.mappingMode);
        }
        if (this.permissionMappings != null && !this.permissionMappings.isEmpty()) {
            ModelNode permissionMappingsNode = operation.get("permission-mappings").setEmptyList();
            for (PermissionMappingsElement permissionMapping : this.permissionMappings) {
                permissionMappingsNode.add(permissionMapping.toModelNode());
            }
        }
        return operation;
    }

    private static interface PermissionMappingsElement {
        public ModelNode toModelNode();
    }
}

