/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.lms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.bouncycastle.pqc.crypto.lms.Composer;
import org.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import org.bouncycastle.pqc.crypto.lms.LMSSignature;
import org.bouncycastle.pqc.crypto.lms.LMSSignedPubKey;
import org.bouncycastle.util.Encodable;
import org.bouncycastle.util.io.Streams;

public class HSSSignature
implements Encodable {
    private final int lMinus1;
    private final LMSSignedPubKey[] signedPubKey;
    private final LMSSignature signature;

    public HSSSignature(int lMinus1, LMSSignedPubKey[] signedPubKey, LMSSignature signature) {
        this.lMinus1 = lMinus1;
        this.signedPubKey = signedPubKey;
        this.signature = signature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HSSSignature getInstance(Object src, int L) throws IOException {
        if (src instanceof HSSSignature) {
            return (HSSSignature)src;
        }
        if (src instanceof DataInputStream) {
            int lminus = ((DataInputStream)src).readInt();
            if (lminus != L - 1) {
                throw new IllegalStateException("nspk exceeded maxNspk");
            }
            LMSSignedPubKey[] signedPubKeys = new LMSSignedPubKey[lminus];
            if (lminus != 0) {
                for (int t = 0; t < signedPubKeys.length; ++t) {
                    signedPubKeys[t] = new LMSSignedPubKey(LMSSignature.getInstance(src), LMSPublicKeyParameters.getInstance(src));
                }
            }
            LMSSignature sig = LMSSignature.getInstance(src);
            return new HSSSignature(lminus, signedPubKeys, sig);
        }
        if (src instanceof byte[]) {
            InputStream in = null;
            try {
                in = new DataInputStream(new ByteArrayInputStream((byte[])src));
                HSSSignature hSSSignature = HSSSignature.getInstance(in, L);
                return hSSSignature;
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        if (src instanceof InputStream) {
            return HSSSignature.getInstance(Streams.readAll((InputStream)src), L);
        }
        throw new IllegalArgumentException("cannot parse " + src);
    }

    public int getlMinus1() {
        return this.lMinus1;
    }

    public LMSSignedPubKey[] getSignedPubKey() {
        return this.signedPubKey;
    }

    public LMSSignature getSignature() {
        return this.signature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HSSSignature signature1 = (HSSSignature)o;
        if (this.lMinus1 != signature1.lMinus1) {
            return false;
        }
        if (this.signedPubKey.length != signature1.signedPubKey.length) {
            return false;
        }
        for (int t = 0; t < this.signedPubKey.length; ++t) {
            if (this.signedPubKey[t].equals(signature1.signedPubKey[t])) continue;
            return false;
        }
        return this.signature != null ? this.signature.equals(signature1.signature) : signature1.signature == null;
    }

    public int hashCode() {
        int result = this.lMinus1;
        result = 31 * result + Arrays.hashCode(this.signedPubKey);
        result = 31 * result + (this.signature != null ? this.signature.hashCode() : 0);
        return result;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        Composer composer = Composer.compose();
        composer.u32str(this.lMinus1);
        if (this.signedPubKey != null) {
            for (LMSSignedPubKey sigPub : this.signedPubKey) {
                composer.bytes(sigPub);
            }
        }
        composer.bytes(this.signature);
        return composer.build();
    }
}

