/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.james.mime4j.message.TextBody;
import org.apache.james.mime4j.util.CharsetUtil;

class StringTextBody
extends TextBody {
    private final String text;
    private final Charset charset;

    public StringTextBody(String text, Charset charset) {
        this.text = text;
        this.charset = charset;
    }

    @Override
    public String getMimeCharset() {
        return CharsetUtil.toMimeCharset(this.charset.name());
    }

    @Override
    public Reader getReader() throws IOException {
        return new StringReader(this.text);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        int nChars;
        if (out == null) {
            throw new IllegalArgumentException();
        }
        StringReader reader = new StringReader(this.text);
        OutputStreamWriter writer = new OutputStreamWriter(out, this.charset);
        char[] buffer = new char[1024];
        while ((nChars = reader.read(buffer)) != -1) {
            ((Writer)writer).write(buffer, 0, nChars);
        }
        ((Reader)reader).close();
        ((Writer)writer).flush();
    }

    @Override
    public StringTextBody copy() {
        return new StringTextBody(this.text, this.charset);
    }
}

