/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.util.OptionalInt;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.SizeComputingProtoStreamWriter;

public interface Marshallable<T> {
    public T readFrom(ProtoStreamReader var1) throws IOException;

    public void writeTo(ProtoStreamWriter var1, T var2) throws IOException;

    default public OptionalInt size(ImmutableSerializationContext context, T value) {
        SizeComputingProtoStreamWriter writer = new SizeComputingProtoStreamWriter(context);
        try {
            this.writeTo(writer, value);
            return writer.get();
        }
        catch (IOException e) {
            return OptionalInt.empty();
        }
    }

    public Class<? extends T> getJavaClass();
}

