/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter.constpool;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.classfilewriter.WritableEntry;
import org.jboss.classfilewriter.constpool.ClassEntry;
import org.jboss.classfilewriter.constpool.ConstPoolEntry;
import org.jboss.classfilewriter.constpool.DoubleEntry;
import org.jboss.classfilewriter.constpool.FieldRefEntry;
import org.jboss.classfilewriter.constpool.FloatEntry;
import org.jboss.classfilewriter.constpool.IntegerEntry;
import org.jboss.classfilewriter.constpool.InterfaceMethodRefEntry;
import org.jboss.classfilewriter.constpool.LongEntry;
import org.jboss.classfilewriter.constpool.MethodRefEntry;
import org.jboss.classfilewriter.constpool.NameAndTypeEntry;
import org.jboss.classfilewriter.constpool.StringEntry;
import org.jboss.classfilewriter.constpool.Utf8Entry;
import org.jboss.classfilewriter.util.ByteArrayDataOutputStream;

public class ConstPool
implements WritableEntry {
    private final LinkedHashMap<Integer, ConstPoolEntry> entries = new LinkedHashMap();
    private final Map<String, Integer> utf8Locations = new HashMap<String, Integer>();
    private final Map<String, Integer> classLocations = new HashMap<String, Integer>();
    private final Map<String, Integer> stringLocations = new HashMap<String, Integer>();
    private final Map<NameAndType, Integer> nameAndTypeLocations = new HashMap<NameAndType, Integer>();
    private final Map<MemberInfo, Integer> fieldLocations = new HashMap<MemberInfo, Integer>();
    private final Map<MemberInfo, Integer> methodLocations = new HashMap<MemberInfo, Integer>();
    private final Map<MemberInfo, Integer> interfaceMethodLocations = new HashMap<MemberInfo, Integer>();
    private final Map<Integer, Integer> integerLocations = new HashMap<Integer, Integer>();
    private final Map<Float, Integer> floatLocations = new HashMap<Float, Integer>();
    private final Map<Long, Integer> longLocations = new HashMap<Long, Integer>();
    private final Map<Double, Integer> doubleLocations = new HashMap<Double, Integer>();
    private int count = 1;
    private Integer constPoolSize = 1;

    public Integer addUtf8Entry(String entry) {
        if (this.utf8Locations.containsKey(entry)) {
            return this.utf8Locations.get(entry);
        }
        int index = this.count++;
        Integer n = this.constPoolSize;
        Integer n2 = this.constPoolSize = Integer.valueOf(this.constPoolSize + 1);
        this.entries.put(index, new Utf8Entry(entry));
        this.utf8Locations.put(entry, index);
        return index;
    }

    public Integer addClassEntry(String className) {
        if (this.classLocations.containsKey(className = className.replace('.', '/'))) {
            return this.classLocations.get(className);
        }
        Integer utf8Location = this.addUtf8Entry(className);
        Integer index = this.count++;
        Integer n = this.constPoolSize;
        Integer n2 = this.constPoolSize = Integer.valueOf(this.constPoolSize + 1);
        this.entries.put(index, new ClassEntry(utf8Location));
        this.classLocations.put(className, index);
        return index;
    }

    public Integer addStringEntry(String string) {
        if (this.stringLocations.containsKey(string)) {
            return this.stringLocations.get(string);
        }
        Integer utf8Location = this.addUtf8Entry(string);
        Integer index = this.count++;
        Integer n = this.constPoolSize;
        Integer n2 = this.constPoolSize = Integer.valueOf(this.constPoolSize + 1);
        this.entries.put(index, new StringEntry(utf8Location));
        this.stringLocations.put(string, index);
        return index;
    }

    public Integer addIntegerEntry(int entry) {
        if (this.integerLocations.containsKey(entry)) {
            return this.integerLocations.get(entry);
        }
        Integer index = this.count++;
        Integer n = this.constPoolSize;
        Integer n2 = this.constPoolSize = Integer.valueOf(this.constPoolSize + 1);
        this.entries.put(index, new IntegerEntry(entry));
        this.integerLocations.put(entry, index);
        return index;
    }

    public Integer addFloatEntry(float entry) {
        if (this.floatLocations.containsKey(Float.valueOf(entry))) {
            return this.floatLocations.get(Float.valueOf(entry));
        }
        Integer index = this.count++;
        Integer n = this.constPoolSize;
        Integer n2 = this.constPoolSize = Integer.valueOf(this.constPoolSize + 1);
        this.entries.put(index, new FloatEntry(entry));
        this.floatLocations.put(Float.valueOf(entry), index);
        return index;
    }

    public Integer addLongEntry(long entry) {
        if (this.longLocations.containsKey(entry)) {
            return this.longLocations.get(entry);
        }
        Integer index = this.count++;
        ++this.count;
        this.constPoolSize = this.constPoolSize + 2;
        this.entries.put(index, new LongEntry(entry));
        this.longLocations.put(entry, index);
        return index;
    }

    public Integer addDoubleEntry(double entry) {
        if (this.doubleLocations.containsKey(entry)) {
            return this.doubleLocations.get(entry);
        }
        Integer index = this.count++;
        ++this.count;
        this.constPoolSize = this.constPoolSize + 2;
        this.entries.put(index, new DoubleEntry(entry));
        this.doubleLocations.put(entry, index);
        return index;
    }

    public Integer addNameAndTypeEntry(String name, String type) {
        NameAndType typeInfo = new NameAndType(name, type);
        if (this.nameAndTypeLocations.containsKey(typeInfo)) {
            return this.nameAndTypeLocations.get(typeInfo);
        }
        Integer nameIndex = this.addUtf8Entry(name);
        Integer typeIndex = this.addUtf8Entry(type);
        Integer index = this.count++;
        Integer n = this.constPoolSize;
        Integer n2 = this.constPoolSize = Integer.valueOf(this.constPoolSize + 1);
        this.entries.put(index, new NameAndTypeEntry(nameIndex, typeIndex));
        this.nameAndTypeLocations.put(typeInfo, index);
        return index;
    }

    public Integer addFieldEntry(String className, String fieldName, String fieldType) {
        NameAndType nameAndType = new NameAndType(fieldName, fieldType);
        MemberInfo field = new MemberInfo(className, nameAndType);
        if (this.fieldLocations.containsKey(field)) {
            return this.fieldLocations.get(field);
        }
        Integer nameAndTypeIndex = this.addNameAndTypeEntry(fieldName, fieldType);
        Integer classIndex = this.addClassEntry(className);
        Integer index = this.count++;
        Integer n = this.constPoolSize;
        Integer n2 = this.constPoolSize = Integer.valueOf(this.constPoolSize + 1);
        this.entries.put(index, new FieldRefEntry(classIndex, nameAndTypeIndex));
        this.fieldLocations.put(field, index);
        return index;
    }

    public Integer addMethodEntry(String className, String methodName, String descriptor) {
        NameAndType nameAndType = new NameAndType(methodName, descriptor);
        MemberInfo method = new MemberInfo(className, nameAndType);
        if (this.methodLocations.containsKey(method)) {
            return this.methodLocations.get(method);
        }
        Integer nameAndTypeIndex = this.addNameAndTypeEntry(methodName, descriptor);
        Integer classIndex = this.addClassEntry(className);
        Integer index = this.count++;
        Integer n = this.constPoolSize;
        Integer n2 = this.constPoolSize = Integer.valueOf(this.constPoolSize + 1);
        this.entries.put(index, new MethodRefEntry(classIndex, nameAndTypeIndex));
        this.methodLocations.put(method, index);
        return index;
    }

    public Integer addInterfaceMethodEntry(String className, String methodName, String descriptor) {
        NameAndType nameAndType = new NameAndType(methodName, descriptor);
        MemberInfo method = new MemberInfo(className, nameAndType);
        if (this.interfaceMethodLocations.containsKey(method)) {
            return this.interfaceMethodLocations.get(method);
        }
        Integer nameAndTypeIndex = this.addNameAndTypeEntry(methodName, descriptor);
        Integer classIndex = this.addClassEntry(className);
        Integer index = this.count++;
        Integer n = this.constPoolSize;
        Integer n2 = this.constPoolSize = Integer.valueOf(this.constPoolSize + 1);
        this.entries.put(index, new InterfaceMethodRefEntry(classIndex, nameAndTypeIndex));
        this.interfaceMethodLocations.put(method, index);
        return index;
    }

    @Override
    public void write(ByteArrayDataOutputStream stream) throws IOException {
        stream.writeShort(this.constPoolSize);
        for (Map.Entry<Integer, ConstPoolEntry> entry : this.entries.entrySet()) {
            entry.getValue().write(stream);
        }
    }

    private static class MemberInfo {
        private final String className;
        private final NameAndType nameAndType;

        public MemberInfo(String className, NameAndType nameAndType) {
            this.className = className;
            this.nameAndType = nameAndType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
            result = 31 * result + (this.nameAndType == null ? 0 : this.nameAndType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MemberInfo other = (MemberInfo)obj;
            if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
                return false;
            }
            return !(this.nameAndType == null ? other.nameAndType != null : !this.nameAndType.equals(other.nameAndType));
        }
    }

    private static final class NameAndType {
        private final String name;
        private final String type;

        public NameAndType(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NameAndType other = (NameAndType)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }
}

