/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;
import org.wildfly.clustering.marshalling.spi.util.BoundedCollectionExternalizer;

public class HashSetExternalizer<T extends Set<Object>>
extends BoundedCollectionExternalizer<T> {
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final IntUnaryOperator CAPACITY = new IntUnaryOperator(){

        @Override
        public int applyAsInt(int size) {
            return size * 2;
        }
    };

    public HashSetExternalizer(Class<T> targetClass, IntFunction<T> factory) {
        super(targetClass, new CapacityFactory<T>(factory));
    }

    public static class CapacityFactory<T>
    implements Function<Integer, T>,
    IntFunction<T> {
        private final IntFunction<T> factory;

        public CapacityFactory(IntFunction<T> factory) {
            this.factory = factory;
        }

        @Override
        public T apply(Integer size) {
            return this.apply((int)size);
        }

        @Override
        public T apply(int size) {
            return this.factory.apply(CAPACITY.applyAsInt(size));
        }
    }
}

