/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.handlers;

import java.util.HashMap;
import java.util.Map;
import org.picketlink.identity.federation.web.handlers.saml2.RolesGenerationHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2AttributeHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2AuthenticationHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2EncryptionHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2InResponseToVerificationHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2IssuerTrustHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2LogOutHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2SignatureGenerationHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2SignatureValidationHandler;

public enum HandlerTypeEnum {
    SAML2_ISSUER_TRUST_HANDLER("SAML2IssuerTrustHandler", SAML2IssuerTrustHandler.class.getName()),
    SAML2_AUTHENTICATION_HANDLER("SAML2AuthenticationHandler", SAML2AuthenticationHandler.class.getName()),
    ROLES_GENERATION_HANDLER("RolesGenerationHandler", RolesGenerationHandler.class.getName()),
    SAML2_ATTRIBUTE_HANDLER("SAML2AttributeHandler", SAML2AttributeHandler.class.getName()),
    SAML2_ENCRYPTION_HANDLER("SAML2EncryptionHandler", SAML2EncryptionHandler.class.getName()),
    SAML2_IN_RESPONSE_VERIFICATION_HANDLER("SAML2InResponseToVerificationHandler", SAML2InResponseToVerificationHandler.class.getName()),
    SAML2_LOGOUT_HANDLER("SAML2LogOutHandler", SAML2LogOutHandler.class.getName()),
    SAML2_SIGNATURE_GENERATION_HANDLER("SAML2SignatureGenerationHandler", SAML2SignatureGenerationHandler.class.getName()),
    SAML2_SIGNATURE_VALIDATION_HANDLER("SAML2SignatureValidationHandler", SAML2SignatureValidationHandler.class.getName());

    private static final Map<String, HandlerTypeEnum> types;
    private final String alias;
    private final String type;

    private HandlerTypeEnum(String alias, String type) {
        this.alias = alias;
        this.type = type;
    }

    public static String forType(String alias) {
        HandlerTypeEnum resolvedType = types.get(alias);
        if (resolvedType != null) {
            return resolvedType.getType();
        }
        return null;
    }

    public String toString() {
        return this.alias;
    }

    String getAlias() {
        return this.alias;
    }

    String getType() {
        return this.type;
    }

    static {
        types = new HashMap<String, HandlerTypeEnum>();
        for (HandlerTypeEnum element : HandlerTypeEnum.values()) {
            types.put(element.getAlias(), element);
        }
    }
}

