/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.core.task.component.TaskSkipPolicy;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceBuildParameters;
import org.jboss.migration.wfly10.config.task.management.subsystem.AddSubsystemResourceSubtaskBuilder;
import org.jboss.migration.wfly10.config.task.management.subsystem.AddSubsystemResources;

public class AddJmxSubsystemToHosts<S>
extends AddSubsystemResources<S> {
    public AddJmxSubsystemToHosts() {
        super("org.jboss.as.jmx", new AddJMXSubsystemConfig());
        this.skipPolicyBuilders(new TaskSkipPolicy.Builder[]{this.getSkipPolicyBuilder(), buildParameters -> context -> buildParameters.getServerConfiguration().getConfigurationPath().getPath().endsWith("standalone-load-balancer.xml")});
    }

    public static class AddJMXSubsystemConfig<S>
    extends AddSubsystemResourceSubtaskBuilder<S> {
        private static final String EXPOSE_MODEL = "expose-model";
        private static final String RESOLVED = "resolved";
        private static final String EXPRESSION = "expression";
        private static final String REMOTING_CONNECTOR = "remoting-connector";
        private static final String JMX = "jmx";

        protected AddJMXSubsystemConfig() {
            super(JMX);
        }

        @Override
        protected void addConfiguration(ManageableResourceBuildParameters<S, SubsystemResource.Parent> params, TaskContext taskContext) {
            super.addConfiguration(params, taskContext);
            ManageableServerConfiguration serverConfiguration = params.getServerConfiguration();
            PathAddress subsystemPathAddress = params.getResource().getSubsystemResourcePathAddress(this.getSubsystem());
            ModelNode exposeResolvedModelAddOperation = Util.createAddOperation((PathAddress)subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)EXPOSE_MODEL, (String)RESOLVED)}));
            serverConfiguration.executeManagementOperation(exposeResolvedModelAddOperation);
            ModelNode exposeExpressionModelAddOperation = Util.createAddOperation((PathAddress)subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)EXPOSE_MODEL, (String)EXPRESSION)}));
            serverConfiguration.executeManagementOperation(exposeExpressionModelAddOperation);
            ModelNode remotingConnectorAddOperation = Util.createAddOperation((PathAddress)subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)REMOTING_CONNECTOR, (String)JMX)}));
            serverConfiguration.executeManagementOperation(remotingConnectorAddOperation);
        }
    }
}

