/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.impl;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.util.Experimental;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollectors;
import org.infinispan.remoting.transport.ValidResponseCollector;
import org.infinispan.util.concurrent.CompletableFutures;

@Experimental
public abstract class MapResponseCollector
extends ValidResponseCollector<Map<Address, Response>> {
    private static final int DEFAULT_EXPECTED_SIZE = 4;
    protected final HashMap<Address, Response> map;
    private Exception exception;

    public static MapResponseCollector validOnly(int expectedSize) {
        return new ValidOnly(expectedSize);
    }

    public static MapResponseCollector validOnly() {
        return new ValidOnly(4);
    }

    public static MapResponseCollector ignoreLeavers(int expectedSize) {
        return new IgnoreLeavers(expectedSize);
    }

    public static MapResponseCollector ignoreLeavers() {
        return new IgnoreLeavers(4);
    }

    public static MapResponseCollector ignoreLeavers(boolean ignoreLeavers, int expectedSize) {
        return ignoreLeavers ? MapResponseCollector.ignoreLeavers(expectedSize) : MapResponseCollector.validOnly(expectedSize);
    }

    public static MapResponseCollector ignoreLeavers(boolean ignoreLeavers) {
        return ignoreLeavers ? MapResponseCollector.ignoreLeavers() : MapResponseCollector.validOnly();
    }

    private MapResponseCollector(int expectedSize) {
        this.map = new HashMap(expectedSize);
    }

    @Override
    protected Map<Address, Response> addException(Address sender, Exception exception) {
        this.recordException((Exception)((Object)ResponseCollectors.wrapRemoteException(sender, exception)));
        return null;
    }

    protected void recordException(Exception e) {
        if (this.exception == null) {
            this.exception = e;
        } else if (this.exception != e) {
            this.exception.addSuppressed(e);
        }
    }

    @Override
    protected Map<Address, Response> addValidResponse(Address sender, ValidResponse response) {
        this.map.put(sender, response);
        return null;
    }

    @Override
    public Map<Address, Response> finish() {
        if (this.exception != null) {
            throw CompletableFutures.asCompletionException(this.exception);
        }
        return this.map;
    }

    private static class IgnoreLeavers
    extends MapResponseCollector {
        IgnoreLeavers(int expectedSize) {
            super(expectedSize);
        }

        @Override
        protected Map<Address, Response> addTargetNotFound(Address sender) {
            this.map.put(sender, CacheNotFoundResponse.INSTANCE);
            return null;
        }
    }

    private static class ValidOnly
    extends MapResponseCollector {
        ValidOnly(int expectedSize) {
            super(expectedSize);
        }

        @Override
        protected Map<Address, Response> addTargetNotFound(Address sender) {
            this.recordException((Exception)((Object)ResponseCollectors.remoteNodeSuspected(sender)));
            return null;
        }
    }
}

