/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.session.oob;

import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionAttributes;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionMetaData;
import org.wildfly.clustering.web.session.oob.OOBSessionAttributes;
import org.wildfly.clustering.web.session.oob.OOBSessionMetaData;

public class OOBSession<L, B extends Batch>
implements Session<L> {
    private final SessionManager<L, B> manager;
    private final String id;
    private final L localContext;
    private final SessionMetaData metaData;
    private final SessionAttributes attributes;

    public OOBSession(SessionManager<L, B> manager, String id, L localContext) {
        this.manager = manager;
        this.id = id;
        this.localContext = localContext;
        this.metaData = new OOBSessionMetaData<L, B>(manager, id);
        this.attributes = new OOBSessionAttributes<L, B>(manager, id);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isValid() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            boolean bl = this.manager.readSession(this.id) != null;
            return bl;
        }
    }

    @Override
    public SessionMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public void invalidate() {
        try (Batch batch = this.manager.getBatcher().createBatch();
             Session<L> session = this.manager.findSession(this.id);){
            if (session == null) {
                throw new IllegalStateException();
            }
            session.invalidate();
        }
    }

    @Override
    public SessionAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public L getLocalContext() {
        return this.localContext;
    }

    @Override
    public void close() {
    }
}

