/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ByteString;

public class IracMetadataRequestCommand
implements CacheRpcCommand,
TopologyAffectedCommand {
    public static final byte COMMAND_ID = 124;
    private ByteString cacheName;
    private int segment;
    private int topologyId = -1;

    public IracMetadataRequestCommand() {
    }

    public IracMetadataRequestCommand(ByteString cacheName) {
        this.cacheName = cacheName;
    }

    public IracMetadataRequestCommand(ByteString cacheName, int segment) {
        this.cacheName = cacheName;
        this.segment = segment;
    }

    @Override
    public ByteString getCacheName() {
        return this.cacheName;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) throws Throwable {
        return CompletableFuture.completedFuture(registry.getIracVersionGenerator().running().generateNewMetadata(this.segment));
    }

    @Override
    public byte getCommandId() {
        return 124;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeInt(this.segment);
        output.writeInt(this.topologyId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException {
        this.segment = input.readInt();
        this.topologyId = input.readInt();
    }

    @Override
    public Address getOrigin() {
        return null;
    }

    @Override
    public void setOrigin(Address origin) {
    }

    public String toString() {
        return "IracMetadataRequestCommand{cacheName=" + this.cacheName + ", segment=" + this.segment + ", topologyId=" + this.topologyId + '}';
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }
}

