/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.Execution;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.validator.CommandValidatorException;
import org.aesh.command.validator.OptionValidatorException;

public class Executor<T extends CommandInvocation> {
    private final List<Execution<T>> executions;
    private final Set<Execution<T>> skip = new HashSet<Execution<T>>();

    public Executor(List<Execution<T>> executions) {
        this.executions = Collections.unmodifiableList(executions);
    }

    public void execute() throws CommandException, CommandValidatorException, InterruptedException, RuntimeException, CommandLineParserException, OptionValidatorException {
        Execution<T> exec;
        while ((exec = this.getNextExecution()) != null) {
            exec.execute();
        }
    }

    public List<Execution<T>> getExecutions() {
        return this.executions;
    }

    public boolean hasNext() {
        return this.getNextExecution() != null;
    }

    public Execution<T> getNextExecution() {
        if (this.executions.isEmpty()) {
            return null;
        }
        int index = 0;
        for (Execution<T> execution : this.executions) {
            if (execution.getResult() == null && !this.skip.contains(execution)) break;
            ++index;
        }
        if (index == 0) {
            return this.executions.get(index);
        }
        if (index == this.executions.size()) {
            return null;
        }
        int n = 1;
        while (this.executions.get(index - n).getResult() == null) {
            ++n;
        }
        int i = index - 1;
        CommandResult lastResult = this.executions.get(index - n).getResult();
        while (i < this.executions.size() - 1) {
            Execution<T> exec = this.executions.get(i);
            if (exec.getExecutable().canExecuteNext(lastResult)) {
                return this.executions.get(i + 1);
            }
            this.skip.add(this.executions.get(++i));
        }
        return null;
    }

    public void clearSkippedListData() {
        if (this.skip.size() > 0) {
            for (Execution<T> execution : this.skip) {
                execution.clearQueuedLine();
            }
        }
    }

    public boolean hasSkipped() {
        return this.skip.size() > 0;
    }
}

