/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.DataInput;
import java.io.IOException;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.DefaultProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;

public class ProtoStreamDataInput
implements DataInput {
    private final ProtoStreamReader reader;

    public ProtoStreamDataInput(ImmutableSerializationContext context, RawProtoStreamReader reader) {
        this.reader = new DefaultProtoStreamReader(context, reader);
    }

    public ProtoStreamDataInput(ProtoStreamReader reader) {
        this.reader = reader;
    }

    @Override
    public void readFully(byte[] bytes) throws IOException {
        this.readFully(bytes, 0, bytes.length);
    }

    @Override
    public void readFully(byte[] buffer, int offset, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            buffer[i + offset] = this.reader.readRawByte();
        }
    }

    @Override
    public int skipBytes(int bytes) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.reader.readBool();
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.reader.readUInt32();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return Byte.toUnsignedInt((byte)this.reader.readUInt32());
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.reader.readUInt32();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return Short.toUnsignedInt((short)this.reader.readUInt32());
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.reader.readUInt32();
    }

    @Override
    public int readInt() throws IOException {
        return this.reader.readSInt32();
    }

    @Override
    public long readLong() throws IOException {
        return this.reader.readSInt64();
    }

    @Override
    public float readFloat() throws IOException {
        return this.reader.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.reader.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.readUTF();
    }

    @Override
    public String readUTF() throws IOException {
        return this.reader.readString();
    }
}

