/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.lang.reflect.Field;
import java.security.PrivilegedAction;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.infinispan.protostream.impl.WireFormat;
import org.wildfly.clustering.marshalling.protostream.Any;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.util.EnumSetBuilder;
import org.wildfly.clustering.marshalling.protostream.util.EnumSetFieldSetMarshaller;
import org.wildfly.security.manager.WildFlySecurityManager;

public class EnumMapMarshaller<E extends Enum<E>>
implements ProtoStreamMarshaller<EnumMap<E, Object>> {
    private static final int ENUM_SET_INDEX = 1;
    private final FieldSetMarshaller<EnumSet<E>, EnumSetBuilder<E>> marshaller = new EnumSetFieldSetMarshaller();
    private final int valueIndex = this.marshaller.getFields() + 1;

    @Override
    public EnumMap<E, Object> readFrom(ProtoStreamReader reader) throws IOException {
        EnumSetBuilder<E> builder = this.marshaller.getBuilder();
        LinkedList<Object> values = new LinkedList<Object>();
        boolean reading = true;
        while (reading) {
            int tag = reader.readTag();
            int index = WireFormat.getTagFieldNumber((int)tag);
            if (index >= 1 && index < 1 + this.marshaller.getFields()) {
                builder = this.marshaller.readField(reader, index - 1, builder);
                continue;
            }
            if (index == this.valueIndex) {
                values.add(reader.readObject(Any.class).get());
                continue;
            }
            reading = tag != 0 && reader.skipField(tag);
        }
        EnumSet enumSet = (EnumSet)builder.build();
        Iterator enumValues = enumSet.iterator();
        EnumMap enumMap = new EnumMap(builder.getEnumClass());
        for (Object e : values) {
            enumMap.put((E)((Enum)enumValues.next()), e);
        }
        return enumMap;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, EnumMap<E, Object> map) throws IOException {
        EnumSet<E> set = EnumSet.noneOf(this.findEnumClass(map));
        set.addAll(map.keySet());
        this.marshaller.writeFields(writer, 1, set);
        for (Object value : map.values()) {
            writer.writeObject(this.valueIndex, new Any(value));
        }
    }

    @Override
    public Class<? extends EnumMap<E, Object>> getJavaClass() {
        return EnumMap.class;
    }

    private Class<E> findEnumClass(final EnumMap<E, Object> map) {
        Iterator<E> values = map.keySet().iterator();
        if (values.hasNext()) {
            return ((Enum)values.next()).getDeclaringClass();
        }
        return (Class)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Class<E>>(){

            @Override
            public Class<E> run() {
                try {
                    Field field = EnumMap.class.getDeclaredField("keyType");
                    field.setAccessible(true);
                    return (Class)field.get(map);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }
}

