/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.RoleMapper;

public class RoleAddingInterceptor
implements Interceptor {
    private final String category;
    private final RoleMapper roleMapper;

    public RoleAddingInterceptor(String category, RoleMapper roleMapper) {
        this.category = category;
        this.roleMapper = roleMapper;
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        SecurityDomain securityDomain = (SecurityDomain)context.getPrivateData(SecurityDomain.class);
        Assert.checkNotNullParam((String)"securityDomain", (Object)securityDomain);
        SecurityIdentity currentIdentity = securityDomain.getCurrentSecurityIdentity();
        RoleMapper mergeMapper = this.roleMapper.or(roles -> currentIdentity.getRoles(this.category));
        SecurityIdentity newIdentity = currentIdentity.withRoleMapper(this.category, mergeMapper);
        try {
            return newIdentity.runAs((PrivilegedExceptionAction)context);
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw new RuntimeException(e);
            }
            throw e;
        }
    }
}

