/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.parser;

import org.apache.james.mime4j.parser.Field;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.james.mime4j.util.ContentUtil;

class RawField
implements Field {
    private final ByteSequence raw;
    private int colonIdx;
    private String name;
    private String body;

    public RawField(ByteSequence raw, int colonIdx) {
        this.raw = raw;
        this.colonIdx = colonIdx;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.parseName();
        }
        return this.name;
    }

    @Override
    public String getBody() {
        if (this.body == null) {
            this.body = this.parseBody();
        }
        return this.body;
    }

    @Override
    public ByteSequence getRaw() {
        return this.raw;
    }

    public String toString() {
        return this.getName() + ':' + this.getBody();
    }

    private String parseName() {
        return ContentUtil.decode(this.raw, 0, this.colonIdx);
    }

    private String parseBody() {
        int offset = this.colonIdx + 1;
        int length = this.raw.length() - offset;
        return ContentUtil.decode(this.raw, offset, length);
    }
}

