/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.annotation;

import java.util.EnumSet;

public enum ClientTransactionPolicy {
    MANDATORY(false, true, true),
    SUPPORTS(false, false, true),
    NOT_SUPPORTED(false, false, false),
    NEVER(true, false, false);

    private final boolean failIfTransactionPresent;
    private final boolean failIfTransactionAbsent;
    private final boolean propagate;
    private static final int fullSize;

    private ClientTransactionPolicy(boolean failIfTransactionPresent, boolean failIfTransactionAbsent, boolean propagate) {
        this.failIfTransactionPresent = failIfTransactionPresent;
        this.failIfTransactionAbsent = failIfTransactionAbsent;
        this.propagate = propagate;
    }

    public boolean failIfTransactionPresent() {
        return this.failIfTransactionPresent;
    }

    public boolean failIfTransactionAbsent() {
        return this.failIfTransactionAbsent;
    }

    public boolean propagate() {
        return this.propagate;
    }

    public static boolean isFull(EnumSet<ClientTransactionPolicy> set) {
        return set != null && set.size() == fullSize;
    }

    public boolean in(ClientTransactionPolicy v1) {
        return this == v1;
    }

    public boolean in(ClientTransactionPolicy v1, ClientTransactionPolicy v2) {
        return this == v1 || this == v2;
    }

    public boolean in(ClientTransactionPolicy v1, ClientTransactionPolicy v2, ClientTransactionPolicy v3) {
        return this == v1 || this == v2 || this == v3;
    }

    public boolean in(ClientTransactionPolicy ... values) {
        if (values != null) {
            for (ClientTransactionPolicy value : values) {
                if (this != value) continue;
                return true;
            }
        }
        return false;
    }

    static {
        fullSize = ClientTransactionPolicy.values().length;
    }
}

