/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util.concurrent;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.executors.NonBlockingResource;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.concurrent.CacheBackpressureFullException;

public class BlockingRejectedExecutionHandler
implements RejectedExecutionHandler {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final boolean trace = log.isTraceEnabled();
    private static final BlockingRejectedExecutionHandler INSTANCE = new BlockingRejectedExecutionHandler();

    private BlockingRejectedExecutionHandler() {
    }

    public static BlockingRejectedExecutionHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        this.rejectedExecution(r, (ExecutorService)executor);
    }

    public void rejectedExecution(Runnable r, ExecutorService executor) {
        if (executor.isShutdown()) {
            throw new IllegalLifecycleStateException();
        }
        if (Thread.currentThread().getThreadGroup() instanceof NonBlockingResource) {
            if (trace) {
                log.tracef("Task %s was rejected from %s when submitted from non blocking thread", r, executor);
            }
            throw new CacheBackpressureFullException();
        }
        r.run();
    }
}

