/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.verifier;

import java.util.Locale;

public class Cal10nError {
    final ErrorType errorType;
    final String key;
    final Locale locale;
    final String enumClassName;
    final String baseName;

    Cal10nError(ErrorType errorType, String key, String enumClassName, Locale locale, String baseName) {
        this.errorType = errorType;
        this.key = key;
        this.enumClassName = enumClassName;
        this.locale = locale;
        this.baseName = baseName;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public String getKey() {
        return this.key;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String toString() {
        switch (this.errorType) {
            case MISSING_BN_ANNOTATION: {
                return "Missing @BaseName annotation in enum type [" + this.enumClassName + "]";
            }
            case MISSING_LOCALE_DATA_ANNOTATION: {
                return "Missing or empty @LocaleData annotation in enum type [" + this.enumClassName + "]. See " + "http://cal10n.qos.ch/codes.html#missingLDAnnotation";
            }
            case FAILED_TO_FIND_RB: {
                return "Failed to locate resource bundle [" + this.baseName + "] for locale [" + this.locale + "] for enum type [" + this.enumClassName + "]";
            }
            case EMPTY_RB: {
                return "Empty resource bundle named [" + this.baseName + "] for locale [" + this.locale + "]";
            }
            case EMPTY_ENUM: {
                return "Empty enum type [" + this.enumClassName + "]";
            }
            case ABSENT_IN_ENUM: {
                return "Key [" + this.key + "] present in resource bundle named [" + this.baseName + "] for locale [" + this.locale + "] but absent in enum type [" + this.enumClassName + "]";
            }
            case ABSENT_IN_RB: {
                return "Key [" + this.key + "] present in enum type [" + this.enumClassName + "] but absent in resource bundle named [" + this.baseName + "] for locale [" + this.locale + "]";
            }
        }
        throw new IllegalStateException("Impossible to reach here");
    }

    static enum ErrorType {
        MISSING_BN_ANNOTATION,
        MISSING_LOCALE_DATA_ANNOTATION,
        FAILED_TO_FIND_RB,
        EMPTY_RB,
        EMPTY_ENUM,
        ABSENT_IN_RB,
        ABSENT_IN_ENUM;

    }
}

