/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.remoting.EndpointConfigFactory;
import org.jboss.as.remoting.EndpointService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.server.ServerService;
import org.jboss.as.server.Services;
import org.jboss.as.server.mgmt.ManagementWorkerService;
import org.jboss.as.server.mgmt.domain.HostControllerConnectionService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.xnio.OptionMap;

public class DomainServerCommunicationServices
implements ServiceActivator,
Serializable {
    private static final OptionMap DEFAULTS = OptionMap.EMPTY;
    private static final long serialVersionUID = 1593964083902839384L;
    private static volatile int initialOperationID;
    private final ModelNode endpointConfig;
    private final URI managementURI;
    private final String serverName;
    private final String serverProcessName;
    private final String authKey;
    private final Supplier<SSLContext> sslContextSupplier;
    private final boolean managementSubsystemEndpoint;

    DomainServerCommunicationServices(ModelNode endpointConfig, URI managementURI, String serverName, String serverProcessName, String authKey, boolean managementSubsystemEndpoint, Supplier<SSLContext> sslContextSupplier) {
        this.endpointConfig = endpointConfig;
        this.managementURI = managementURI;
        this.serverName = serverName;
        this.serverProcessName = serverProcessName;
        this.authKey = authKey;
        this.managementSubsystemEndpoint = managementSubsystemEndpoint;
        this.sslContextSupplier = sslContextSupplier;
    }

    static void updateOperationID(int operationID) {
        initialOperationID = operationID;
    }

    public void activate(ServiceActivatorContext serviceActivatorContext) throws ServiceRegistryException {
        ServiceTarget serviceTarget = serviceActivatorContext.getServiceTarget();
        ServiceName endpointName = this.managementSubsystemEndpoint ? RemotingServices.SUBSYSTEM_ENDPOINT : ManagementRemotingServices.MANAGEMENT_ENDPOINT;
        EndpointService.EndpointType endpointType = this.managementSubsystemEndpoint ? EndpointService.EndpointType.SUBSYSTEM : EndpointService.EndpointType.MANAGEMENT;
        try {
            ManagementWorkerService.installService(serviceTarget);
            OptionMap options = EndpointConfigFactory.create((ExpressionResolver)ExpressionResolver.SIMPLE, (ModelNode)this.endpointConfig, (OptionMap)DEFAULTS);
            ManagementRemotingServices.installRemotingManagementEndpoint((ServiceTarget)serviceTarget, (ServiceName)endpointName, (String)WildFlySecurityManager.getPropertyPrivileged((String)"jboss.node.name", null), (EndpointService.EndpointType)endpointType, (OptionMap)options);
            ServiceBuilder sb = serviceTarget.addService(HostControllerConnectionService.SERVICE_NAME);
            Supplier<ExecutorService> esSupplier = Services.requireServerExecutor(sb);
            Supplier sesSupplier = sb.requires(ServerService.JBOSS_SERVER_SCHEDULED_EXECUTOR);
            Supplier eSupplier = sb.requires(endpointName);
            Supplier cpsnSupplier = sb.requires(ControlledProcessStateService.INTERNAL_SERVICE_NAME);
            sb.setInstance((Service)new HostControllerConnectionService(this.managementURI, this.serverName, this.serverProcessName, this.authKey, initialOperationID, this.managementSubsystemEndpoint, this.sslContextSupplier, esSupplier, sesSupplier, eSupplier, cpsnSupplier));
            sb.install();
        }
        catch (OperationFailedException e) {
            throw new ServiceRegistryException((Throwable)e);
        }
    }

    public static ServiceActivator create(ModelNode endpointConfig, URI managementURI, String serverName, String serverProcessName, String authKey, boolean managementSubsystemEndpoint, Supplier<SSLContext> sslContextSupplier) {
        return new DomainServerCommunicationServices(endpointConfig, managementURI, serverName, serverProcessName, authKey, managementSubsystemEndpoint, sslContextSupplier);
    }

    public static interface OperationIDUpdater {
        public void updateOperationID(int var1);
    }
}

