/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import java.io.IOException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.apache.xerces.util.URI;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.readers.CatalogReader;
import org.apache.xml.resolver.readers.SAXCatalogReader;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class XMLCatalogResolver
implements XMLEntityResolver,
EntityResolver2,
LSResourceResolver {
    private CatalogManager fResolverCatalogManager = null;
    private Catalog fCatalog = null;
    private String[] fCatalogsList = null;
    private boolean fCatalogsChanged = true;
    private boolean fPreferPublic = true;
    private boolean fUseLiteralSystemId = true;

    public XMLCatalogResolver() {
        this(null, true);
    }

    public XMLCatalogResolver(String[] catalogs) {
        this(catalogs, true);
    }

    public XMLCatalogResolver(String[] catalogs, boolean preferPublic) {
        this.init(catalogs, preferPublic);
    }

    public final synchronized String[] getCatalogList() {
        return this.fCatalogsList != null ? (String[])this.fCatalogsList.clone() : null;
    }

    public final synchronized void setCatalogList(String[] catalogs) {
        this.fCatalogsChanged = true;
        this.fCatalogsList = catalogs != null ? (String[])catalogs.clone() : null;
    }

    public final synchronized void clear() {
        this.fCatalog = null;
    }

    public final boolean getPreferPublic() {
        return this.fPreferPublic;
    }

    public final void setPreferPublic(boolean preferPublic) {
        this.fPreferPublic = preferPublic;
        this.fResolverCatalogManager.setPreferPublic(preferPublic);
    }

    public final boolean getUseLiteralSystemId() {
        return this.fUseLiteralSystemId;
    }

    public final void setUseLiteralSystemId(boolean useLiteralSystemId) {
        this.fUseLiteralSystemId = useLiteralSystemId;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String resolvedId = null;
        if (publicId != null && systemId != null) {
            resolvedId = this.resolvePublic(publicId, systemId);
        } else if (systemId != null) {
            resolvedId = this.resolveSystem(systemId);
        }
        if (resolvedId != null) {
            InputSource source = new InputSource(resolvedId);
            source.setPublicId(publicId);
            return source;
        }
        return null;
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        String resolvedId = null;
        if (!this.getUseLiteralSystemId() && baseURI != null) {
            try {
                URI uri = new URI(new URI(baseURI), systemId);
                systemId = uri.toString();
            }
            catch (URI.MalformedURIException uri) {
                // empty catch block
            }
        }
        if (publicId != null && systemId != null) {
            resolvedId = this.resolvePublic(publicId, systemId);
        } else if (systemId != null) {
            resolvedId = this.resolveSystem(systemId);
        }
        if (resolvedId != null) {
            InputSource source = new InputSource(resolvedId);
            source.setPublicId(publicId);
            return source;
        }
        return null;
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        return null;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        String resolvedId = null;
        try {
            if (namespaceURI != null) {
                resolvedId = this.resolveURI(namespaceURI);
            }
            if (!this.getUseLiteralSystemId() && baseURI != null) {
                try {
                    URI uri = new URI(new URI(baseURI), systemId);
                    systemId = uri.toString();
                }
                catch (URI.MalformedURIException malformedURIException) {
                    // empty catch block
                }
            }
            if (resolvedId == null) {
                if (publicId != null && systemId != null) {
                    resolvedId = this.resolvePublic(publicId, systemId);
                } else if (systemId != null) {
                    resolvedId = this.resolveSystem(systemId);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (resolvedId != null) {
            return new DOMInputImpl(publicId, resolvedId, baseURI);
        }
        return null;
    }

    @Override
    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
        String resolvedId = this.resolveIdentifier(resourceIdentifier);
        if (resolvedId != null) {
            return new XMLInputSource(resourceIdentifier.getPublicId(), resolvedId, resourceIdentifier.getBaseSystemId());
        }
        return null;
    }

    public String resolveIdentifier(XMLResourceIdentifier resourceIdentifier) throws IOException, XNIException {
        String resolvedId = null;
        String namespace = resourceIdentifier.getNamespace();
        if (namespace != null) {
            resolvedId = this.resolveURI(namespace);
        }
        if (resolvedId == null) {
            String systemId;
            String publicId = resourceIdentifier.getPublicId();
            String string = systemId = this.getUseLiteralSystemId() ? resourceIdentifier.getLiteralSystemId() : resourceIdentifier.getExpandedSystemId();
            if (publicId != null && systemId != null) {
                resolvedId = this.resolvePublic(publicId, systemId);
            } else if (systemId != null) {
                resolvedId = this.resolveSystem(systemId);
            }
        }
        return resolvedId;
    }

    public final synchronized String resolveSystem(String systemId) throws IOException {
        if (this.fCatalogsChanged) {
            this.parseCatalogs();
            this.fCatalogsChanged = false;
        }
        return this.fCatalog != null ? this.fCatalog.resolveSystem(systemId) : null;
    }

    public final synchronized String resolvePublic(String publicId, String systemId) throws IOException {
        if (this.fCatalogsChanged) {
            this.parseCatalogs();
            this.fCatalogsChanged = false;
        }
        return this.fCatalog != null ? this.fCatalog.resolvePublic(publicId, systemId) : null;
    }

    public final synchronized String resolveURI(String uri) throws IOException {
        if (this.fCatalogsChanged) {
            this.parseCatalogs();
            this.fCatalogsChanged = false;
        }
        return this.fCatalog != null ? this.fCatalog.resolveURI(uri) : null;
    }

    private void init(String[] catalogs, boolean preferPublic) {
        this.fCatalogsList = catalogs != null ? (String[])catalogs.clone() : null;
        this.fPreferPublic = preferPublic;
        this.fResolverCatalogManager = new CatalogManager();
        this.fResolverCatalogManager.setAllowOasisXMLCatalogPI(false);
        this.fResolverCatalogManager.setCatalogClassName("org.apache.xml.resolver.Catalog");
        this.fResolverCatalogManager.setCatalogFiles("");
        this.fResolverCatalogManager.setIgnoreMissingProperties(true);
        this.fResolverCatalogManager.setPreferPublic(this.fPreferPublic);
        this.fResolverCatalogManager.setRelativeCatalogs(false);
        this.fResolverCatalogManager.setUseStaticCatalog(false);
        this.fResolverCatalogManager.setVerbosity(0);
    }

    private void parseCatalogs() throws IOException {
        if (this.fCatalogsList != null) {
            this.fCatalog = new Catalog(this.fResolverCatalogManager);
            this.attachReaderToCatalog(this.fCatalog);
            for (int i = 0; i < this.fCatalogsList.length; ++i) {
                String catalog = this.fCatalogsList[i];
                if (catalog == null || catalog.length() <= 0) continue;
                this.fCatalog.parseCatalog(catalog);
            }
        } else {
            this.fCatalog = null;
        }
    }

    private void attachReaderToCatalog(Catalog catalog) {
        SAXParserFactoryImpl spf = new SAXParserFactoryImpl();
        spf.setNamespaceAware(true);
        spf.setValidating(false);
        SAXCatalogReader saxReader = new SAXCatalogReader((SAXParserFactory)spf);
        saxReader.setCatalogParser("urn:oasis:names:tc:entity:xmlns:xml:catalog", "catalog", "org.apache.xml.resolver.readers.OASISXMLCatalogReader");
        catalog.addReader("application/xml", (CatalogReader)saxReader);
    }
}

