/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.io.ByteArrayOutputStream;
import org.jboss.security.PicketBoxMessages;

public class Base64Utils {
    private static final String base64Str = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz./";
    private static final char[] base64Table = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz./".toCharArray();
    public static final String BASE64_ENCODING = "BASE64";
    public static final String BASE16_ENCODING = "HEX";
    public static final char PAD = '_';
    public static final String REGEX = "^_{0,2}[0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz./]*$";

    public static String tob64(byte[] buffer) {
        return Base64Utils.tob64(buffer, false);
    }

    public static String tob64(byte[] buffer, boolean usePadding) {
        int c;
        int len = buffer.length;
        int pos = len % 3;
        int b0 = 0;
        byte b1 = 0;
        byte b2 = 0;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        if (usePadding) {
            i = pos;
            while (i != 0) {
                sb.append('_');
                i = (i + 1) % 3;
            }
            i = 0;
        }
        switch (pos) {
            case 2: {
                b1 = buffer[i++];
                c = (b0 & 3) << 4 | (b1 & 0xF0) >>> 4;
                sb.append(base64Table[c]);
            }
            case 1: {
                b2 = buffer[i++];
                c = (b1 & 0xF) << 2 | (b2 & 0xC0) >>> 6;
                sb.append(base64Table[c]);
                c = b2 & 0x3F;
                sb.append(base64Table[c]);
            }
        }
        while (pos < len) {
            b0 = buffer[pos++];
            b1 = buffer[pos++];
            b2 = buffer[pos++];
            c = (b0 & 0xFC) >>> 2;
            sb.append(base64Table[c]);
            c = (b0 & 3) << 4 | (b1 & 0xF0) >>> 4;
            sb.append(base64Table[c]);
            c = (b1 & 0xF) << 2 | (b2 & 0xC0) >>> 6;
            sb.append(base64Table[c]);
            c = b2 & 0x3F;
            sb.append(base64Table[c]);
        }
        return sb.toString();
    }

    public static byte[] fromb64(String str) throws NumberFormatException {
        if (str.length() == 0) {
            return new byte[0];
        }
        while (str.length() % 4 != 0) {
            str = '_' + str;
        }
        if (!str.matches(REGEX)) {
            throw PicketBoxMessages.MESSAGES.invalidBase64String(str);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(str.length() * 3 / 4);
        int i = 0;
        int n = str.length();
        while (i < n) {
            int pos0 = base64Str.indexOf(str.charAt(i++));
            int pos1 = base64Str.indexOf(str.charAt(i++));
            int pos2 = base64Str.indexOf(str.charAt(i++));
            int pos3 = base64Str.indexOf(str.charAt(i++));
            if (pos0 > -1) {
                bos.write((pos1 & 0x30) >>> 4 | pos0 << 2);
            }
            if (pos1 > -1) {
                bos.write((pos2 & 0x3C) >>> 2 | (pos1 & 0xF) << 4);
            }
            bos.write((pos2 & 3) << 6 | pos3);
        }
        return bos.toByteArray();
    }
}

