/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.lms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.bouncycastle.pqc.crypto.lms.Composer;
import org.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import org.bouncycastle.util.Encodable;
import org.bouncycastle.util.io.Streams;

class LMOtsSignature
implements Encodable {
    private final LMOtsParameters type;
    private final byte[] C;
    private final byte[] y;

    public LMOtsSignature(LMOtsParameters type, byte[] c, byte[] y) {
        this.type = type;
        this.C = c;
        this.y = y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LMOtsSignature getInstance(Object src) throws IOException {
        if (src instanceof LMOtsSignature) {
            return (LMOtsSignature)src;
        }
        if (src instanceof DataInputStream) {
            LMOtsParameters type = LMOtsParameters.getParametersForType(((DataInputStream)src).readInt());
            byte[] C = new byte[type.getN()];
            ((DataInputStream)src).readFully(C);
            byte[] sig = new byte[type.getP() * type.getN()];
            ((DataInputStream)src).readFully(sig);
            return new LMOtsSignature(type, C, sig);
        }
        if (src instanceof byte[]) {
            InputStream in = null;
            try {
                in = new DataInputStream(new ByteArrayInputStream((byte[])src));
                LMOtsSignature lMOtsSignature = LMOtsSignature.getInstance(in);
                return lMOtsSignature;
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        if (src instanceof InputStream) {
            return LMOtsSignature.getInstance(Streams.readAll((InputStream)src));
        }
        throw new IllegalArgumentException("cannot parse " + src);
    }

    public LMOtsParameters getType() {
        return this.type;
    }

    public byte[] getC() {
        return this.C;
    }

    public byte[] getY() {
        return this.y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LMOtsSignature that = (LMOtsSignature)o;
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (!Arrays.equals(this.C, that.C)) {
            return false;
        }
        return Arrays.equals(this.y, that.y);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.C);
        result = 31 * result + Arrays.hashCode(this.y);
        return result;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return Composer.compose().u32str(this.type.getType()).bytes(this.C).bytes(this.y).build();
    }
}

