/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.ActionElement;
import antlr.ActionTransInfo;
import antlr.Alternative;
import antlr.AlternativeBlock;
import antlr.AlternativeElement;
import antlr.BlockEndElement;
import antlr.CharLiteralElement;
import antlr.CharRangeElement;
import antlr.CharStreamException;
import antlr.CodeGenerator;
import antlr.ExceptionHandler;
import antlr.ExceptionSpec;
import antlr.Grammar;
import antlr.GrammarAtom;
import antlr.GrammarSymbol;
import antlr.LexerGrammar;
import antlr.Lookahead;
import antlr.MakeGrammar;
import antlr.OneOrMoreBlock;
import antlr.ParserGrammar;
import antlr.PythonBlockFinishingInfo;
import antlr.PythonCharFormatter;
import antlr.RecognitionException;
import antlr.RuleBlock;
import antlr.RuleRefElement;
import antlr.RuleSymbol;
import antlr.StringLiteralElement;
import antlr.StringLiteralSymbol;
import antlr.StringUtils;
import antlr.SynPredBlock;
import antlr.Token;
import antlr.TokenManager;
import antlr.TokenRangeElement;
import antlr.TokenRefElement;
import antlr.TokenStreamException;
import antlr.TokenSymbol;
import antlr.Tool;
import antlr.TreeElement;
import antlr.TreeWalkerGrammar;
import antlr.Utils;
import antlr.WildcardElement;
import antlr.ZeroOrMoreBlock;
import antlr.actions.python.ActionLexer;
import antlr.actions.python.CodeLexer;
import antlr.collections.impl.BitSet;
import antlr.collections.impl.Vector;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class PythonCodeGenerator
extends CodeGenerator {
    protected int syntacticPredLevel = 0;
    protected boolean genAST = false;
    protected boolean saveText = false;
    String labeledElementType;
    String labeledElementASTType;
    String labeledElementInit;
    String commonExtraArgs;
    String commonExtraParams;
    String commonLocalVars;
    String lt1Value;
    String exceptionThrown;
    String throwNoViable;
    public static final String initHeaderAction = "__init__";
    public static final String mainHeaderAction = "__main__";
    String lexerClassName;
    String parserClassName;
    String treeWalkerClassName;
    RuleBlock currentRule;
    String currentASTResult;
    Hashtable treeVariableMap = new Hashtable();
    Hashtable declaredASTVariables = new Hashtable();
    int astVarNumber = 1;
    protected static final String NONUNIQUE = new String();
    public static final int caseSizeThreshold = 127;
    private Vector semPreds;

    @Override
    protected void printTabs() {
        for (int i = 0; i < this.tabs; ++i) {
            this.currentOutput.print("    ");
        }
    }

    public PythonCodeGenerator() {
        this.charFormatter = new PythonCharFormatter();
        this.DEBUG_CODE_GENERATOR = true;
    }

    protected int addSemPred(String predicate) {
        this.semPreds.appendElement(predicate);
        return this.semPreds.size() - 1;
    }

    public void exitIfError() {
        if (this.antlrTool.hasError()) {
            this.antlrTool.fatalError("Exiting due to errors.");
        }
    }

    protected void checkCurrentOutputStream() {
        try {
            if (this.currentOutput == null) {
                throw new NullPointerException();
            }
        }
        catch (Exception e) {
            Utils.error("current output is not set");
        }
    }

    @Override
    protected String extractIdOfAction(String s, int line, int column) {
        s = this.removeAssignmentFromDeclaration(s);
        s = s.trim();
        return s;
    }

    @Override
    protected String extractTypeOfAction(String s, int line, int column) {
        return "";
    }

    protected void flushTokens() {
        try {
            boolean generated = false;
            this.checkCurrentOutputStream();
            this.println("");
            this.println("### import antlr.Token ");
            this.println("from antlr import Token");
            this.println("### >>>The Known Token Types <<<");
            PrintWriter cout = this.currentOutput;
            Enumeration tmIter = this.behavior.tokenManagers.elements();
            while (tmIter.hasMoreElements()) {
                TokenManager tm = (TokenManager)tmIter.nextElement();
                if (!tm.isReadOnly()) {
                    if (!generated) {
                        this.genTokenTypes(tm);
                        generated = true;
                    }
                    this.currentOutput = cout;
                    this.genTokenInterchange(tm);
                    this.currentOutput = cout;
                }
                this.exitIfError();
            }
        }
        catch (Exception e) {
            this.exitIfError();
        }
        this.checkCurrentOutputStream();
        this.println("");
    }

    @Override
    public void gen() {
        try {
            Enumeration grammarIter = this.behavior.grammars.elements();
            while (grammarIter.hasMoreElements()) {
                Grammar g = (Grammar)grammarIter.nextElement();
                g.setGrammarAnalyzer(this.analyzer);
                g.setCodeGenerator(this);
                this.analyzer.setGrammar(g);
                this.setupGrammarParameters(g);
                g.generate();
                this.exitIfError();
            }
        }
        catch (IOException e) {
            this.antlrTool.reportException(e, null);
        }
    }

    @Override
    public void gen(ActionElement action) {
        if (action.isSemPred) {
            this.genSemPred(action.actionText, action.line);
        } else {
            if (this.grammar.hasSyntacticPredicate) {
                this.println("if not self.inputState.guessing:");
                ++this.tabs;
            }
            ActionTransInfo tInfo = new ActionTransInfo();
            String actionStr = this.processActionForSpecialSymbols(action.actionText, action.getLine(), this.currentRule, tInfo);
            if (tInfo.refRuleRoot != null) {
                this.println(tInfo.refRuleRoot + " = currentAST.root");
            }
            this.printAction(actionStr);
            if (tInfo.assignToRoot) {
                this.println("currentAST.root = " + tInfo.refRuleRoot + "");
                this.println("if (" + tInfo.refRuleRoot + " != None) and (" + tInfo.refRuleRoot + ".getFirstChild() != None):");
                ++this.tabs;
                this.println("currentAST.child = " + tInfo.refRuleRoot + ".getFirstChild()");
                --this.tabs;
                this.println("else:");
                ++this.tabs;
                this.println("currentAST.child = " + tInfo.refRuleRoot);
                --this.tabs;
                this.println("currentAST.advanceChildToEnd()");
            }
            if (this.grammar.hasSyntacticPredicate) {
                --this.tabs;
            }
        }
    }

    @Override
    public void gen(AlternativeBlock blk) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen(" + blk + ")");
        }
        this.genBlockPreamble(blk);
        this.genBlockInitAction(blk);
        String saveCurrentASTResult = this.currentASTResult;
        if (blk.getLabel() != null) {
            this.currentASTResult = blk.getLabel();
        }
        boolean ok = this.grammar.theLLkAnalyzer.deterministic(blk);
        int _tabs_ = this.tabs;
        PythonBlockFinishingInfo howToFinish = this.genCommonBlock(blk, true);
        this.genBlockFinish(howToFinish, this.throwNoViable);
        this.tabs = _tabs_;
        this.currentASTResult = saveCurrentASTResult;
    }

    @Override
    public void gen(BlockEndElement end) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRuleEnd(" + end + ")");
        }
    }

    @Override
    public void gen(CharLiteralElement atom) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genChar(" + atom + ")");
        }
        if (atom.getLabel() != null) {
            this.println(atom.getLabel() + " = " + this.lt1Value);
        }
        boolean oldsaveText = this.saveText;
        this.saveText = this.saveText && atom.getAutoGenType() == 1;
        this.genMatch(atom);
        this.saveText = oldsaveText;
    }

    String toString(boolean v) {
        String s = v ? "True" : "False";
        return s;
    }

    @Override
    public void gen(CharRangeElement r) {
        boolean flag;
        if (r.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(r.getLabel() + " = " + this.lt1Value);
        }
        boolean bl = flag = this.grammar instanceof LexerGrammar && (!this.saveText || r.getAutoGenType() == 3);
        if (flag) {
            this.println("_saveIndex = self.text.length()");
        }
        this.println("self.matchRange(u" + r.beginText + ", u" + r.endText + ")");
        if (flag) {
            this.println("self.text.setLength(_saveIndex)");
        }
    }

    @Override
    public void gen(LexerGrammar g) throws IOException {
        GrammarSymbol sym;
        Enumeration ids;
        String p;
        if (g.debuggingOutput) {
            this.semPreds = new Vector();
        }
        this.setGrammar(g);
        if (!(this.grammar instanceof LexerGrammar)) {
            this.antlrTool.panic("Internal error generating lexer");
        }
        this.setupOutput(this.grammar.getClassName());
        this.genAST = false;
        this.saveText = true;
        this.tabs = 0;
        this.genHeader();
        this.println("### import antlr and other modules ..");
        this.println("import sys");
        this.println("import antlr");
        this.println("");
        this.println("version = sys.version.split()[0]");
        this.println("if version < '2.2.1':");
        ++this.tabs;
        this.println("False = 0");
        --this.tabs;
        this.println("if version < '2.3':");
        ++this.tabs;
        this.println("True = not False");
        --this.tabs;
        this.println("### header action >>> ");
        this.printActionCode(this.behavior.getHeaderAction(""), 0);
        this.println("### header action <<< ");
        this.println("### preamble action >>> ");
        this.printActionCode(this.grammar.preambleAction.getText(), 0);
        this.println("### preamble action <<< ");
        String sup = null;
        sup = this.grammar.superClass != null ? this.grammar.superClass : "antlr." + this.grammar.getSuperClass();
        String prefix = "";
        Token tprefix = (Token)this.grammar.options.get("classHeaderPrefix");
        if (tprefix != null && (p = StringUtils.stripFrontBack(tprefix.getText(), "\"", "\"")) != null) {
            prefix = p;
        }
        this.println("### >>>The Literals<<<");
        this.println("literals = {}");
        Enumeration keys = this.grammar.tokenManager.getTokenSymbolKeys();
        while (keys.hasMoreElements()) {
            TokenSymbol sym2;
            String key = (String)keys.nextElement();
            if (key.charAt(0) != '\"' || !((sym2 = this.grammar.tokenManager.getTokenSymbol(key)) instanceof StringLiteralSymbol)) continue;
            StringLiteralSymbol s = (StringLiteralSymbol)sym2;
            this.println("literals[u" + s.getId() + "] = " + s.getTokenType());
        }
        this.println("");
        this.flushTokens();
        this.genJavadocComment(this.grammar);
        this.println("class " + this.lexerClassName + "(" + sup + ") :");
        ++this.tabs;
        this.printGrammarAction(this.grammar);
        this.println("def __init__(self, *argv, **kwargs) :");
        ++this.tabs;
        this.println(sup + ".__init__(self, *argv, **kwargs)");
        this.println("self.caseSensitiveLiterals = " + this.toString(g.caseSensitiveLiterals));
        this.println("self.setCaseSensitive(" + this.toString(g.caseSensitive) + ")");
        this.println("self.literals = literals");
        if (this.grammar.debuggingOutput) {
            this.println("ruleNames[] = [");
            ids = this.grammar.rules.elements();
            boolean ruleNum = false;
            ++this.tabs;
            while (ids.hasMoreElements()) {
                sym = (GrammarSymbol)ids.nextElement();
                if (!(sym instanceof RuleSymbol)) continue;
                this.println("\"" + ((RuleSymbol)sym).getId() + "\",");
            }
            --this.tabs;
            this.println("]");
        }
        this.genHeaderInit(this.grammar);
        --this.tabs;
        this.genNextToken();
        this.println("");
        ids = this.grammar.rules.elements();
        int ruleNum = 0;
        while (ids.hasMoreElements()) {
            sym = (RuleSymbol)ids.nextElement();
            if (!sym.getId().equals("mnextToken")) {
                this.genRule((RuleSymbol)sym, false, ruleNum++);
            }
            this.exitIfError();
        }
        if (this.grammar.debuggingOutput) {
            this.genSemPredMap();
        }
        this.genBitsets(this.bitsetsUsed, ((LexerGrammar)this.grammar).charVocabulary.size());
        this.println("");
        this.genHeaderMain(this.grammar);
        this.currentOutput.close();
        this.currentOutput = null;
    }

    protected void genHeaderMain(Grammar grammar) {
        String h = grammar.getClassName() + "." + mainHeaderAction;
        String s = this.behavior.getHeaderAction(h);
        if (PythonCodeGenerator.isEmpty(s)) {
            s = this.behavior.getHeaderAction(mainHeaderAction);
        }
        if (PythonCodeGenerator.isEmpty(s)) {
            if (grammar instanceof LexerGrammar) {
                int _tabs = this.tabs;
                this.tabs = 0;
                this.println("### __main__ header action >>> ");
                this.genLexerTest();
                this.tabs = 0;
                this.println("### __main__ header action <<< ");
                this.tabs = _tabs;
            }
        } else {
            int _tabs = this.tabs;
            this.tabs = 0;
            this.println("");
            this.println("### __main__ header action >>> ");
            this.printMainFunc(s);
            this.tabs = 0;
            this.println("### __main__ header action <<< ");
            this.tabs = _tabs;
        }
    }

    protected void genHeaderInit(Grammar grammar) {
        String h = grammar.getClassName() + "." + initHeaderAction;
        String s = this.behavior.getHeaderAction(h);
        if (PythonCodeGenerator.isEmpty(s)) {
            s = this.behavior.getHeaderAction(initHeaderAction);
        }
        if (!PythonCodeGenerator.isEmpty(s)) {
            int _tabs = this.tabs;
            this.println("### __init__ header action >>> ");
            this.printActionCode(s, 0);
            this.tabs = _tabs;
            this.println("### __init__ header action <<< ");
        }
    }

    protected void printMainFunc(String s) {
        int _tabs = this.tabs;
        this.tabs = 0;
        this.println("if __name__ == '__main__':");
        ++this.tabs;
        this.printActionCode(s, 0);
        --this.tabs;
        this.tabs = _tabs;
    }

    @Override
    public void gen(OneOrMoreBlock blk) {
        int _tabs_ = this.tabs;
        this.genBlockPreamble(blk);
        String cnt = blk.getLabel() != null ? "_cnt_" + blk.getLabel() : "_cnt" + blk.ID;
        this.println("" + cnt + "= 0");
        this.println("while True:");
        ++this.tabs;
        _tabs_ = this.tabs;
        this.genBlockInitAction(blk);
        String saveCurrentASTResult = this.currentASTResult;
        if (blk.getLabel() != null) {
            this.currentASTResult = blk.getLabel();
        }
        boolean ok = this.grammar.theLLkAnalyzer.deterministic(blk);
        boolean generateNonGreedyExitPath = false;
        int nonGreedyExitDepth = this.grammar.maxk;
        if (!blk.greedy && blk.exitLookaheadDepth <= this.grammar.maxk && blk.exitCache[blk.exitLookaheadDepth].containsEpsilon()) {
            generateNonGreedyExitPath = true;
            nonGreedyExitDepth = blk.exitLookaheadDepth;
        } else if (!blk.greedy && blk.exitLookaheadDepth == Integer.MAX_VALUE) {
            generateNonGreedyExitPath = true;
        }
        if (generateNonGreedyExitPath) {
            this.println("### nongreedy (...)+ loop; exit depth is " + blk.exitLookaheadDepth);
            String predictExit = this.getLookaheadTestExpression(blk.exitCache, nonGreedyExitDepth);
            this.println("### nongreedy exit test");
            this.println("if " + cnt + " >= 1 and " + predictExit + ":");
            ++this.tabs;
            this.println("break");
            --this.tabs;
        }
        int _tabs = this.tabs;
        PythonBlockFinishingInfo howToFinish = this.genCommonBlock(blk, false);
        this.genBlockFinish(howToFinish, "break");
        this.tabs = _tabs;
        this.tabs = _tabs_;
        this.println(cnt + " += 1");
        this.tabs = _tabs_;
        --this.tabs;
        this.println("if " + cnt + " < 1:");
        ++this.tabs;
        this.println(this.throwNoViable);
        --this.tabs;
        this.currentASTResult = saveCurrentASTResult;
    }

    @Override
    public void gen(ParserGrammar g) throws IOException {
        GrammarSymbol sym;
        int ruleNum;
        Enumeration ids;
        String p;
        if (g.debuggingOutput) {
            this.semPreds = new Vector();
        }
        this.setGrammar(g);
        if (!(this.grammar instanceof ParserGrammar)) {
            this.antlrTool.panic("Internal error generating parser");
        }
        this.setupOutput(this.grammar.getClassName());
        this.genAST = this.grammar.buildAST;
        this.tabs = 0;
        this.genHeader();
        this.println("### import antlr and other modules ..");
        this.println("import sys");
        this.println("import antlr");
        this.println("");
        this.println("version = sys.version.split()[0]");
        this.println("if version < '2.2.1':");
        ++this.tabs;
        this.println("False = 0");
        --this.tabs;
        this.println("if version < '2.3':");
        ++this.tabs;
        this.println("True = not False");
        --this.tabs;
        this.println("### header action >>> ");
        this.printActionCode(this.behavior.getHeaderAction(""), 0);
        this.println("### header action <<< ");
        this.println("### preamble action>>>");
        this.printActionCode(this.grammar.preambleAction.getText(), 0);
        this.println("### preamble action <<<");
        this.flushTokens();
        String sup = null;
        sup = this.grammar.superClass != null ? this.grammar.superClass : "antlr." + this.grammar.getSuperClass();
        this.genJavadocComment(this.grammar);
        String prefix = "";
        Token tprefix = (Token)this.grammar.options.get("classHeaderPrefix");
        if (tprefix != null && (p = StringUtils.stripFrontBack(tprefix.getText(), "\"", "\"")) != null) {
            prefix = p;
        }
        this.print("class " + this.parserClassName + "(" + sup);
        this.println("):");
        ++this.tabs;
        if (this.grammar.debuggingOutput) {
            this.println("_ruleNames = [");
            ids = this.grammar.rules.elements();
            ruleNum = 0;
            ++this.tabs;
            while (ids.hasMoreElements()) {
                sym = (GrammarSymbol)ids.nextElement();
                if (!(sym instanceof RuleSymbol)) continue;
                this.println("\"" + ((RuleSymbol)sym).getId() + "\",");
            }
            --this.tabs;
            this.println("]");
        }
        this.printGrammarAction(this.grammar);
        this.println("");
        this.println("def __init__(self, *args, **kwargs):");
        ++this.tabs;
        this.println(sup + ".__init__(self, *args, **kwargs)");
        this.println("self.tokenNames = _tokenNames");
        if (this.grammar.debuggingOutput) {
            this.println("self.ruleNames  = _ruleNames");
            this.println("self.semPredNames = _semPredNames");
            this.println("self.setupDebugging(self.tokenBuf)");
        }
        if (this.grammar.buildAST) {
            this.println("self.buildTokenTypeASTClassMap()");
            this.println("self.astFactory = antlr.ASTFactory(self.getTokenTypeToASTClassMap())");
            if (this.labeledElementASTType != null) {
                this.println("self.astFactory.setASTNodeClass(" + this.labeledElementASTType + ")");
            }
        }
        this.genHeaderInit(this.grammar);
        this.println("");
        ids = this.grammar.rules.elements();
        ruleNum = 0;
        while (ids.hasMoreElements()) {
            sym = (GrammarSymbol)ids.nextElement();
            if (sym instanceof RuleSymbol) {
                RuleSymbol rs = (RuleSymbol)sym;
                this.genRule(rs, rs.references.size() == 0, ruleNum++);
            }
            this.exitIfError();
        }
        if (this.grammar.buildAST) {
            this.genTokenASTNodeMap();
        }
        this.genTokenStrings();
        this.genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
        if (this.grammar.debuggingOutput) {
            this.genSemPredMap();
        }
        this.println("");
        this.tabs = 0;
        this.genHeaderMain(this.grammar);
        this.currentOutput.close();
        this.currentOutput = null;
    }

    @Override
    public void gen(RuleRefElement rr) {
        RuleSymbol rs;
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRR(" + rr + ")");
        }
        if ((rs = (RuleSymbol)this.grammar.getSymbol(rr.targetRule)) == null || !rs.isDefined()) {
            this.antlrTool.error("Rule '" + rr.targetRule + "' is not defined", this.grammar.getFilename(), rr.getLine(), rr.getColumn());
            return;
        }
        if (!(rs instanceof RuleSymbol)) {
            this.antlrTool.error("'" + rr.targetRule + "' does not name a grammar rule", this.grammar.getFilename(), rr.getLine(), rr.getColumn());
            return;
        }
        this.genErrorTryForElement(rr);
        if (this.grammar instanceof TreeWalkerGrammar && rr.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(rr.getLabel() + " = antlr.ifelse(_t == antlr.ASTNULL, None, " + this.lt1Value + ")");
        }
        if (this.grammar instanceof LexerGrammar && (!this.saveText || rr.getAutoGenType() == 3)) {
            this.println("_saveIndex = self.text.length()");
        }
        this.printTabs();
        if (rr.idAssign != null) {
            if (rs.block.returnAction == null) {
                this.antlrTool.warning("Rule '" + rr.targetRule + "' has no return type", this.grammar.getFilename(), rr.getLine(), rr.getColumn());
            }
            this._print(rr.idAssign + "=");
        } else if (!(this.grammar instanceof LexerGrammar) && this.syntacticPredLevel == 0 && rs.block.returnAction != null) {
            this.antlrTool.warning("Rule '" + rr.targetRule + "' returns a value", this.grammar.getFilename(), rr.getLine(), rr.getColumn());
        }
        this.GenRuleInvocation(rr);
        if (this.grammar instanceof LexerGrammar && (!this.saveText || rr.getAutoGenType() == 3)) {
            this.println("self.text.setLength(_saveIndex)");
        }
        if (this.syntacticPredLevel == 0) {
            boolean doNoGuessTest;
            boolean bl = doNoGuessTest = this.grammar.hasSyntacticPredicate && (this.grammar.buildAST && rr.getLabel() != null || this.genAST && rr.getAutoGenType() == 1);
            if (doNoGuessTest) {
                // empty if block
            }
            if (this.grammar.buildAST && rr.getLabel() != null) {
                this.println(rr.getLabel() + "_AST = self.returnAST");
            }
            if (this.genAST) {
                switch (rr.getAutoGenType()) {
                    case 1: {
                        this.println("self.addASTChild(currentAST, self.returnAST)");
                        break;
                    }
                    case 2: {
                        this.antlrTool.error("Internal: encountered ^ after rule reference");
                        break;
                    }
                }
            }
            if (this.grammar instanceof LexerGrammar && rr.getLabel() != null) {
                this.println(rr.getLabel() + " = self._returnToken");
            }
            if (doNoGuessTest) {
                // empty if block
            }
        }
        this.genErrorCatchForElement(rr);
    }

    @Override
    public void gen(StringLiteralElement atom) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genString(" + atom + ")");
        }
        if (atom.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(atom.getLabel() + " = " + this.lt1Value + "");
        }
        this.genElementAST(atom);
        boolean oldsaveText = this.saveText;
        this.saveText = this.saveText && atom.getAutoGenType() == 1;
        this.genMatch(atom);
        this.saveText = oldsaveText;
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _t.getNextSibling()");
        }
    }

    @Override
    public void gen(TokenRangeElement r) {
        this.genErrorTryForElement(r);
        if (r.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(r.getLabel() + " = " + this.lt1Value);
        }
        this.genElementAST(r);
        this.println("self.matchRange(u" + r.beginText + ", u" + r.endText + ")");
        this.genErrorCatchForElement(r);
    }

    @Override
    public void gen(TokenRefElement atom) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genTokenRef(" + atom + ")");
        }
        if (this.grammar instanceof LexerGrammar) {
            this.antlrTool.panic("Token reference found in lexer");
        }
        this.genErrorTryForElement(atom);
        if (atom.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(atom.getLabel() + " = " + this.lt1Value + "");
        }
        this.genElementAST(atom);
        this.genMatch(atom);
        this.genErrorCatchForElement(atom);
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _t.getNextSibling()");
        }
    }

    @Override
    public void gen(TreeElement t) {
        this.println("_t" + t.ID + " = _t");
        if (t.root.getLabel() != null) {
            this.println(t.root.getLabel() + " = antlr.ifelse(_t == antlr.ASTNULL, None, _t)");
        }
        if (t.root.getAutoGenType() == 3) {
            this.antlrTool.error("Suffixing a root node with '!' is not implemented", this.grammar.getFilename(), t.getLine(), t.getColumn());
            t.root.setAutoGenType(1);
        }
        if (t.root.getAutoGenType() == 2) {
            this.antlrTool.warning("Suffixing a root node with '^' is redundant; already a root", this.grammar.getFilename(), t.getLine(), t.getColumn());
            t.root.setAutoGenType(1);
        }
        this.genElementAST(t.root);
        if (this.grammar.buildAST) {
            this.println("_currentAST" + t.ID + " = currentAST.copy()");
            this.println("currentAST.root = currentAST.child");
            this.println("currentAST.child = None");
        }
        if (t.root instanceof WildcardElement) {
            this.println("if not _t: raise antlr.MismatchedTokenException()");
        } else {
            this.genMatch(t.root);
        }
        this.println("_t = _t.getFirstChild()");
        for (int i = 0; i < t.getAlternatives().size(); ++i) {
            Alternative a = t.getAlternativeAt(i);
            AlternativeElement e = a.head;
            while (e != null) {
                e.generate();
                e = e.next;
            }
        }
        if (this.grammar.buildAST) {
            this.println("currentAST = _currentAST" + t.ID + "");
        }
        this.println("_t = _t" + t.ID + "");
        this.println("_t = _t.getNextSibling()");
    }

    @Override
    public void gen(TreeWalkerGrammar g) throws IOException {
        String p;
        this.setGrammar(g);
        if (!(this.grammar instanceof TreeWalkerGrammar)) {
            this.antlrTool.panic("Internal error generating tree-walker");
        }
        this.setupOutput(this.grammar.getClassName());
        this.genAST = this.grammar.buildAST;
        this.tabs = 0;
        this.genHeader();
        this.println("### import antlr and other modules ..");
        this.println("import sys");
        this.println("import antlr");
        this.println("");
        this.println("version = sys.version.split()[0]");
        this.println("if version < '2.2.1':");
        ++this.tabs;
        this.println("False = 0");
        --this.tabs;
        this.println("if version < '2.3':");
        ++this.tabs;
        this.println("True = not False");
        --this.tabs;
        this.println("### header action >>> ");
        this.printActionCode(this.behavior.getHeaderAction(""), 0);
        this.println("### header action <<< ");
        this.flushTokens();
        this.println("### user code>>>");
        this.printActionCode(this.grammar.preambleAction.getText(), 0);
        this.println("### user code<<<");
        String sup = null;
        sup = this.grammar.superClass != null ? this.grammar.superClass : "antlr." + this.grammar.getSuperClass();
        this.println("");
        String prefix = "";
        Token tprefix = (Token)this.grammar.options.get("classHeaderPrefix");
        if (tprefix != null && (p = StringUtils.stripFrontBack(tprefix.getText(), "\"", "\"")) != null) {
            prefix = p;
        }
        this.genJavadocComment(this.grammar);
        this.println("class " + this.treeWalkerClassName + "(" + sup + "):");
        ++this.tabs;
        this.println("");
        this.println("# ctor ..");
        this.println("def __init__(self, *args, **kwargs):");
        ++this.tabs;
        this.println(sup + ".__init__(self, *args, **kwargs)");
        this.println("self.tokenNames = _tokenNames");
        this.genHeaderInit(this.grammar);
        --this.tabs;
        this.println("");
        this.printGrammarAction(this.grammar);
        Enumeration ids = this.grammar.rules.elements();
        int ruleNum = 0;
        String ruleNameInits = "";
        while (ids.hasMoreElements()) {
            GrammarSymbol sym = (GrammarSymbol)ids.nextElement();
            if (sym instanceof RuleSymbol) {
                RuleSymbol rs = (RuleSymbol)sym;
                this.genRule(rs, rs.references.size() == 0, ruleNum++);
            }
            this.exitIfError();
        }
        this.genTokenStrings();
        this.genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
        this.tabs = 0;
        this.genHeaderMain(this.grammar);
        this.currentOutput.close();
        this.currentOutput = null;
    }

    @Override
    public void gen(WildcardElement wc) {
        if (wc.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(wc.getLabel() + " = " + this.lt1Value + "");
        }
        this.genElementAST(wc);
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("if not _t:");
            ++this.tabs;
            this.println("raise antlr.MismatchedTokenException()");
            --this.tabs;
        } else if (this.grammar instanceof LexerGrammar) {
            if (this.grammar instanceof LexerGrammar && (!this.saveText || wc.getAutoGenType() == 3)) {
                this.println("_saveIndex = self.text.length()");
            }
            this.println("self.matchNot(antlr.EOF_CHAR)");
            if (this.grammar instanceof LexerGrammar && (!this.saveText || wc.getAutoGenType() == 3)) {
                this.println("self.text.setLength(_saveIndex)");
            }
        } else {
            this.println("self.matchNot(" + this.getValueString(1, false) + ")");
        }
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _t.getNextSibling()");
        }
    }

    @Override
    public void gen(ZeroOrMoreBlock blk) {
        int _tabs_ = this.tabs++;
        this.genBlockPreamble(blk);
        this.println("while True:");
        _tabs_ = this.tabs;
        this.genBlockInitAction(blk);
        String saveCurrentASTResult = this.currentASTResult;
        if (blk.getLabel() != null) {
            this.currentASTResult = blk.getLabel();
        }
        boolean ok = this.grammar.theLLkAnalyzer.deterministic(blk);
        boolean generateNonGreedyExitPath = false;
        int nonGreedyExitDepth = this.grammar.maxk;
        if (!blk.greedy && blk.exitLookaheadDepth <= this.grammar.maxk && blk.exitCache[blk.exitLookaheadDepth].containsEpsilon()) {
            generateNonGreedyExitPath = true;
            nonGreedyExitDepth = blk.exitLookaheadDepth;
        } else if (!blk.greedy && blk.exitLookaheadDepth == Integer.MAX_VALUE) {
            generateNonGreedyExitPath = true;
        }
        if (generateNonGreedyExitPath) {
            if (this.DEBUG_CODE_GENERATOR) {
                System.out.println("nongreedy (...)* loop; exit depth is " + blk.exitLookaheadDepth);
            }
            String predictExit = this.getLookaheadTestExpression(blk.exitCache, nonGreedyExitDepth);
            this.println("###  nongreedy exit test");
            this.println("if (" + predictExit + "):");
            ++this.tabs;
            this.println("break");
            --this.tabs;
        }
        int _tabs = this.tabs;
        PythonBlockFinishingInfo howToFinish = this.genCommonBlock(blk, false);
        this.genBlockFinish(howToFinish, "break");
        this.tabs = _tabs;
        this.tabs = _tabs_;
        --this.tabs;
        this.currentASTResult = saveCurrentASTResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void genAlt(Alternative alt, AlternativeBlock blk) {
        boolean savegenAST = this.genAST;
        this.genAST = this.genAST && alt.getAutoGen();
        boolean oldsaveTest = this.saveText;
        this.saveText = this.saveText && alt.getAutoGen();
        Hashtable saveMap = this.treeVariableMap;
        this.treeVariableMap = new Hashtable();
        if (alt.exceptionSpec != null) {
            this.println("try:");
            ++this.tabs;
        }
        this.println("pass");
        AlternativeElement elem = alt.head;
        while (!(elem instanceof BlockEndElement)) {
            elem.generate();
            elem = elem.next;
        }
        if (this.genAST) {
            if (blk instanceof RuleBlock) {
                RuleBlock rblk = (RuleBlock)blk;
                if (this.grammar.hasSyntacticPredicate) {
                    // empty if block
                }
                this.println(rblk.getRuleName() + "_AST = currentAST.root");
                if (!this.grammar.hasSyntacticPredicate) {
                    // empty if block
                }
            } else if (blk.getLabel() != null) {
                this.antlrTool.warning("Labeled subrules not yet supported", this.grammar.getFilename(), blk.getLine(), blk.getColumn());
            }
        }
        if (alt.exceptionSpec != null) {
            --this.tabs;
            this.genErrorHandler(alt.exceptionSpec);
        }
        this.genAST = savegenAST;
        this.saveText = oldsaveTest;
        this.treeVariableMap = saveMap;
    }

    protected void genBitsets(Vector bitsetList, int maxVocabulary) {
        this.println("");
        for (int i = 0; i < bitsetList.size(); ++i) {
            BitSet p = (BitSet)bitsetList.elementAt(i);
            p.growToInclude(maxVocabulary);
            this.genBitSet(p, i);
        }
    }

    private void genBitSet(BitSet p, int id) {
        int _tabs_ = this.tabs;
        this.tabs = 0;
        this.println("");
        this.println("### generate bit set");
        this.println("def mk" + this.getBitsetName(id) + "(): ");
        ++this.tabs;
        int n = p.lengthInLongWords();
        if (n < 8) {
            this.println("### var1");
            this.println("data = [ " + p.toStringOfWords() + "]");
        } else {
            this.println("data = [0L] * " + n + " ### init list");
            long[] elems = p.toPackedArray();
            int i = 0;
            while (i < elems.length) {
                int j;
                if (elems[i] == 0L) {
                    ++i;
                    continue;
                }
                if (i + 1 == elems.length || elems[i] != elems[i + 1]) {
                    this.println("data[" + i + "] =" + elems[i] + "L");
                    ++i;
                    continue;
                }
                for (j = i + 1; j < elems.length && elems[j] == elems[i]; ++j) {
                }
                long e = elems[i];
                this.println("for x in xrange(" + i + ", " + j + "):");
                ++this.tabs;
                this.println("data[x] = " + e + "L");
                --this.tabs;
                i = j;
            }
        }
        this.println("return data");
        --this.tabs;
        this.println(this.getBitsetName(id) + " = antlr.BitSet(mk" + this.getBitsetName(id) + "())");
        this.tabs = _tabs_;
    }

    private void genBlockFinish(PythonBlockFinishingInfo howToFinish, String noViableAction) {
        if (howToFinish.needAnErrorClause && (howToFinish.generatedAnIf || howToFinish.generatedSwitch)) {
            if (howToFinish.generatedAnIf) {
                this.println("else:");
            }
            ++this.tabs;
            this.println(noViableAction);
            --this.tabs;
        }
        if (howToFinish.postscript != null) {
            this.println(howToFinish.postscript);
        }
    }

    private void genBlockFinish1(PythonBlockFinishingInfo howToFinish, String noViableAction) {
        if (howToFinish.needAnErrorClause && (howToFinish.generatedAnIf || howToFinish.generatedSwitch)) {
            if (howToFinish.generatedAnIf) {
                this.println("else:");
            }
            ++this.tabs;
            this.println(noViableAction);
            --this.tabs;
            if (howToFinish.generatedAnIf) {
                // empty if block
            }
        }
        if (howToFinish.postscript != null) {
            this.println(howToFinish.postscript);
        }
    }

    protected void genBlockInitAction(AlternativeBlock blk) {
        if (blk.initAction != null) {
            this.printAction(this.processActionForSpecialSymbols(blk.initAction, blk.getLine(), this.currentRule, null));
        }
    }

    protected void genBlockPreamble(AlternativeBlock blk) {
        if (blk instanceof RuleBlock) {
            RuleBlock rblk = (RuleBlock)blk;
            if (rblk.labeledElements != null) {
                for (int i = 0; i < rblk.labeledElements.size(); ++i) {
                    AlternativeElement a = (AlternativeElement)rblk.labeledElements.elementAt(i);
                    if (a instanceof RuleRefElement || a instanceof AlternativeBlock && !(a instanceof RuleBlock) && !(a instanceof SynPredBlock)) {
                        if (!(a instanceof RuleRefElement) && ((AlternativeBlock)a).not && this.analyzer.subruleCanBeInverted((AlternativeBlock)a, this.grammar instanceof LexerGrammar)) {
                            this.println(a.getLabel() + " = " + this.labeledElementInit);
                            if (!this.grammar.buildAST) continue;
                            this.genASTDeclaration(a);
                            continue;
                        }
                        if (this.grammar.buildAST) {
                            this.genASTDeclaration(a);
                        }
                        if (this.grammar instanceof LexerGrammar) {
                            this.println(a.getLabel() + " = None");
                        }
                        if (!(this.grammar instanceof TreeWalkerGrammar)) continue;
                        this.println(a.getLabel() + " = " + this.labeledElementInit);
                        continue;
                    }
                    this.println(a.getLabel() + " = " + this.labeledElementInit);
                    if (!this.grammar.buildAST) continue;
                    if (a instanceof GrammarAtom && ((GrammarAtom)a).getASTNodeType() != null) {
                        GrammarAtom ga = (GrammarAtom)a;
                        this.genASTDeclaration(a, ga.getASTNodeType());
                        continue;
                    }
                    this.genASTDeclaration(a);
                }
            }
        }
    }

    protected void genCases(BitSet p) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genCases(" + p + ")");
        }
        int[] elems = p.toArray();
        int wrap = this.grammar instanceof LexerGrammar ? 4 : 1;
        boolean j = true;
        boolean startOfLine = true;
        this.print("elif la1 and la1 in ");
        if (this.grammar instanceof LexerGrammar) {
            this._print("u'");
            for (int i = 0; i < elems.length; ++i) {
                this._print(this.getValueString(elems[i], false));
            }
            this._print("':\n");
            return;
        }
        this._print("[");
        for (int i = 0; i < elems.length; ++i) {
            this._print(this.getValueString(elems[i], false));
            if (i + 1 >= elems.length) continue;
            this._print(",");
        }
        this._print("]:\n");
    }

    public PythonBlockFinishingInfo genCommonBlock(AlternativeBlock blk, boolean noTestForSingle) {
        int startDepth;
        int _tabs_ = this.tabs;
        int nIF = 0;
        boolean createdLL1Switch = false;
        int closingBracesOfIFSequence = 0;
        PythonBlockFinishingInfo finishingInfo = new PythonBlockFinishingInfo();
        boolean savegenAST = this.genAST;
        this.genAST = this.genAST && blk.getAutoGen();
        boolean oldsaveTest = this.saveText;
        boolean bl = this.saveText = this.saveText && blk.getAutoGen();
        if (blk.not && this.analyzer.subruleCanBeInverted(blk, this.grammar instanceof LexerGrammar)) {
            if (this.DEBUG_CODE_GENERATOR) {
                System.out.println("special case: ~(subrule)");
            }
            Lookahead p = this.analyzer.look(1, blk);
            if (blk.getLabel() != null && this.syntacticPredLevel == 0) {
                this.println(blk.getLabel() + " = " + this.lt1Value);
            }
            this.genElementAST(blk);
            String astArgs = "";
            if (this.grammar instanceof TreeWalkerGrammar) {
                astArgs = "_t, ";
            }
            this.println("self.match(" + astArgs + this.getBitsetName(this.markBitsetForGen(p.fset)) + ")");
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println("_t = _t.getNextSibling()");
            }
            return finishingInfo;
        }
        if (blk.getAlternatives().size() == 1) {
            Alternative alt = blk.getAlternativeAt(0);
            if (alt.synPred != null) {
                this.antlrTool.warning("Syntactic predicate superfluous for single alternative", this.grammar.getFilename(), blk.getAlternativeAt((int)0).synPred.getLine(), blk.getAlternativeAt((int)0).synPred.getColumn());
            }
            if (noTestForSingle) {
                if (alt.semPred != null) {
                    this.genSemPred(alt.semPred, blk.line);
                }
                this.genAlt(alt, blk);
                return finishingInfo;
            }
        }
        int nLL1 = 0;
        for (int i = 0; i < blk.getAlternatives().size(); ++i) {
            Alternative a = blk.getAlternativeAt(i);
            if (!PythonCodeGenerator.suitableForCaseExpression(a)) continue;
            ++nLL1;
        }
        if (nLL1 >= this.makeSwitchThreshold) {
            String testExpr = this.lookaheadString(1);
            createdLL1Switch = true;
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println("if not _t:");
                ++this.tabs;
                this.println("_t = antlr.ASTNULL");
                --this.tabs;
            }
            this.println("la1 = " + testExpr);
            this.println("if False:");
            ++this.tabs;
            this.println("pass");
            --this.tabs;
            for (int i = 0; i < blk.alternatives.size(); ++i) {
                Alternative alt = blk.getAlternativeAt(i);
                if (!PythonCodeGenerator.suitableForCaseExpression(alt)) continue;
                Lookahead p = alt.cache[1];
                if (p.fset.degree() == 0 && !p.containsEpsilon()) {
                    this.antlrTool.warning("Alternate omitted due to empty prediction set", this.grammar.getFilename(), alt.head.getLine(), alt.head.getColumn());
                    continue;
                }
                this.genCases(p.fset);
                ++this.tabs;
                this.genAlt(alt, blk);
                --this.tabs;
            }
            this.println("else:");
            ++this.tabs;
        }
        for (int altDepth = startDepth = this.grammar instanceof LexerGrammar ? this.grammar.maxk : 0; altDepth >= 0; --altDepth) {
            for (int i = 0; i < blk.alternatives.size(); ++i) {
                String e;
                Alternative alt = blk.getAlternativeAt(i);
                if (this.DEBUG_CODE_GENERATOR) {
                    System.out.println("genAlt: " + i);
                }
                if (createdLL1Switch && PythonCodeGenerator.suitableForCaseExpression(alt)) {
                    if (!this.DEBUG_CODE_GENERATOR) continue;
                    System.out.println("ignoring alt because it was in the switch");
                    continue;
                }
                boolean unpredicted = false;
                if (this.grammar instanceof LexerGrammar) {
                    int effectiveDepth = alt.lookaheadDepth;
                    if (effectiveDepth == Integer.MAX_VALUE) {
                        effectiveDepth = this.grammar.maxk;
                    }
                    while (effectiveDepth >= 1 && alt.cache[effectiveDepth].containsEpsilon()) {
                        --effectiveDepth;
                    }
                    if (effectiveDepth != altDepth) {
                        if (!this.DEBUG_CODE_GENERATOR) continue;
                        System.out.println("ignoring alt because effectiveDepth!=altDepth" + effectiveDepth + "!=" + altDepth);
                        continue;
                    }
                    unpredicted = this.lookaheadIsEmpty(alt, effectiveDepth);
                    e = this.getLookaheadTestExpression(alt, effectiveDepth);
                } else {
                    unpredicted = this.lookaheadIsEmpty(alt, this.grammar.maxk);
                    e = this.getLookaheadTestExpression(alt, this.grammar.maxk);
                }
                if (alt.cache[1].fset.degree() > 127 && PythonCodeGenerator.suitableForCaseExpression(alt)) {
                    if (nIF == 0) {
                        this.println("<m1> if " + e + ":");
                    } else {
                        this.println("<m2> elif " + e + ":");
                    }
                } else if (unpredicted && alt.semPred == null && alt.synPred == null) {
                    if (nIF == 0) {
                        this.println("##<m3> <closing");
                    } else {
                        this.println("else: ## <m4>");
                        ++this.tabs;
                    }
                    finishingInfo.needAnErrorClause = false;
                } else {
                    if (alt.semPred != null) {
                        ActionTransInfo tInfo = new ActionTransInfo();
                        String actionStr = this.processActionForSpecialSymbols(alt.semPred, blk.line, this.currentRule, tInfo);
                        e = (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar) && this.grammar.debuggingOutput ? "(" + e + " and fireSemanticPredicateEvaluated(antlr.debug.SemanticPredicateEvent.PREDICTING, " + this.addSemPred(this.charFormatter.escapeString(actionStr)) + ", " + actionStr + "))" : "(" + e + " and (" + actionStr + "))";
                    }
                    if (nIF > 0) {
                        if (alt.synPred != null) {
                            this.println("else:");
                            ++this.tabs;
                            this.genSynPred(alt.synPred, e);
                            ++closingBracesOfIFSequence;
                        } else {
                            this.println("elif " + e + ":");
                        }
                    } else if (alt.synPred != null) {
                        this.genSynPred(alt.synPred, e);
                    } else {
                        if (this.grammar instanceof TreeWalkerGrammar) {
                            this.println("if not _t:");
                            ++this.tabs;
                            this.println("_t = antlr.ASTNULL");
                            --this.tabs;
                        }
                        this.println("if " + e + ":");
                    }
                }
                ++nIF;
                ++this.tabs;
                this.genAlt(alt, blk);
                --this.tabs;
            }
        }
        String ps = "";
        this.genAST = savegenAST;
        this.saveText = oldsaveTest;
        if (createdLL1Switch) {
            finishingInfo.postscript = ps;
            finishingInfo.generatedSwitch = true;
            finishingInfo.generatedAnIf = nIF > 0;
        } else {
            finishingInfo.postscript = ps;
            finishingInfo.generatedSwitch = false;
            finishingInfo.generatedAnIf = nIF > 0;
        }
        return finishingInfo;
    }

    private static boolean suitableForCaseExpression(Alternative a) {
        return a.lookaheadDepth == 1 && a.semPred == null && !a.cache[1].containsEpsilon() && a.cache[1].fset.degree() <= 127;
    }

    private void genElementAST(AlternativeElement el) {
        if (this.grammar instanceof TreeWalkerGrammar && !this.grammar.buildAST) {
            if (el.getLabel() == null) {
                String elementRef = this.lt1Value;
                String astName = "tmp" + this.astVarNumber + "_AST";
                ++this.astVarNumber;
                this.mapTreeVariable(el, astName);
                this.println(astName + "_in = " + elementRef);
            }
            return;
        }
        if (this.grammar.buildAST && this.syntacticPredLevel == 0) {
            String astNameBase;
            String elementRef;
            boolean doNoGuessTest;
            boolean needASTDecl;
            boolean bl = needASTDecl = this.genAST && (el.getLabel() != null || el.getAutoGenType() != 3);
            if (el.getAutoGenType() != 3 && el instanceof TokenRefElement) {
                needASTDecl = true;
            }
            boolean bl2 = doNoGuessTest = this.grammar.hasSyntacticPredicate && needASTDecl;
            if (el.getLabel() != null) {
                elementRef = el.getLabel();
                astNameBase = el.getLabel();
            } else {
                elementRef = this.lt1Value;
                astNameBase = "tmp" + this.astVarNumber;
                ++this.astVarNumber;
            }
            if (needASTDecl) {
                if (el instanceof GrammarAtom) {
                    GrammarAtom ga = (GrammarAtom)el;
                    if (ga.getASTNodeType() != null) {
                        this.genASTDeclaration(el, astNameBase, ga.getASTNodeType());
                    } else {
                        this.genASTDeclaration(el, astNameBase, this.labeledElementASTType);
                    }
                } else {
                    this.genASTDeclaration(el, astNameBase, this.labeledElementASTType);
                }
            }
            String astName = astNameBase + "_AST";
            this.mapTreeVariable(el, astName);
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println(astName + "_in = None");
            }
            if (doNoGuessTest) {
                // empty if block
            }
            if (el.getLabel() != null) {
                if (el instanceof GrammarAtom) {
                    this.println(astName + " = " + this.getASTCreateString((GrammarAtom)el, elementRef) + "");
                } else {
                    this.println(astName + " = " + this.getASTCreateString(elementRef) + "");
                }
            }
            if (el.getLabel() == null && needASTDecl) {
                elementRef = this.lt1Value;
                if (el instanceof GrammarAtom) {
                    this.println(astName + " = " + this.getASTCreateString((GrammarAtom)el, elementRef) + "");
                } else {
                    this.println(astName + " = " + this.getASTCreateString(elementRef) + "");
                }
                if (this.grammar instanceof TreeWalkerGrammar) {
                    this.println(astName + "_in = " + elementRef + "");
                }
            }
            if (this.genAST) {
                switch (el.getAutoGenType()) {
                    case 1: {
                        this.println("self.addASTChild(currentAST, " + astName + ")");
                        break;
                    }
                    case 2: {
                        this.println("self.makeASTRoot(currentAST, " + astName + ")");
                        break;
                    }
                }
            }
            if (doNoGuessTest) {
                // empty if block
            }
        }
    }

    private void genErrorCatchForElement(AlternativeElement el) {
        ExceptionSpec ex;
        RuleSymbol rs;
        if (el.getLabel() == null) {
            return;
        }
        String r = el.enclosingRuleName;
        if (this.grammar instanceof LexerGrammar) {
            r = CodeGenerator.encodeLexerRuleName(el.enclosingRuleName);
        }
        if ((rs = (RuleSymbol)this.grammar.getSymbol(r)) == null) {
            this.antlrTool.panic("Enclosing rule not found!");
        }
        if ((ex = rs.block.findExceptionSpec(el.getLabel())) != null) {
            --this.tabs;
            this.genErrorHandler(ex);
        }
    }

    private void genErrorHandler(ExceptionSpec ex) {
        for (int i = 0; i < ex.handlers.size(); ++i) {
            ExceptionHandler handler = (ExceptionHandler)ex.handlers.elementAt(i);
            String exceptionType = "";
            String exceptionName = "";
            String s = handler.exceptionTypeAndName.getText();
            s = this.removeAssignmentFromDeclaration(s);
            s = s.trim();
            for (int j = s.length() - 1; j >= 0; --j) {
                if (Character.isLetterOrDigit(s.charAt(j)) || s.charAt(j) == '_') continue;
                exceptionType = s.substring(0, j);
                exceptionName = s.substring(j + 1);
                break;
            }
            this.println("except " + exceptionType + ", " + exceptionName + ":");
            ++this.tabs;
            if (this.grammar.hasSyntacticPredicate) {
                this.println("if not self.inputState.guessing:");
                ++this.tabs;
            }
            ActionTransInfo tInfo = new ActionTransInfo();
            this.printAction(this.processActionForSpecialSymbols(handler.action.getText(), handler.action.getLine(), this.currentRule, tInfo));
            if (this.grammar.hasSyntacticPredicate) {
                --this.tabs;
                this.println("else:");
                ++this.tabs;
                this.println("raise " + exceptionName);
                --this.tabs;
            }
            --this.tabs;
        }
    }

    private void genErrorTryForElement(AlternativeElement el) {
        ExceptionSpec ex;
        RuleSymbol rs;
        if (el.getLabel() == null) {
            return;
        }
        String r = el.enclosingRuleName;
        if (this.grammar instanceof LexerGrammar) {
            r = CodeGenerator.encodeLexerRuleName(el.enclosingRuleName);
        }
        if ((rs = (RuleSymbol)this.grammar.getSymbol(r)) == null) {
            this.antlrTool.panic("Enclosing rule not found!");
        }
        if ((ex = rs.block.findExceptionSpec(el.getLabel())) != null) {
            this.println("try: # for error handling");
            ++this.tabs;
        }
    }

    protected void genASTDeclaration(AlternativeElement el) {
        this.genASTDeclaration(el, this.labeledElementASTType);
    }

    protected void genASTDeclaration(AlternativeElement el, String node_type) {
        this.genASTDeclaration(el, el.getLabel(), node_type);
    }

    protected void genASTDeclaration(AlternativeElement el, String var_name, String node_type) {
        if (this.declaredASTVariables.contains(el)) {
            return;
        }
        this.println(var_name + "_AST = None");
        this.declaredASTVariables.put(el, el);
    }

    protected void genHeader() {
        this.println("### $ANTLR " + Tool.version + ": " + "\"" + this.antlrTool.fileMinusPath(this.antlrTool.grammarFile) + "\"" + " -> " + "\"" + this.grammar.getClassName() + ".py\"$");
    }

    protected void genLexerTest() {
        String className = this.grammar.getClassName();
        this.println("if __name__ == '__main__' :");
        ++this.tabs;
        this.println("import sys");
        this.println("import antlr");
        this.println("import " + className);
        this.println("");
        this.println("### create lexer - shall read from stdin");
        this.println("try:");
        ++this.tabs;
        this.println("for token in " + className + ".Lexer():");
        ++this.tabs;
        this.println("print token");
        this.println("");
        --this.tabs;
        --this.tabs;
        this.println("except antlr.TokenStreamException, e:");
        ++this.tabs;
        this.println("print \"error: exception caught while lexing: \", e");
        --this.tabs;
        --this.tabs;
    }

    private void genLiteralsTest() {
        this.println("### option { testLiterals=true } ");
        this.println("_ttype = self.testLiteralsTable(_ttype)");
    }

    private void genLiteralsTestForPartialToken() {
        this.println("_ttype = self.testLiteralsTable(self.text.getString(), _begin, self.text.length()-_begin, _ttype)");
    }

    protected void genMatch(BitSet b) {
    }

    protected void genMatch(GrammarAtom atom) {
        if (atom instanceof StringLiteralElement) {
            if (this.grammar instanceof LexerGrammar) {
                this.genMatchUsingAtomText(atom);
            } else {
                this.genMatchUsingAtomTokenType(atom);
            }
        } else if (atom instanceof CharLiteralElement) {
            if (this.grammar instanceof LexerGrammar) {
                this.genMatchUsingAtomText(atom);
            } else {
                this.antlrTool.error("cannot ref character literals in grammar: " + atom);
            }
        } else if (atom instanceof TokenRefElement) {
            this.genMatchUsingAtomText(atom);
        } else if (atom instanceof WildcardElement) {
            this.gen((WildcardElement)atom);
        }
    }

    protected void genMatchUsingAtomText(GrammarAtom atom) {
        String astArgs = "";
        if (this.grammar instanceof TreeWalkerGrammar) {
            astArgs = "_t,";
        }
        if (this.grammar instanceof LexerGrammar && (!this.saveText || atom.getAutoGenType() == 3)) {
            this.println("_saveIndex = self.text.length()");
        }
        this.print(atom.not ? "self.matchNot(" : "self.match(");
        this._print(astArgs);
        if (atom.atomText.equals("EOF")) {
            this._print("EOF_TYPE");
        } else {
            this._print(atom.atomText);
        }
        this._println(")");
        if (this.grammar instanceof LexerGrammar && (!this.saveText || atom.getAutoGenType() == 3)) {
            this.println("self.text.setLength(_saveIndex)");
        }
    }

    protected void genMatchUsingAtomTokenType(GrammarAtom atom) {
        String astArgs = "";
        if (this.grammar instanceof TreeWalkerGrammar) {
            astArgs = "_t,";
        }
        Object mangledName = null;
        String s = astArgs + this.getValueString(atom.getType(), true);
        this.println((atom.not ? "self.matchNot(" : "self.match(") + s + ")");
    }

    public void genNextToken() {
        boolean hasPublicRules = false;
        for (int i = 0; i < this.grammar.rules.size(); ++i) {
            RuleSymbol rs = (RuleSymbol)this.grammar.rules.elementAt(i);
            if (!rs.isDefined() || !rs.access.equals("public")) continue;
            hasPublicRules = true;
            break;
        }
        if (!hasPublicRules) {
            this.println("");
            this.println("def nextToken(self): ");
            ++this.tabs;
            this.println("try:");
            ++this.tabs;
            this.println("self.uponEOF()");
            --this.tabs;
            this.println("except antlr.CharStreamIOException, csioe:");
            ++this.tabs;
            this.println("raise antlr.TokenStreamIOException(csioe.io)");
            --this.tabs;
            this.println("except antlr.CharStreamException, cse:");
            ++this.tabs;
            this.println("raise antlr.TokenStreamException(str(cse))");
            --this.tabs;
            this.println("return antlr.CommonToken(type=EOF_TYPE, text=\"\")");
            --this.tabs;
            return;
        }
        RuleBlock nextTokenBlk = MakeGrammar.createNextTokenRule(this.grammar, this.grammar.rules, "nextToken");
        RuleSymbol nextTokenRs = new RuleSymbol("mnextToken");
        nextTokenRs.setDefined();
        nextTokenRs.setBlock(nextTokenBlk);
        nextTokenRs.access = "private";
        this.grammar.define(nextTokenRs);
        boolean ok = this.grammar.theLLkAnalyzer.deterministic(nextTokenBlk);
        String filterRule = null;
        if (((LexerGrammar)this.grammar).filterMode) {
            filterRule = ((LexerGrammar)this.grammar).filterRule;
        }
        this.println("");
        this.println("def nextToken(self):");
        ++this.tabs;
        this.println("while True:");
        ++this.tabs;
        this.println("try: ### try again ..");
        ++this.tabs;
        this.println("while True:");
        ++this.tabs;
        int _tabs_ = this.tabs;
        this.println("_token = None");
        this.println("_ttype = INVALID_TYPE");
        if (((LexerGrammar)this.grammar).filterMode) {
            this.println("self.setCommitToPath(False)");
            if (filterRule != null) {
                if (!this.grammar.isDefined(CodeGenerator.encodeLexerRuleName(filterRule))) {
                    this.grammar.antlrTool.error("Filter rule " + filterRule + " does not exist in this lexer");
                } else {
                    RuleSymbol rs = (RuleSymbol)this.grammar.getSymbol(CodeGenerator.encodeLexerRuleName(filterRule));
                    if (!rs.isDefined()) {
                        this.grammar.antlrTool.error("Filter rule " + filterRule + " does not exist in this lexer");
                    } else if (rs.access.equals("public")) {
                        this.grammar.antlrTool.error("Filter rule " + filterRule + " must be protected");
                    }
                }
                this.println("_m = self.mark()");
            }
        }
        this.println("self.resetText()");
        this.println("try: ## for char stream error handling");
        ++this.tabs;
        _tabs_ = this.tabs++;
        this.println("try: ##for lexical error handling");
        _tabs_ = this.tabs;
        for (int i = 0; i < nextTokenBlk.getAlternatives().size(); ++i) {
            Alternative a = nextTokenBlk.getAlternativeAt(i);
            if (!a.cache[1].containsEpsilon()) continue;
            RuleRefElement rr = (RuleRefElement)a.head;
            String r = CodeGenerator.decodeLexerRuleName(rr.targetRule);
            this.antlrTool.warning("public lexical rule " + r + " is optional (can match \"nothing\")");
        }
        String newline = System.getProperty("line.separator");
        PythonBlockFinishingInfo howToFinish = this.genCommonBlock(nextTokenBlk, false);
        String errFinish = "";
        errFinish = ((LexerGrammar)this.grammar).filterMode ? (filterRule == null ? errFinish + "self.filterdefault(self.LA(1))" : errFinish + "self.filterdefault(self.LA(1), self.m" + filterRule + ", False)") : "self.default(self.LA(1))";
        this.genBlockFinish1(howToFinish, errFinish);
        this.tabs = _tabs_;
        if (((LexerGrammar)this.grammar).filterMode && filterRule != null) {
            this.println("self.commit()");
        }
        this.println("if not self._returnToken:");
        ++this.tabs;
        this.println("raise antlr.TryAgain ### found SKIP token");
        --this.tabs;
        if (((LexerGrammar)this.grammar).getTestLiterals()) {
            this.println("### option { testLiterals=true } ");
            this.println("self.testForLiteral(self._returnToken)");
        }
        this.println("### return token to caller");
        this.println("return self._returnToken");
        --this.tabs;
        this.println("### handle lexical errors ....");
        this.println("except antlr.RecognitionException, e:");
        ++this.tabs;
        if (((LexerGrammar)this.grammar).filterMode) {
            if (filterRule == null) {
                this.println("if not self.getCommitToPath():");
                ++this.tabs;
                this.println("self.consume()");
                this.println("raise antlr.TryAgain()");
                --this.tabs;
            } else {
                this.println("if not self.getCommitToPath(): ");
                ++this.tabs;
                this.println("self.rewind(_m)");
                this.println("self.resetText()");
                this.println("try:");
                ++this.tabs;
                this.println("self.m" + filterRule + "(False)");
                --this.tabs;
                this.println("except antlr.RecognitionException, ee:");
                ++this.tabs;
                this.println("### horrendous failure: error in filter rule");
                this.println("self.reportError(ee)");
                this.println("self.consume()");
                --this.tabs;
                this.println("raise antlr.TryAgain()");
                --this.tabs;
            }
        }
        if (nextTokenBlk.getDefaultErrorHandler()) {
            this.println("self.reportError(e)");
            this.println("self.consume()");
        } else {
            this.println("raise antlr.TokenStreamRecognitionException(e)");
        }
        --this.tabs;
        --this.tabs;
        this.println("### handle char stream errors ...");
        this.println("except antlr.CharStreamException,cse:");
        ++this.tabs;
        this.println("if isinstance(cse, antlr.CharStreamIOException):");
        ++this.tabs;
        this.println("raise antlr.TokenStreamIOException(cse.io)");
        --this.tabs;
        this.println("else:");
        ++this.tabs;
        this.println("raise antlr.TokenStreamException(str(cse))");
        --this.tabs;
        --this.tabs;
        --this.tabs;
        --this.tabs;
        this.println("except antlr.TryAgain:");
        ++this.tabs;
        this.println("pass");
        --this.tabs;
        --this.tabs;
    }

    public void genRule(RuleSymbol s, boolean startSymbol, int ruleNum) {
        RuleBlock rblk;
        this.tabs = 1;
        if (!s.isDefined()) {
            this.antlrTool.error("undefined rule: " + s.getId());
            return;
        }
        this.currentRule = rblk = s.getBlock();
        this.currentASTResult = s.getId();
        this.declaredASTVariables.clear();
        boolean savegenAST = this.genAST;
        this.genAST = this.genAST && rblk.getAutoGen();
        this.saveText = rblk.getAutoGen();
        this.genJavadocComment(s);
        this.print("def " + s.getId() + "(");
        this._print(this.commonExtraParams);
        if (this.commonExtraParams.length() != 0 && rblk.argAction != null) {
            this._print(",");
        }
        if (rblk.argAction != null) {
            this._println("");
            ++this.tabs;
            this.println(rblk.argAction);
            --this.tabs;
            this.print("):");
        } else {
            this._print("):");
        }
        this.println("");
        ++this.tabs;
        if (rblk.returnAction != null) {
            if (rblk.returnAction.indexOf(61) >= 0) {
                this.println(rblk.returnAction);
            } else {
                this.println(this.extractIdOfAction(rblk.returnAction, rblk.getLine(), rblk.getColumn()) + " = None");
            }
        }
        this.println(this.commonLocalVars);
        if (this.grammar.traceRules) {
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println("self.traceIn(\"" + s.getId() + "\",_t)");
            } else {
                this.println("self.traceIn(\"" + s.getId() + "\")");
            }
        }
        if (this.grammar instanceof LexerGrammar) {
            if (s.getId().equals("mEOF")) {
                this.println("_ttype = EOF_TYPE");
            } else {
                this.println("_ttype = " + s.getId().substring(1));
            }
            this.println("_saveIndex = 0");
        }
        if (this.grammar.debuggingOutput) {
            if (this.grammar instanceof ParserGrammar) {
                this.println("self.fireEnterRule(" + ruleNum + ", 0)");
            } else if (this.grammar instanceof LexerGrammar) {
                this.println("self.fireEnterRule(" + ruleNum + ", _ttype)");
            }
        }
        if (this.grammar.debuggingOutput || this.grammar.traceRules) {
            this.println("try: ### debugging");
            ++this.tabs;
        }
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println(s.getId() + "_AST_in = None");
            this.println("if _t != antlr.ASTNULL:");
            ++this.tabs;
            this.println(s.getId() + "_AST_in = _t");
            --this.tabs;
        }
        if (this.grammar.buildAST) {
            this.println("self.returnAST = None");
            this.println("currentAST = antlr.ASTPair()");
            this.println(s.getId() + "_AST = None");
        }
        this.genBlockPreamble(rblk);
        this.genBlockInitAction(rblk);
        ExceptionSpec unlabeledUserSpec = rblk.findExceptionSpec("");
        if (unlabeledUserSpec != null || rblk.getDefaultErrorHandler()) {
            this.println("try:      ## for error handling");
            ++this.tabs;
        }
        int _tabs_ = this.tabs;
        if (rblk.alternatives.size() == 1) {
            Alternative alt = rblk.getAlternativeAt(0);
            String pred = alt.semPred;
            if (pred != null) {
                this.genSemPred(pred, this.currentRule.line);
            }
            if (alt.synPred != null) {
                this.antlrTool.warning("Syntactic predicate ignored for single alternative", this.grammar.getFilename(), alt.synPred.getLine(), alt.synPred.getColumn());
            }
            this.genAlt(alt, rblk);
        } else {
            boolean ok = this.grammar.theLLkAnalyzer.deterministic(rblk);
            PythonBlockFinishingInfo howToFinish = this.genCommonBlock(rblk, false);
            this.genBlockFinish(howToFinish, this.throwNoViable);
        }
        this.tabs = _tabs_;
        if (unlabeledUserSpec != null || rblk.getDefaultErrorHandler()) {
            --this.tabs;
            this.println("");
        }
        if (unlabeledUserSpec != null) {
            this.genErrorHandler(unlabeledUserSpec);
        } else if (rblk.getDefaultErrorHandler()) {
            this.println("except " + this.exceptionThrown + ", ex:");
            ++this.tabs;
            if (this.grammar.hasSyntacticPredicate) {
                this.println("if not self.inputState.guessing:");
                ++this.tabs;
            }
            this.println("self.reportError(ex)");
            if (!(this.grammar instanceof TreeWalkerGrammar)) {
                Lookahead follow = this.grammar.theLLkAnalyzer.FOLLOW(1, rblk.endNode);
                String followSetName = this.getBitsetName(this.markBitsetForGen(follow.fset));
                this.println("self.consume()");
                this.println("self.consumeUntil(" + followSetName + ")");
            } else {
                this.println("if _t:");
                ++this.tabs;
                this.println("_t = _t.getNextSibling()");
                --this.tabs;
            }
            if (this.grammar.hasSyntacticPredicate) {
                --this.tabs;
                this.println("else:");
                ++this.tabs;
                this.println("raise ex");
                --this.tabs;
            }
            --this.tabs;
            this.println("");
        }
        if (this.grammar.buildAST) {
            this.println("self.returnAST = " + s.getId() + "_AST");
        }
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("self._retTree = _t");
        }
        if (rblk.getTestLiterals()) {
            if (s.access.equals("protected")) {
                this.genLiteralsTestForPartialToken();
            } else {
                this.genLiteralsTest();
            }
        }
        if (this.grammar instanceof LexerGrammar) {
            this.println("self.set_return_token(_createToken, _token, _ttype, _begin)");
        }
        if (rblk.returnAction != null) {
            this.println("return " + this.extractIdOfAction(rblk.returnAction, rblk.getLine(), rblk.getColumn()) + "");
        }
        if (this.grammar.debuggingOutput || this.grammar.traceRules) {
            --this.tabs;
            this.println("finally:  ### debugging");
            ++this.tabs;
            if (this.grammar.debuggingOutput) {
                if (this.grammar instanceof ParserGrammar) {
                    this.println("self.fireExitRule(" + ruleNum + ", 0)");
                } else if (this.grammar instanceof LexerGrammar) {
                    this.println("self.fireExitRule(" + ruleNum + ", _ttype)");
                }
            }
            if (this.grammar.traceRules) {
                if (this.grammar instanceof TreeWalkerGrammar) {
                    this.println("self.traceOut(\"" + s.getId() + "\", _t)");
                } else {
                    this.println("self.traceOut(\"" + s.getId() + "\")");
                }
            }
            --this.tabs;
        }
        --this.tabs;
        this.println("");
        this.genAST = savegenAST;
    }

    private void GenRuleInvocation(RuleRefElement rr) {
        this._print("self." + rr.targetRule + "(");
        if (this.grammar instanceof LexerGrammar) {
            if (rr.getLabel() != null) {
                this._print("True");
            } else {
                this._print("False");
            }
            if (this.commonExtraArgs.length() != 0 || rr.args != null) {
                this._print(", ");
            }
        }
        this._print(this.commonExtraArgs);
        if (this.commonExtraArgs.length() != 0 && rr.args != null) {
            this._print(", ");
        }
        RuleSymbol rs = (RuleSymbol)this.grammar.getSymbol(rr.targetRule);
        if (rr.args != null) {
            ActionTransInfo tInfo = new ActionTransInfo();
            String args = this.processActionForSpecialSymbols(rr.args, 0, this.currentRule, tInfo);
            if (tInfo.assignToRoot || tInfo.refRuleRoot != null) {
                this.antlrTool.error("Arguments of rule reference '" + rr.targetRule + "' cannot set or ref #" + this.currentRule.getRuleName(), this.grammar.getFilename(), rr.getLine(), rr.getColumn());
            }
            this._print(args);
            if (rs.block.argAction == null) {
                this.antlrTool.warning("Rule '" + rr.targetRule + "' accepts no arguments", this.grammar.getFilename(), rr.getLine(), rr.getColumn());
            }
        } else if (rs.block.argAction != null) {
            this.antlrTool.warning("Missing parameters on reference to rule " + rr.targetRule, this.grammar.getFilename(), rr.getLine(), rr.getColumn());
        }
        this._println(")");
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = self._retTree");
        }
    }

    protected void genSemPred(String pred, int line) {
        ActionTransInfo tInfo = new ActionTransInfo();
        pred = this.processActionForSpecialSymbols(pred, line, this.currentRule, tInfo);
        String escapedPred = this.charFormatter.escapeString(pred);
        if (this.grammar.debuggingOutput && (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar)) {
            pred = "fireSemanticPredicateEvaluated(antlr.debug.SemanticPredicateEvent.VALIDATING," + this.addSemPred(escapedPred) + ", " + pred + ")";
        }
        this.println("if not " + pred + ":");
        ++this.tabs;
        this.println("raise antlr.SemanticException(\"" + escapedPred + "\")");
        --this.tabs;
    }

    protected void genSemPredMap() {
        Enumeration e = this.semPreds.elements();
        this.println("_semPredNames = [");
        ++this.tabs;
        while (e.hasMoreElements()) {
            this.println("\"" + e.nextElement() + "\",");
        }
        --this.tabs;
        this.println("]");
    }

    protected void genSynPred(SynPredBlock blk, String lookaheadExpr) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen=>(" + blk + ")");
        }
        this.println("synPredMatched" + blk.ID + " = False");
        this.println("if " + lookaheadExpr + ":");
        ++this.tabs;
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t" + blk.ID + " = _t");
        } else {
            this.println("_m" + blk.ID + " = self.mark()");
        }
        this.println("synPredMatched" + blk.ID + " = True");
        this.println("self.inputState.guessing += 1");
        if (this.grammar.debuggingOutput && (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar)) {
            this.println("self.fireSyntacticPredicateStarted()");
        }
        ++this.syntacticPredLevel;
        this.println("try:");
        ++this.tabs;
        this.gen(blk);
        --this.tabs;
        this.println("except " + this.exceptionThrown + ", pe:");
        ++this.tabs;
        this.println("synPredMatched" + blk.ID + " = False");
        --this.tabs;
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _t" + blk.ID + "");
        } else {
            this.println("self.rewind(_m" + blk.ID + ")");
        }
        this.println("self.inputState.guessing -= 1");
        if (this.grammar.debuggingOutput && (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar)) {
            this.println("if synPredMatched" + blk.ID + ":");
            ++this.tabs;
            this.println("self.fireSyntacticPredicateSucceeded()");
            --this.tabs;
            this.println("else:");
            ++this.tabs;
            this.println("self.fireSyntacticPredicateFailed()");
            --this.tabs;
        }
        --this.syntacticPredLevel;
        --this.tabs;
        this.println("if synPredMatched" + blk.ID + ":");
    }

    public void genTokenStrings() {
        int save_tabs = this.tabs;
        this.tabs = 0;
        this.println("");
        this.println("_tokenNames = [");
        ++this.tabs;
        Vector v = this.grammar.tokenManager.getVocabulary();
        for (int i = 0; i < v.size(); ++i) {
            TokenSymbol ts;
            String s = (String)v.elementAt(i);
            if (s == null) {
                s = "<" + String.valueOf(i) + ">";
            }
            if (!s.startsWith("\"") && !s.startsWith("<") && (ts = this.grammar.tokenManager.getTokenSymbol(s)) != null && ts.getParaphrase() != null) {
                s = StringUtils.stripFrontBack(ts.getParaphrase(), "\"", "\"");
            }
            this.print(this.charFormatter.literalString(s));
            if (i != v.size() - 1) {
                this._print(", ");
            }
            this._println("");
        }
        --this.tabs;
        this.println("]");
        this.tabs = save_tabs;
    }

    protected void genTokenASTNodeMap() {
        this.println("");
        this.println("def buildTokenTypeASTClassMap(self):");
        ++this.tabs;
        boolean generatedNewHashtable = false;
        int n = 0;
        Vector v = this.grammar.tokenManager.getVocabulary();
        for (int i = 0; i < v.size(); ++i) {
            TokenSymbol ts;
            String s = (String)v.elementAt(i);
            if (s == null || (ts = this.grammar.tokenManager.getTokenSymbol(s)) == null || ts.getASTNodeType() == null) continue;
            ++n;
            if (!generatedNewHashtable) {
                this.println("self.tokenTypeToASTClassMap = {}");
                generatedNewHashtable = true;
            }
            this.println("self.tokenTypeToASTClassMap[" + ts.getTokenType() + "] = " + ts.getASTNodeType());
        }
        if (n == 0) {
            this.println("self.tokenTypeToASTClassMap = None");
        }
        --this.tabs;
    }

    protected void genTokenTypes(TokenManager tm) throws IOException {
        this.tabs = 0;
        Vector v = tm.getVocabulary();
        this.println("SKIP                = antlr.SKIP");
        this.println("INVALID_TYPE        = antlr.INVALID_TYPE");
        this.println("EOF_TYPE            = antlr.EOF_TYPE");
        this.println("EOF                 = antlr.EOF");
        this.println("NULL_TREE_LOOKAHEAD = antlr.NULL_TREE_LOOKAHEAD");
        this.println("MIN_USER_TYPE       = antlr.MIN_USER_TYPE");
        for (int i = 4; i < v.size(); ++i) {
            String s = (String)v.elementAt(i);
            if (s == null) continue;
            if (s.startsWith("\"")) {
                StringLiteralSymbol sl = (StringLiteralSymbol)tm.getTokenSymbol(s);
                if (sl == null) {
                    this.antlrTool.panic("String literal " + s + " not in symbol table");
                }
                if (sl.label != null) {
                    this.println(sl.label + " = " + i);
                    continue;
                }
                String mangledName = this.mangleLiteral(s);
                if (mangledName != null) {
                    this.println(mangledName + " = " + i);
                    sl.label = mangledName;
                    continue;
                }
                this.println("### " + s + " = " + i);
                continue;
            }
            if (s.startsWith("<")) continue;
            this.println(s + " = " + i);
        }
        --this.tabs;
        this.exitIfError();
    }

    @Override
    public String getASTCreateString(Vector v) {
        if (v.size() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("antlr.make(");
        for (int i = 0; i < v.size(); ++i) {
            buf.append(v.elementAt(i));
            if (i + 1 >= v.size()) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public String getASTCreateString(GrammarAtom atom, String astCtorArgs) {
        if (atom != null && atom.getASTNodeType() != null) {
            return "self.astFactory.create(" + astCtorArgs + ", " + atom.getASTNodeType() + ")";
        }
        return this.getASTCreateString(astCtorArgs);
    }

    public String getASTCreateString(String astCtorArgs) {
        if (astCtorArgs == null) {
            astCtorArgs = "";
        }
        int nCommas = 0;
        for (int i = 0; i < astCtorArgs.length(); ++i) {
            if (astCtorArgs.charAt(i) != ',') continue;
            ++nCommas;
        }
        if (nCommas < 2) {
            TokenSymbol ts;
            int firstComma = astCtorArgs.indexOf(44);
            int lastComma = astCtorArgs.lastIndexOf(44);
            String tokenName = astCtorArgs;
            if (nCommas > 0) {
                tokenName = astCtorArgs.substring(0, firstComma);
            }
            if ((ts = this.grammar.tokenManager.getTokenSymbol(tokenName)) != null) {
                String astNodeType = ts.getASTNodeType();
                String emptyText = "";
                if (nCommas == 0) {
                    emptyText = ", \"\"";
                }
                if (astNodeType != null) {
                    return "self.astFactory.create(" + astCtorArgs + emptyText + ", " + astNodeType + ")";
                }
            }
            if (this.labeledElementASTType.equals("AST")) {
                return "self.astFactory.create(" + astCtorArgs + ")";
            }
            return "self.astFactory.create(" + astCtorArgs + ")";
        }
        return "self.astFactory.create(" + astCtorArgs + ")";
    }

    protected String getLookaheadTestExpression(Lookahead[] look, int k) {
        StringBuffer e = new StringBuffer(100);
        boolean first = true;
        e.append("(");
        for (int i = 1; i <= k; ++i) {
            BitSet p = look[i].fset;
            if (!first) {
                e.append(") and (");
            }
            first = false;
            if (look[i].containsEpsilon()) {
                e.append("True");
                continue;
            }
            e.append(this.getLookaheadTestTerm(i, p));
        }
        e.append(")");
        String s = e.toString();
        return s;
    }

    protected String getLookaheadTestExpression(Alternative alt, int maxDepth) {
        int depth = alt.lookaheadDepth;
        if (depth == Integer.MAX_VALUE) {
            depth = this.grammar.maxk;
        }
        if (maxDepth == 0) {
            return "True";
        }
        return this.getLookaheadTestExpression(alt.cache, depth);
    }

    protected String getLookaheadTestTerm(int k, BitSet p) {
        String ts = this.lookaheadString(k);
        int[] elems = p.toArray();
        if (PythonCodeGenerator.elementsAreRange(elems)) {
            String s = this.getRangeExpression(k, elems);
            return s;
        }
        int degree = p.degree();
        if (degree == 0) {
            return "True";
        }
        if (degree >= this.bitsetTestThreshold) {
            int bitsetIdx = this.markBitsetForGen(p);
            return this.getBitsetName(bitsetIdx) + ".member(" + ts + ")";
        }
        StringBuffer e = new StringBuffer();
        for (int i = 0; i < elems.length; ++i) {
            String cs = this.getValueString(elems[i], true);
            if (i > 0) {
                e.append(" or ");
            }
            e.append(ts);
            e.append("==");
            e.append(cs);
        }
        String x = e.toString();
        return e.toString();
    }

    public String getRangeExpression(int k, int[] elems) {
        if (!PythonCodeGenerator.elementsAreRange(elems)) {
            this.antlrTool.panic("getRangeExpression called with non-range");
        }
        int begin = elems[0];
        int end = elems[elems.length - 1];
        return "(" + this.lookaheadString(k) + " >= " + this.getValueString(begin, true) + " and " + this.lookaheadString(k) + " <= " + this.getValueString(end, true) + ")";
    }

    private String getValueString(int value, boolean wrap) {
        String cs;
        if (this.grammar instanceof LexerGrammar) {
            String cs2 = this.charFormatter.literalChar(value);
            if (wrap) {
                cs2 = "u'" + cs2 + "'";
            }
            return cs2;
        }
        TokenSymbol ts = this.grammar.tokenManager.getTokenSymbolAt(value);
        if (ts == null) {
            String cs3 = "" + value;
            return cs3;
        }
        String tId = ts.getId();
        if (!(ts instanceof StringLiteralSymbol)) {
            String cs4 = tId;
            return cs4;
        }
        StringLiteralSymbol sl = (StringLiteralSymbol)ts;
        String label = sl.getLabel();
        if (label != null) {
            cs = label;
        } else {
            cs = this.mangleLiteral(tId);
            if (cs == null) {
                cs = String.valueOf(value);
            }
        }
        return cs;
    }

    protected boolean lookaheadIsEmpty(Alternative alt, int maxDepth) {
        int depth = alt.lookaheadDepth;
        if (depth == Integer.MAX_VALUE) {
            depth = this.grammar.maxk;
        }
        for (int i = 1; i <= depth && i <= maxDepth; ++i) {
            BitSet p = alt.cache[i].fset;
            if (p.degree() == 0) continue;
            return false;
        }
        return true;
    }

    private String lookaheadString(int k) {
        if (this.grammar instanceof TreeWalkerGrammar) {
            return "_t.getType()";
        }
        return "self.LA(" + k + ")";
    }

    private String mangleLiteral(String s) {
        String mangled = this.antlrTool.literalsPrefix;
        for (int i = 1; i < s.length() - 1; ++i) {
            if (!Character.isLetter(s.charAt(i)) && s.charAt(i) != '_') {
                return null;
            }
            mangled = mangled + s.charAt(i);
        }
        if (this.antlrTool.upperCaseMangledLiterals) {
            mangled = mangled.toUpperCase();
        }
        return mangled;
    }

    @Override
    public String mapTreeId(String idParam, ActionTransInfo transInfo) {
        if (this.currentRule == null) {
            return idParam;
        }
        boolean in_var = false;
        String id = idParam;
        if (this.grammar instanceof TreeWalkerGrammar) {
            if (!this.grammar.buildAST) {
                in_var = true;
            } else if (id.length() > 3 && id.lastIndexOf("_in") == id.length() - 3) {
                id = id.substring(0, id.length() - 3);
                in_var = true;
            }
        }
        for (int i = 0; i < this.currentRule.labeledElements.size(); ++i) {
            AlternativeElement elt = (AlternativeElement)this.currentRule.labeledElements.elementAt(i);
            if (!elt.getLabel().equals(id)) continue;
            return in_var ? id : id + "_AST";
        }
        String s = (String)this.treeVariableMap.get(id);
        if (s != null) {
            if (s == NONUNIQUE) {
                this.antlrTool.error("Ambiguous reference to AST element " + id + " in rule " + this.currentRule.getRuleName());
                return null;
            }
            if (s.equals(this.currentRule.getRuleName())) {
                this.antlrTool.error("Ambiguous reference to AST element " + id + " in rule " + this.currentRule.getRuleName());
                return null;
            }
            return in_var ? s + "_in" : s;
        }
        if (id.equals(this.currentRule.getRuleName())) {
            String r;
            String string = r = in_var ? id + "_AST_in" : id + "_AST";
            if (transInfo != null && !in_var) {
                transInfo.refRuleRoot = r;
            }
            return r;
        }
        return id;
    }

    private void mapTreeVariable(AlternativeElement e, String name) {
        if (e instanceof TreeElement) {
            this.mapTreeVariable(((TreeElement)e).root, name);
            return;
        }
        String elName = null;
        if (e.getLabel() == null) {
            if (e instanceof TokenRefElement) {
                elName = ((TokenRefElement)e).atomText;
            } else if (e instanceof RuleRefElement) {
                elName = ((RuleRefElement)e).targetRule;
            }
        }
        if (elName != null) {
            if (this.treeVariableMap.get(elName) != null) {
                this.treeVariableMap.remove(elName);
                this.treeVariableMap.put(elName, NONUNIQUE);
            } else {
                this.treeVariableMap.put(elName, name);
            }
        }
    }

    @Override
    protected String processActionForSpecialSymbols(String actionStr, int line, RuleBlock currentRule, ActionTransInfo tInfo) {
        if (actionStr == null || actionStr.length() == 0) {
            return null;
        }
        if (PythonCodeGenerator.isEmpty(actionStr)) {
            return "";
        }
        if (this.grammar == null) {
            return actionStr;
        }
        ActionLexer lexer = new ActionLexer(actionStr, currentRule, this, tInfo);
        lexer.setLineOffset(line);
        lexer.setFilename(this.grammar.getFilename());
        lexer.setTool(this.antlrTool);
        try {
            lexer.mACTION(true);
            actionStr = lexer.getTokenObject().getText();
        }
        catch (RecognitionException ex) {
            lexer.reportError(ex);
        }
        catch (TokenStreamException tex) {
            this.antlrTool.panic("Error reading action:" + actionStr);
        }
        catch (CharStreamException io) {
            this.antlrTool.panic("Error reading action:" + actionStr);
        }
        return actionStr;
    }

    static boolean isEmpty(String s) {
        boolean ws = true;
        block3: for (int i = 0; ws && i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    ws = false;
                }
            }
        }
        return ws;
    }

    protected String processActionCode(String actionStr, int line) {
        if (actionStr == null || PythonCodeGenerator.isEmpty(actionStr)) {
            return "";
        }
        CodeLexer lexer = new CodeLexer(actionStr, this.grammar.getFilename(), line, this.antlrTool);
        try {
            lexer.mACTION(true);
            actionStr = lexer.getTokenObject().getText();
        }
        catch (RecognitionException ex) {
            lexer.reportError(ex);
        }
        catch (TokenStreamException tex) {
            this.antlrTool.panic("Error reading action:" + actionStr);
        }
        catch (CharStreamException io) {
            this.antlrTool.panic("Error reading action:" + actionStr);
        }
        return actionStr;
    }

    protected void printActionCode(String actionStr, int line) {
        actionStr = this.processActionCode(actionStr, line);
        this.printAction(actionStr);
    }

    private void setupGrammarParameters(Grammar g) {
        if (g instanceof ParserGrammar) {
            String cname;
            Token tcname;
            String suffix;
            Token tsuffix;
            this.labeledElementASTType = "";
            if (g.hasOption("ASTLabelType") && (tsuffix = g.getOption("ASTLabelType")) != null && (suffix = StringUtils.stripFrontBack(tsuffix.getText(), "\"", "\"")) != null) {
                this.labeledElementASTType = suffix;
            }
            this.labeledElementType = "";
            this.labeledElementInit = "None";
            this.commonExtraArgs = "";
            this.commonExtraParams = "self";
            this.commonLocalVars = "";
            this.lt1Value = "self.LT(1)";
            this.exceptionThrown = "antlr.RecognitionException";
            this.throwNoViable = "raise antlr.NoViableAltException(self.LT(1), self.getFilename())";
            this.parserClassName = "Parser";
            if (g.hasOption("className") && (tcname = g.getOption("className")) != null && (cname = StringUtils.stripFrontBack(tcname.getText(), "\"", "\"")) != null) {
                this.parserClassName = cname;
            }
            return;
        }
        if (g instanceof LexerGrammar) {
            String cname;
            Token tcname;
            this.labeledElementType = "char ";
            this.labeledElementInit = "'\\0'";
            this.commonExtraArgs = "";
            this.commonExtraParams = "self, _createToken";
            this.commonLocalVars = "_ttype = 0\n        _token = None\n        _begin = self.text.length()";
            this.lt1Value = "self.LA(1)";
            this.exceptionThrown = "antlr.RecognitionException";
            this.throwNoViable = "self.raise_NoViableAlt(self.LA(1))";
            this.lexerClassName = "Lexer";
            if (g.hasOption("className") && (tcname = g.getOption("className")) != null && (cname = StringUtils.stripFrontBack(tcname.getText(), "\"", "\"")) != null) {
                this.lexerClassName = cname;
            }
            return;
        }
        if (g instanceof TreeWalkerGrammar) {
            String cname;
            Token tcname;
            String suffix;
            Token tsuffix;
            this.labeledElementASTType = "";
            this.labeledElementType = "";
            if (g.hasOption("ASTLabelType") && (tsuffix = g.getOption("ASTLabelType")) != null && (suffix = StringUtils.stripFrontBack(tsuffix.getText(), "\"", "\"")) != null) {
                this.labeledElementASTType = suffix;
                this.labeledElementType = suffix;
            }
            if (!g.hasOption("ASTLabelType")) {
                g.setOption("ASTLabelType", new Token(6, "<4>AST"));
            }
            this.labeledElementInit = "None";
            this.commonExtraArgs = "_t";
            this.commonExtraParams = "self, _t";
            this.commonLocalVars = "";
            this.lt1Value = "_t";
            this.exceptionThrown = "antlr.RecognitionException";
            this.throwNoViable = "raise antlr.NoViableAltException(_t)";
            this.treeWalkerClassName = "Walker";
            if (g.hasOption("className") && (tcname = g.getOption("className")) != null && (cname = StringUtils.stripFrontBack(tcname.getText(), "\"", "\"")) != null) {
                this.treeWalkerClassName = cname;
            }
            return;
        }
        this.antlrTool.panic("Unknown grammar type");
    }

    public void setupOutput(String className) throws IOException {
        this.currentOutput = this.antlrTool.openOutputFile(className + ".py");
    }

    protected boolean isspace(char c) {
        boolean r = true;
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                break;
            }
            default: {
                r = false;
            }
        }
        return r;
    }

    @Override
    protected void _printAction(String s) {
        char c;
        if (s == null) {
            return;
        }
        int start = 0;
        int end = s.length();
        int offset = 0;
        boolean ws = true;
        block15: while (start < end && ws) {
            c = s.charAt(start++);
            switch (c) {
                case '\n': {
                    offset = start;
                    continue block15;
                }
                case '\r': {
                    if (start > end || s.charAt(start) == '\n') {
                        // empty if block
                    }
                    offset = ++start;
                    continue block15;
                }
                case ' ': {
                    continue block15;
                }
            }
            ws = false;
        }
        if (!ws) {
            --start;
        }
        offset = start - offset;
        --end;
        while (end > start && this.isspace(s.charAt(end))) {
            --end;
        }
        boolean newline = false;
        block17: for (int i = start; i <= end; ++i) {
            c = s.charAt(i);
            switch (c) {
                case '\n': {
                    newline = true;
                    break;
                }
                case '\r': {
                    newline = true;
                    if (i + 1 > end || s.charAt(i + 1) != '\n') break;
                    ++i;
                    break;
                }
                case '\t': {
                    System.err.println("warning: tab characters used in Python action");
                    this.currentOutput.print("        ");
                    break;
                }
                case ' ': {
                    this.currentOutput.print(" ");
                    break;
                }
                default: {
                    this.currentOutput.print(c);
                }
            }
            if (!newline) continue;
            this.currentOutput.print("\n");
            this.printTabs();
            int absorbed = 0;
            newline = false;
            ++i;
            while (i <= end) {
                c = s.charAt(i);
                if (!this.isspace(c)) {
                    --i;
                    continue block17;
                }
                switch (c) {
                    case '\n': {
                        newline = true;
                        break;
                    }
                    case '\r': {
                        if (i + 1 <= end && s.charAt(i + 1) == '\n') {
                            ++i;
                        }
                        newline = true;
                    }
                }
                if (newline) {
                    this.currentOutput.print("\n");
                    this.printTabs();
                    absorbed = 0;
                    newline = false;
                } else {
                    if (absorbed >= offset) continue block17;
                    ++absorbed;
                }
                ++i;
            }
        }
        this.currentOutput.println();
    }

    protected void od(String s, int i, int end, String msg) {
        System.out.println(msg);
        block5: for (int j = i; j <= end; ++j) {
            char c = s.charAt(j);
            switch (c) {
                case '\n': {
                    System.out.print(" nl ");
                    continue block5;
                }
                case '\t': {
                    System.out.print(" ht ");
                    continue block5;
                }
                case ' ': {
                    System.out.print(" sp ");
                    continue block5;
                }
                default: {
                    System.out.print(" " + c + " ");
                }
            }
        }
        System.out.println("");
    }

    @Override
    protected void printAction(String s) {
        if (s != null) {
            this.printTabs();
            this._printAction(s);
        }
    }

    protected void printGrammarAction(Grammar grammar) {
        this.println("### user action >>>");
        this.printAction(this.processActionForSpecialSymbols(grammar.classMemberAction.getText(), grammar.classMemberAction.getLine(), this.currentRule, null));
        this.println("### user action <<<");
    }

    protected void _printJavadoc(String s) {
        int end = s.length();
        int start = 0;
        boolean newline = false;
        this.currentOutput.print("\n");
        this.printTabs();
        this.currentOutput.print("###");
        for (int i = start; i < end; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    newline = true;
                    break;
                }
                case '\r': {
                    newline = true;
                    if (i + 1 > end || s.charAt(i + 1) != '\n') break;
                    ++i;
                    break;
                }
                case '\t': {
                    this.currentOutput.print("\t");
                    break;
                }
                case ' ': {
                    this.currentOutput.print(" ");
                    break;
                }
                default: {
                    this.currentOutput.print(c);
                }
            }
            if (!newline) continue;
            this.currentOutput.print("\n");
            this.printTabs();
            this.currentOutput.print("###");
            newline = false;
        }
        this.currentOutput.println();
    }

    protected void genJavadocComment(Grammar g) {
        if (g.comment != null) {
            this._printJavadoc(g.comment);
        }
    }

    protected void genJavadocComment(RuleSymbol g) {
        if (g.comment != null) {
            this._printJavadoc(g.comment);
        }
    }
}

