/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.management.impl;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.migration.wfly10.config.management.HostConfiguration;
import org.jboss.migration.wfly10.config.management.HostControllerConfiguration;
import org.jboss.migration.wfly10.config.management.impl.AbstractManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.impl.JvmResourceImpl;
import org.jboss.migration.wfly10.config.management.impl.ManagementInterfaceResourceImpl;
import org.jboss.migration.wfly10.config.management.impl.SecurityRealmResourceImpl;
import org.jboss.migration.wfly10.config.management.impl.SubsystemResourceImpl;
import org.jboss.migration.wfly10.config.task.HostMigration;

public class EmbeddedHostConfiguration
extends AbstractManageableServerConfiguration
implements HostConfiguration {
    private final HostControllerConfiguration hostController;
    private final JvmResourceImpl.Factory jvmResources;
    private final ManagementInterfaceResourceImpl.Factory managementInterfaceResources;
    private final SecurityRealmResourceImpl.Factory securityRealmResources;
    private final SubsystemResourceImpl.Factory subsystemResources;

    public EmbeddedHostConfiguration(HostControllerConfiguration hostController, String host) {
        super(host, PathAddress.pathAddress((String)"host", (String)host), hostController.getConfigurationPath(), hostController.getServer());
        this.hostController = hostController;
        this.jvmResources = new JvmResourceImpl.Factory(this.getResourcePathAddress(), this);
        this.addChildResourceFactory(this.jvmResources);
        this.subsystemResources = new SubsystemResourceImpl.Factory(this.getResourcePathAddress(), this);
        this.addChildResourceFactory(this.subsystemResources);
        PathAddress managementCoreServicePathAddress = this.getResourcePathAddress().append("core-service", "management");
        this.managementInterfaceResources = new ManagementInterfaceResourceImpl.Factory(managementCoreServicePathAddress, this);
        this.addChildResourceFactory(this.managementInterfaceResources);
        this.securityRealmResources = new SecurityRealmResourceImpl.Factory(managementCoreServicePathAddress, this);
        this.addChildResourceFactory(this.securityRealmResources);
    }

    @Override
    protected ModelControllerClient startConfiguration() {
        return this.hostController.getModelControllerClient();
    }

    @Override
    protected void stopConfiguration() {
        this.writeConfiguration();
    }

    public static class HostConfigFileMigrationFactory
    implements HostMigration.HostConfigurationProvider {
        @Override
        public EmbeddedHostConfiguration getHostConfiguration(String host, HostControllerConfiguration hostController) {
            return new EmbeddedHostConfiguration(hostController, host);
        }
    }
}

