/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.jgroups;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.subsystem.UpdateSubsystemResourceSubtaskBuilder;

public class UpdateProtocols<S>
extends UpdateSubsystemResourceSubtaskBuilder<S> {
    private final List<Operation> operations;
    private static final String STACK = "stack";
    private static final String PROTOCOL = "protocol";

    public UpdateProtocols(Operations operations) {
        this.subtaskName("update-protocols");
        this.operations = Collections.unmodifiableList(operations.operations);
    }

    @Override
    protected ServerMigrationTaskResult updateConfiguration(ModelNode config, S source, SubsystemResource subsystemResource, TaskContext context, TaskEnvironment taskEnvironment) {
        PathAddress subsystemPathAddress = subsystemResource.getResourcePathAddress();
        ManageableServerConfiguration serverConfiguration = subsystemResource.getServerConfiguration();
        ModelNode stacks = config.get(STACK);
        if (!stacks.isDefined()) {
            context.getLogger().debugf("No stacks defined.", new Object[0]);
            return ServerMigrationTaskResult.SKIPPED;
        }
        HashSet<String> protocolsRemoved = new HashSet<String>();
        HashSet<String> protocolsAdded = new HashSet<String>();
        Operations.CompositeOperationBuilder compositeOperationBuilder = Operations.CompositeOperationBuilder.create();
        for (String stackName : stacks.keys()) {
            ProtocolStack protocolStack = new ProtocolStack(stackName, config.get(new String[]{STACK, stackName}), context);
            for (Operation operation : this.operations) {
                operation.execute(protocolStack, context);
            }
            Set<String> protocolsRemovedFromStack = protocolStack.getProtocolsRemoved();
            Set<String> protocolsAddedToStack = protocolStack.getProtocolsAdded();
            if (protocolsRemovedFromStack.isEmpty() && protocolsAddedToStack.isEmpty()) continue;
            for (Property protocol : protocolStack.sourceProtocols) {
                compositeOperationBuilder.addStep(Util.createRemoveOperation((PathAddress)subsystemPathAddress.append(STACK, stackName).append(PROTOCOL, protocol.getName())));
            }
            for (Property protocol : protocolStack.targetProtocols) {
                ModelNode addOp = protocol.getValue().clone();
                addOp.get("operation").set("add");
                addOp.get("address").set(subsystemPathAddress.append(STACK, stackName).append(PROTOCOL, protocol.getName()).toModelNode());
                compositeOperationBuilder.addStep(addOp);
            }
            protocolsRemoved.addAll(protocolsRemovedFromStack);
            protocolsAdded.addAll(protocolsAddedToStack);
        }
        if (protocolsRemoved.isEmpty() && protocolsAdded.isEmpty()) {
            context.getLogger().debugf("No protocols removed or added.", new Object[0]);
            return ServerMigrationTaskResult.SKIPPED;
        }
        serverConfiguration.executeManagementOperation(compositeOperationBuilder.build().getOperation());
        return new ServerMigrationTaskResult.Builder().success().addAttribute("protocols-removed", protocolsRemoved).addAttribute("protocols-added", protocolsAdded).build();
    }

    public static class Operations {
        final List<Operation> operations = new ArrayList<Operation>();

        public Operations add(String protocol) {
            this.operations.add((protocolStack, context) -> protocolStack.add(protocol));
            return this;
        }

        public Operations replace(String oldProtocol, String newProtocol) {
            this.operations.add((protocolStack, context) -> protocolStack.replace(oldProtocol, newProtocol));
            return this;
        }

        public Operations remove(String protocol) {
            this.operations.add((protocolStack, context) -> protocolStack.remove(protocol));
            return this;
        }

        public Operations custom(Operation operation) {
            this.operations.add(operation);
            return this;
        }
    }

    public static interface Operation {
        public void execute(ProtocolStack var1, TaskContext var2);
    }

    public static class ProtocolStack {
        final List<Property> sourceProtocols;
        final List<Property> targetProtocols;
        final String name;
        final TaskContext taskContext;

        ProtocolStack(String name, ModelNode stackModelNode, TaskContext taskContext) {
            this.name = name;
            ModelNode protocolsModelNode = stackModelNode.get(UpdateProtocols.PROTOCOL);
            this.sourceProtocols = protocolsModelNode.clone().asPropertyList();
            this.targetProtocols = protocolsModelNode.clone().asPropertyList();
            this.taskContext = taskContext;
        }

        public void add(String protocol) {
            this.taskContext.getLogger().debug((Object)("Adding protocol " + protocol));
            this.targetProtocols.add(new Property(protocol, new ModelNode()));
        }

        public ModelNode get(String protocol) {
            ListIterator<Property> li = this.targetProtocols.listIterator();
            while (li.hasNext()) {
                Property p = li.next();
                if (!p.getName().equals(protocol)) continue;
                return p.getValue().clone();
            }
            return null;
        }

        public void update(String protocolName, ModelNode protocolValue) {
            this.taskContext.getLogger().debug((Object)("Updating protocol " + protocolName + ": " + protocolValue));
            ListIterator<Property> li = this.targetProtocols.listIterator();
            while (li.hasNext()) {
                if (!li.next().getName().equals(protocolName)) continue;
                li.set(new Property(protocolName, protocolValue.clone()));
            }
        }

        public void replace(String oldProtocol, String newProtocol) {
            this.taskContext.getLogger().debug((Object)("Replacing protocol " + oldProtocol + " with " + newProtocol));
            ListIterator<Property> li = this.targetProtocols.listIterator();
            while (li.hasNext()) {
                if (!li.next().getName().equals(oldProtocol)) continue;
                li.set(new Property(newProtocol, new ModelNode()));
            }
        }

        public boolean remove(String protocol) {
            this.taskContext.getLogger().debug((Object)("Removing protocol " + protocol));
            ListIterator<Property> li = this.targetProtocols.listIterator();
            while (li.hasNext()) {
                if (!li.next().getName().equals(protocol)) continue;
                li.remove();
                return true;
            }
            return false;
        }

        Set<String> getProtocolsAdded() {
            HashSet<String> result = new HashSet<String>();
            for (Property protocol : this.targetProtocols) {
                result.add(protocol.getName());
            }
            for (Property protocol : this.sourceProtocols) {
                result.remove(protocol.getName());
            }
            return result;
        }

        Set<String> getProtocolsRemoved() {
            HashSet<String> result = new HashSet<String>();
            for (Property protocol : this.sourceProtocols) {
                result.add(protocol.getName());
            }
            for (Property protocol : this.targetProtocols) {
                result.remove(protocol.getName());
            }
            return result;
        }
    }
}

