/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.bridge;

import java.util.ArrayList;
import java.util.List;
import org.jboss.security.xacml.bridge.PolicySetFinderModule;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.MatchResult;
import org.jboss.security.xacml.sunxacml.PolicySet;
import org.jboss.security.xacml.sunxacml.ctx.Status;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinderResult;

public class RPSPolicySetFinderModule
extends PolicySetFinderModule {
    protected List<PolicySet> policySets = new ArrayList<PolicySet>();

    public void add(PolicySet ps) {
        this.policySets.add(ps);
    }

    @Override
    public PolicyFinderResult findPolicy(EvaluationCtx context) {
        PolicySet selectedPolicy = null;
        for (PolicySet policySet : this.policySets) {
            MatchResult match = policySet.match(context);
            int result = match.getResult();
            if (result == 2) {
                return new PolicyFinderResult(match.getStatus());
            }
            if (result != 0) continue;
            if (selectedPolicy != null) {
                ArrayList<String> code = new ArrayList<String>();
                code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                Status status = new Status(code, "RPSPolicySetFinderModule::too many applicable top-level policies");
                return new PolicyFinderResult(status);
            }
            selectedPolicy = policySet;
        }
        return new PolicyFinderResult(selectedPolicy);
    }
}

