/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.CompressionAlgorithmTags;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.PacketTags;
import org.bouncycastle.util.Arrays;

public class BCPGOutputStream
extends OutputStream
implements PacketTags,
CompressionAlgorithmTags {
    OutputStream out;
    private byte[] partialBuffer;
    private int partialBufferLength;
    private int partialPower;
    private int partialOffset;
    private static final int BUF_SIZE_POWER = 16;

    public BCPGOutputStream(OutputStream out) {
        this.out = out;
    }

    public BCPGOutputStream(OutputStream out, int tag) throws IOException {
        this.out = out;
        this.writeHeader(tag, true, true, 0L);
    }

    public BCPGOutputStream(OutputStream out, int tag, long length, boolean oldFormat) throws IOException {
        this.out = out;
        if (length > 0xFFFFFFFFL) {
            this.writeHeader(tag, false, true, 0L);
            this.partialBufferLength = 65536;
            this.partialBuffer = new byte[this.partialBufferLength];
            this.partialPower = 16;
            this.partialOffset = 0;
        } else {
            this.writeHeader(tag, oldFormat, false, length);
        }
    }

    public BCPGOutputStream(OutputStream out, int tag, long length) throws IOException {
        this.out = out;
        this.writeHeader(tag, false, false, length);
    }

    public BCPGOutputStream(OutputStream out, int tag, byte[] buffer) throws IOException {
        this.out = out;
        this.writeHeader(tag, false, true, 0L);
        this.partialBuffer = buffer;
        int length = this.partialBuffer.length;
        this.partialPower = 0;
        while (length != 1) {
            length >>>= 1;
            ++this.partialPower;
        }
        if (this.partialPower > 30) {
            throw new IOException("Buffer cannot be greater than 2^30 in length.");
        }
        this.partialBufferLength = 1 << this.partialPower;
        this.partialOffset = 0;
    }

    private void writeNewPacketLength(long bodyLen) throws IOException {
        if (bodyLen < 192L) {
            this.out.write((byte)bodyLen);
        } else if (bodyLen <= 8383L) {
            this.out.write((byte)(((bodyLen -= 192L) >> 8 & 0xFFL) + 192L));
            this.out.write((byte)bodyLen);
        } else {
            this.out.write(255);
            this.out.write((byte)(bodyLen >> 24));
            this.out.write((byte)(bodyLen >> 16));
            this.out.write((byte)(bodyLen >> 8));
            this.out.write((byte)bodyLen);
        }
    }

    private void writeHeader(int tag, boolean oldPackets, boolean partial, long bodyLen) throws IOException {
        int hdr = 128;
        if (this.partialBuffer != null) {
            this.partialFlush(true);
            this.partialBuffer = null;
        }
        if (oldPackets) {
            hdr |= tag << 2;
            if (partial) {
                this.write(hdr | 3);
            } else if (bodyLen <= 255L) {
                this.write(hdr);
                this.write((byte)bodyLen);
            } else if (bodyLen <= 65535L) {
                this.write(hdr | 1);
                this.write((byte)(bodyLen >> 8));
                this.write((byte)bodyLen);
            } else {
                this.write(hdr | 2);
                this.write((byte)(bodyLen >> 24));
                this.write((byte)(bodyLen >> 16));
                this.write((byte)(bodyLen >> 8));
                this.write((byte)bodyLen);
            }
        } else {
            this.write(hdr |= 0x40 | tag);
            if (partial) {
                this.partialOffset = 0;
            } else {
                this.writeNewPacketLength(bodyLen);
            }
        }
    }

    private void partialFlush(boolean isLast) throws IOException {
        if (isLast) {
            this.writeNewPacketLength(this.partialOffset);
            this.out.write(this.partialBuffer, 0, this.partialOffset);
        } else {
            this.out.write(0xE0 | this.partialPower);
            this.out.write(this.partialBuffer, 0, this.partialBufferLength);
        }
        this.partialOffset = 0;
    }

    private void writePartial(byte b) throws IOException {
        if (this.partialOffset == this.partialBufferLength) {
            this.partialFlush(false);
        }
        this.partialBuffer[this.partialOffset++] = b;
    }

    private void writePartial(byte[] buf, int off, int len) throws IOException {
        if (this.partialOffset == this.partialBufferLength) {
            this.partialFlush(false);
        }
        if (len <= this.partialBufferLength - this.partialOffset) {
            System.arraycopy(buf, off, this.partialBuffer, this.partialOffset, len);
            this.partialOffset += len;
        } else {
            System.arraycopy(buf, off, this.partialBuffer, this.partialOffset, this.partialBufferLength - this.partialOffset);
            off += this.partialBufferLength - this.partialOffset;
            len -= this.partialBufferLength - this.partialOffset;
            this.partialFlush(false);
            while (len > this.partialBufferLength) {
                System.arraycopy(buf, off, this.partialBuffer, 0, this.partialBufferLength);
                off += this.partialBufferLength;
                len -= this.partialBufferLength;
                this.partialFlush(false);
            }
            System.arraycopy(buf, off, this.partialBuffer, 0, len);
            this.partialOffset += len;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.partialBuffer != null) {
            this.writePartial((byte)b);
        } else {
            this.out.write(b);
        }
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        if (this.partialBuffer != null) {
            this.writePartial(bytes, off, len);
        } else {
            this.out.write(bytes, off, len);
        }
    }

    public void writePacket(ContainedPacket p) throws IOException {
        p.encode(this);
    }

    void writePacket(int tag, byte[] body, boolean oldFormat) throws IOException {
        this.writeHeader(tag, oldFormat, false, body.length);
        this.write(body);
    }

    public void writeObject(BCPGObject o) throws IOException {
        o.encode(this);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    public void finish() throws IOException {
        if (this.partialBuffer != null) {
            this.partialFlush(true);
            Arrays.fill((byte[])this.partialBuffer, (byte)0);
            this.partialBuffer = null;
        }
    }

    @Override
    public void close() throws IOException {
        this.finish();
        this.out.flush();
        this.out.close();
    }
}

