/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.config.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.protostream.AnnotationMetadataCreator;
import org.infinispan.protostream.config.AnnotationAttributeConfiguration;
import org.infinispan.protostream.config.AnnotationConfiguration;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.config.impl.AnnotationAttributeConfigurationImpl;
import org.infinispan.protostream.config.impl.ConfigurationImpl;
import org.infinispan.protostream.descriptors.AnnotatedDescriptor;
import org.infinispan.protostream.descriptors.AnnotationElement;

final class AnnotationConfigurationImpl
implements AnnotationConfiguration {
    private final String name;
    private final AnnotationElement.AnnotationTarget[] target;
    private final Map<String, AnnotationAttributeConfiguration> attributes;
    private final AnnotationMetadataCreator<?, ? extends AnnotatedDescriptor> annotationMetadataCreator;
    private final String repeatable;
    protected AnnotationConfigurationImpl container;

    private AnnotationConfigurationImpl(String name, AnnotationElement.AnnotationTarget[] target, Map<String, AnnotationAttributeConfiguration> attributes, AnnotationMetadataCreator<?, ? extends AnnotatedDescriptor> annotationMetadataCreator, String repeatable) {
        this.name = name;
        this.target = target;
        this.attributes = Collections.unmodifiableMap(attributes);
        this.annotationMetadataCreator = annotationMetadataCreator;
        this.repeatable = repeatable;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public AnnotationElement.AnnotationTarget[] target() {
        return this.target;
    }

    @Override
    public Map<String, AnnotationAttributeConfiguration> attributes() {
        return this.attributes;
    }

    @Override
    public AnnotationMetadataCreator<?, ? extends AnnotatedDescriptor> metadataCreator() {
        return this.annotationMetadataCreator;
    }

    @Override
    public String repeatable() {
        return this.repeatable;
    }

    static final class BuilderImpl
    implements AnnotationConfiguration.Builder {
        private final ConfigurationImpl.BuilderImpl.AnnotationsConfigBuilderImpl parentBuilder;
        private final String name;
        private final AnnotationElement.AnnotationTarget[] target;
        private final Map<String, AnnotationAttributeConfigurationImpl.BuilderImpl> attributeBuilders = new HashMap<String, AnnotationAttributeConfigurationImpl.BuilderImpl>();
        private AnnotationMetadataCreator<?, ? extends AnnotatedDescriptor> annotationMetadataCreator;
        private String repeatable;

        BuilderImpl(ConfigurationImpl.BuilderImpl.AnnotationsConfigBuilderImpl parentBuilder, String name, AnnotationElement.AnnotationTarget[] target) {
            BuilderImpl.checkValidIdentifier(name, "annotation name");
            this.name = name;
            this.target = target;
            this.parentBuilder = parentBuilder;
        }

        private static void checkValidIdentifier(String str, String what) {
            if (str == null) {
                throw new IllegalArgumentException(what + " must not be null");
            }
            if (str.isEmpty() || !Character.isJavaIdentifierStart(str.charAt(0))) {
                throw new IllegalArgumentException("'" + str + "' is not a valid " + what);
            }
            for (int i = 1; i < str.length(); ++i) {
                if (Character.isJavaIdentifierPart(str.charAt(i))) continue;
                throw new IllegalArgumentException(str + " is not a valid " + what);
            }
        }

        @Override
        public AnnotationAttributeConfiguration.Builder attribute(String name) {
            BuilderImpl.checkValidIdentifier(name, "annotation element name");
            if (this.attributeBuilders.containsKey(name)) {
                throw new IllegalArgumentException("Duplicate annotation element name definition: " + name);
            }
            AnnotationAttributeConfigurationImpl.BuilderImpl builder = new AnnotationAttributeConfigurationImpl.BuilderImpl(this, name);
            this.attributeBuilders.put(name, builder);
            return builder;
        }

        @Override
        public AnnotationConfiguration.Builder metadataCreator(AnnotationMetadataCreator<?, ? extends AnnotatedDescriptor> annotationMetadataCreator) {
            this.annotationMetadataCreator = annotationMetadataCreator;
            return this;
        }

        @Override
        public AnnotationConfiguration.Builder repeatable(String containingAnnotationName) {
            if (containingAnnotationName == null) {
                throw new IllegalArgumentException("containingAnnotationName cannot be null");
            }
            if (this.name.equals(containingAnnotationName)) {
                throw new IllegalArgumentException("The name of the containing annotation ('" + containingAnnotationName + "') cannot be identical to the name of the repeatable annotation");
            }
            this.repeatable = containingAnnotationName;
            BuilderImpl containingAnnotationBuilder = this.parentBuilder.annotationBuilders.get(containingAnnotationName);
            if (containingAnnotationBuilder != null) {
                if (!Arrays.asList(containingAnnotationBuilder.target).containsAll(Arrays.asList(this.target))) {
                    throw new IllegalArgumentException("The containing annotation '" + containingAnnotationName + "' has a target that does not include the target of the repeatable annotation '" + this.name + "'");
                }
                AnnotationAttributeConfigurationImpl.BuilderImpl valueAttrBuilder = containingAnnotationBuilder.attributeBuilders.get("value");
                if (valueAttrBuilder == null || !valueAttrBuilder.isMultiple || valueAttrBuilder.type != AnnotationElement.AttributeType.ANNOTATION || valueAttrBuilder.allowedValues == null || !Arrays.asList(valueAttrBuilder.allowedValues).contains(this.name)) {
                    throw new IllegalArgumentException("The containing annotation '" + containingAnnotationName + "' of the repeatable annotation '" + this.name + "' does not have a '" + "value" + "' element of suitable type");
                }
                for (Map.Entry<String, AnnotationAttributeConfigurationImpl.BuilderImpl> entry : containingAnnotationBuilder.attributeBuilders.entrySet()) {
                    String attrName = entry.getKey();
                    if (attrName.equals("value")) continue;
                    AnnotationAttributeConfigurationImpl.BuilderImpl attrBuilder = entry.getValue();
                    if (attrBuilder.defaultValue != null) continue;
                    throw new IllegalArgumentException("The containing annotation '" + containingAnnotationName + "' of the repeatable annotation '" + this.name + "' does not have a default value for element '" + attrName + "'");
                }
            } else {
                this.parentBuilder.annotation(containingAnnotationName, this.target).attribute("value").type(AnnotationElement.AttributeType.ANNOTATION).allowedValues(this.name).multiple(true);
            }
            return this;
        }

        @Override
        public AnnotationConfiguration.Builder annotation(String annotationName, AnnotationElement.AnnotationTarget ... target) {
            return this.parentBuilder.annotation(annotationName, target);
        }

        AnnotationConfigurationImpl buildAnnotationConfiguration() {
            HashMap<String, AnnotationAttributeConfiguration> attributes = new HashMap<String, AnnotationAttributeConfiguration>(this.attributeBuilders.size());
            for (AnnotationAttributeConfiguration.Builder builder : this.attributeBuilders.values()) {
                AnnotationAttributeConfiguration annotationAttributeConfig = ((AnnotationAttributeConfigurationImpl.BuilderImpl)builder).buildAnnotationAttributeConfiguration();
                attributes.put(annotationAttributeConfig.name(), annotationAttributeConfig);
            }
            return new AnnotationConfigurationImpl(this.name, this.target, attributes, this.annotationMetadataCreator, this.repeatable);
        }

        @Override
        public Configuration build() {
            return this.parentBuilder.build();
        }
    }
}

