/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class DistributableImmutableSession
implements Session {
    private final SessionManager manager;
    private final String id;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final long creationTime;
    private final long lastAccessedTime;
    private final int maxInactiveInterval;

    public DistributableImmutableSession(SessionManager manager, ImmutableSession session) {
        this.manager = manager;
        this.id = session.getId();
        ImmutableSessionAttributes attributes = session.getAttributes();
        for (String name : attributes.getAttributeNames()) {
            this.attributes.put(name, attributes.getAttribute(name));
        }
        ImmutableSessionMetaData metaData = session.getMetaData();
        this.creationTime = metaData.getCreationTime().toEpochMilli();
        this.lastAccessedTime = metaData.getLastAccessStartTime().toEpochMilli();
        this.maxInactiveInterval = (int)metaData.getMaxInactiveInterval().getSeconds();
    }

    public String getId() {
        return this.id;
    }

    public SessionManager getSessionManager() {
        return this.manager;
    }

    public void requestDone(HttpServerExchange serverExchange) {
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int interval) {
        throw new UnsupportedOperationException();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Set<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    public Object setAttribute(String name, Object value) {
        return value;
    }

    public Object removeAttribute(String name) {
        return null;
    }

    public void invalidate(HttpServerExchange exchange) {
    }

    public String changeSessionId(HttpServerExchange exchange, SessionConfig config) {
        return null;
    }
}

