/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.console;

import java.util.ArrayList;
import java.util.Locale;
import org.jboss.migration.core.console.ConsoleWrapper;
import org.jboss.migration.core.console.ReportError;
import org.jboss.migration.core.logger.ServerMigrationLogger;

public class UserConfirmation {
    private static final String LONG_YES = ServerMigrationLogger.ROOT_LOGGER.yes().toLowerCase(Locale.getDefault());
    private static final String LONG_NO = ServerMigrationLogger.ROOT_LOGGER.no().toLowerCase(Locale.getDefault());
    private static final String SHORT_YES = ServerMigrationLogger.ROOT_LOGGER.shortYes().toLowerCase(Locale.getDefault());
    private static final String SHORT_NO = ServerMigrationLogger.ROOT_LOGGER.shortNo().toLowerCase(Locale.getDefault());
    private ConsoleWrapper theConsole;
    private final String[] messageLines;
    private final String prompt;
    private final ResultHandler resultHandler;
    private static final int YES = 0;
    private static final int NO = 1;
    private static final int INVALID = 2;

    public UserConfirmation(ConsoleWrapper theConsole, String[] messageLines, String prompt, ResultHandler resultHandler) {
        this.theConsole = theConsole;
        this.messageLines = messageLines;
        this.prompt = prompt;
        this.resultHandler = resultHandler;
    }

    public UserConfirmation(ConsoleWrapper theConsole, String message, String prompt, ResultHandler resultHandler) {
        this(theConsole, new String[]{message}, prompt, resultHandler);
    }

    public UserConfirmation(ConsoleWrapper theConsole, String message, ResultHandler resultHandler) {
        this(theConsole, new String[]{message}, ServerMigrationLogger.ROOT_LOGGER.yesNo(), resultHandler);
    }

    public void execute() {
        this.theConsole.println();
        if (this.messageLines != null) {
            for (String message : this.messageLines) {
                this.theConsole.printf(message, new Object[0]);
                this.theConsole.println();
            }
        }
        this.theConsole.printf(this.prompt, new Object[0]);
        String temp = this.theConsole.readLine(" ", new Object[0]);
        switch (this.convertResponse(temp)) {
            case 0: {
                this.resultHandler.onYes();
                break;
            }
            case 1: {
                this.resultHandler.onNo();
                break;
            }
            default: {
                ArrayList<String> acceptedValues = new ArrayList<String>(4);
                acceptedValues.add(ServerMigrationLogger.ROOT_LOGGER.yes());
                if (ServerMigrationLogger.ROOT_LOGGER.shortYes().length() > 0) {
                    acceptedValues.add(ServerMigrationLogger.ROOT_LOGGER.shortYes());
                }
                acceptedValues.add(ServerMigrationLogger.ROOT_LOGGER.no());
                if (ServerMigrationLogger.ROOT_LOGGER.shortNo().length() > 0) {
                    acceptedValues.add(ServerMigrationLogger.ROOT_LOGGER.shortNo());
                }
                StringBuilder sb = new StringBuilder((String)acceptedValues.get(0));
                for (int i = 1; i < acceptedValues.size() - 1; ++i) {
                    sb.append(", ");
                    sb.append((String)acceptedValues.get(i));
                }
                new ReportError(this.theConsole, ServerMigrationLogger.ROOT_LOGGER.invalidResponse(sb.toString(), (String)acceptedValues.get(acceptedValues.size() - 1))).execute();
                this.resultHandler.onError();
            }
        }
    }

    private int convertResponse(String response) {
        if (response != null) {
            String temp = response.toLowerCase();
            if (LONG_YES.equals(temp) || SHORT_YES.equals(temp)) {
                return 0;
            }
            if (LONG_NO.equals(temp) || SHORT_NO.equals(temp)) {
                return 1;
            }
        }
        return 2;
    }

    public static interface ResultHandler {
        public void onNo();

        public void onYes();

        public void onError();
    }
}

