/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.env;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.env.Environment;

public class MigrationEnvironment
implements Environment {
    private final SortedMap<String, PropertyValue> properties;
    private final SortedSet<String> readed = new TreeSet<String>();

    public MigrationEnvironment() {
        this.properties = new TreeMap<String, PropertyValue>();
    }

    @Override
    public Boolean getPropertyAsBoolean(String propertyName) {
        String propertyValue = this.getPropertyAsString(propertyName);
        if (propertyValue == null || propertyValue.isEmpty()) {
            return null;
        }
        return Boolean.parseBoolean(propertyValue);
    }

    @Override
    public Boolean getPropertyAsBoolean(String propertyName, Boolean defaultValue) {
        Boolean propertyValue = this.getPropertyAsBoolean(propertyName);
        return propertyValue != null ? propertyValue : defaultValue;
    }

    @Override
    public String getPropertyAsString(String propertyName) {
        PropertyValue propertyValue = (PropertyValue)this.properties.get(propertyName);
        if (propertyValue == null) {
            return null;
        }
        return propertyValue.getStringValue();
    }

    @Override
    public String getPropertyAsString(String propertyName, String defaultValue) {
        String propertyValue = this.getPropertyAsString(propertyName);
        return propertyValue != null ? propertyValue : defaultValue;
    }

    @Override
    public List<String> getPropertyAsList(String propertyName) {
        PropertyValue propertyValue = (PropertyValue)this.properties.get(propertyName);
        if (propertyValue == null) {
            return null;
        }
        return propertyValue.getListValue();
    }

    @Override
    public List<String> getPropertyAsList(String propertyName, List<String> defaultValue) {
        List<String> propertyValue = this.getPropertyAsList(propertyName);
        return propertyValue != null ? propertyValue : defaultValue;
    }

    @Override
    public Boolean requirePropertyAsBoolean(String propertyName) throws ServerMigrationFailureException {
        Boolean propertyValue = this.getPropertyAsBoolean(propertyName);
        if (propertyValue == null) {
            throw new ServerMigrationFailureException("Environment property " + propertyName + " is required.");
        }
        return propertyValue;
    }

    @Override
    public String requirePropertyAsString(String propertyName, boolean failIfEmpty) throws ServerMigrationFailureException {
        String propertyValue = this.getPropertyAsString(propertyName);
        if (propertyValue == null || failIfEmpty && propertyValue.isEmpty()) {
            throw new ServerMigrationFailureException("Environment property " + propertyName + " is required.");
        }
        return propertyValue;
    }

    @Override
    public List<String> requirePropertyAsList(String propertyName, boolean failIfEmpty) throws ServerMigrationFailureException {
        List<String> propertyValue = this.getPropertyAsList(propertyName);
        if (propertyValue == null || failIfEmpty && propertyValue.isEmpty()) {
            throw new ServerMigrationFailureException("Environment property " + propertyName + " is required.");
        }
        return propertyValue;
    }

    @Override
    public String setProperty(String propertyName, String propertyValue) {
        PropertyValue old = this.properties.put(propertyName, new PropertyValue(propertyValue));
        return old != null ? old.getStringValue() : null;
    }

    @Override
    public void setProperties(Properties properties) {
        for (String propertyName : properties.stringPropertyNames()) {
            this.setProperty(propertyName, properties.getProperty(propertyName));
        }
    }

    public void setProperties(MigrationEnvironment migrationEnvironment) {
        this.properties.putAll(migrationEnvironment.properties);
    }

    @Override
    public List<String> getPropertyNames() {
        return Collections.unmodifiableList(new ArrayList<String>(this.properties.keySet()));
    }

    @Override
    public List<String> getPropertyNamesReaded() {
        ArrayList<String> result = new ArrayList<String>();
        for (String propertyName : this.properties.keySet()) {
            PropertyValue propertyValue = (PropertyValue)this.properties.get(propertyName);
            if (!propertyValue.isReaded()) continue;
            result.add(propertyName);
        }
        return Collections.unmodifiableList(result);
    }

    private static class PropertyValue {
        private final String stringValue;
        private List<String> listValue;
        private boolean readed;

        private PropertyValue(String stringValue) {
            this.stringValue = stringValue;
        }

        public String getStringValue() {
            this.readed = true;
            return this.stringValue;
        }

        public List<String> getListValue() {
            this.readed = true;
            if (this.listValue == null) {
                ArrayList<String> list = new ArrayList<String>();
                for (String s : this.stringValue.split(",")) {
                    String st = s.trim();
                    if (st.isEmpty()) continue;
                    list.add(st);
                }
                this.listValue = list;
            }
            return this.listValue;
        }

        public boolean isReaded() {
            return this.readed;
        }
    }
}

