/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.jboss;

import java.nio.file.Path;
import org.jboss.migration.core.AbstractServer;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.jboss.CopyPath;
import org.jboss.migration.core.jboss.JBossServerConfiguration;
import org.jboss.migration.core.jboss.ResolvablePath;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.core.task.component.TaskRunnable;

public class MigrateResolvablePathTaskRunnable
implements TaskRunnable {
    private final ResolvablePath path;
    private final JBossServerConfiguration sourceConfiguration;
    private final JBossServerConfiguration targetConfiguration;

    public MigrateResolvablePathTaskRunnable(ResolvablePath path, JBossServerConfiguration sourceConfiguration, JBossServerConfiguration targetConfiguration) {
        this.path = path;
        this.sourceConfiguration = sourceConfiguration;
        this.targetConfiguration = targetConfiguration;
    }

    @Override
    public ServerMigrationTaskResult run(TaskContext context) {
        if (this.path.getRelativeTo() != null) {
            Path sourcePath = this.sourceConfiguration.resolvePath(this.path);
            Path targetPath = this.targetConfiguration.resolvePath(this.path);
            if (sourcePath == null) {
                if (targetPath == null) {
                    throw new ServerMigrationFailureException("Failed to resolve path " + this.path);
                }
                sourcePath = targetPath.startsWith(((AbstractServer)this.targetConfiguration.getServer()).getBaseDir()) ? ((AbstractServer)this.sourceConfiguration.getServer()).getBaseDir().resolve(((AbstractServer)this.targetConfiguration.getServer()).getBaseDir().relativize(targetPath)) : targetPath;
            } else if (targetPath == null) {
                targetPath = sourcePath.startsWith(((AbstractServer)this.sourceConfiguration.getServer()).getBaseDir()) ? ((AbstractServer)this.targetConfiguration.getServer()).getBaseDir().resolve(((AbstractServer)this.sourceConfiguration.getServer()).getBaseDir().relativize(sourcePath)) : sourcePath;
            }
            return new CopyPath(sourcePath, targetPath).run(context);
        }
        context.getLogger().warnf("Skipping migration of path '%s', not a relative path!", (Object)this.path);
        return ServerMigrationTaskResult.SKIPPED;
    }
}

