/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyAlgorithmTags;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.util.Arrays;

public abstract class PGPEncryptedData
implements SymmetricKeyAlgorithmTags {
    InputStreamPacket encData;
    InputStream encStream;
    TruncatedStream truncStream;
    PGPDigestCalculator integrityCalculator;

    PGPEncryptedData(InputStreamPacket encData) {
        this.encData = encData;
    }

    public InputStream getInputStream() {
        return this.encData.getInputStream();
    }

    public boolean isIntegrityProtected() {
        return this.encData instanceof SymmetricEncIntegrityPacket;
    }

    public boolean verify() throws PGPException, IOException {
        if (!this.isIntegrityProtected()) {
            throw new PGPException("data not integrity protected.");
        }
        while (this.encStream.read() >= 0) {
        }
        int[] lookAhead = this.truncStream.getLookAhead();
        OutputStream dOut = this.integrityCalculator.getOutputStream();
        dOut.write((byte)lookAhead[0]);
        dOut.write((byte)lookAhead[1]);
        byte[] digest = this.integrityCalculator.getDigest();
        byte[] streamDigest = new byte[digest.length];
        for (int i = 0; i != streamDigest.length; ++i) {
            streamDigest[i] = (byte)lookAhead[i + 2];
        }
        return Arrays.constantTimeAreEqual((byte[])digest, (byte[])streamDigest);
    }

    protected class TruncatedStream
    extends InputStream {
        int[] lookAhead = new int[22];
        int bufPtr;
        InputStream in;

        TruncatedStream(InputStream in) throws IOException {
            for (int i = 0; i != this.lookAhead.length; ++i) {
                this.lookAhead[i] = in.read();
                if (this.lookAhead[i] >= 0) continue;
                throw new EOFException();
            }
            this.bufPtr = 0;
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            int ch = this.in.read();
            if (ch >= 0) {
                int c = this.lookAhead[this.bufPtr];
                this.lookAhead[this.bufPtr] = ch;
                this.bufPtr = (this.bufPtr + 1) % this.lookAhead.length;
                return c;
            }
            return -1;
        }

        int[] getLookAhead() {
            int i;
            int[] tmp = new int[this.lookAhead.length];
            int count = 0;
            for (i = this.bufPtr; i != this.lookAhead.length; ++i) {
                tmp[count++] = this.lookAhead[i];
            }
            for (i = 0; i != this.bufPtr; ++i) {
                tmp[count++] = this.lookAhead[i];
            }
            return tmp;
        }
    }
}

