/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import java.util.List;
import java.util.stream.Collectors;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.console.BasicResultHandlers;
import org.jboss.migration.core.console.UserConfirmation;
import org.jboss.migration.core.env.Environment;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.jboss.JBossServer;
import org.jboss.migration.core.jboss.JBossServerConfiguration;
import org.jboss.migration.core.jboss.MigrateResolvablePathTaskRunnable;
import org.jboss.migration.core.jboss.ResolvablePath;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.component.TaskRunnable;
import org.jboss.migration.wfly10.config.management.DeploymentResource;
import org.jboss.migration.wfly10.config.management.HostControllerConfiguration;
import org.jboss.migration.wfly10.config.management.ManageableResourceSelectors;
import org.jboss.migration.wfly10.config.management.ServerGroupResource;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationCompositeTask;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationLeafTask;
import org.jboss.migration.wfly10.config.task.update.MigrateContent;

public class MigratePersistentDeployments<S extends JBossServer<S>>
extends ManageableServerConfigurationCompositeTask.Builder<JBossServerConfiguration<S>> {
    public MigratePersistentDeployments() {
        this.name("deployments.migrate-persistent-deployments");
        this.runBuilder(params -> context -> {
            context.getLogger().debugf("Retrieving the configuration's persistent deployments...", new Object[0]);
            List deploymentResources = params.getServerConfiguration().getChildResources(DeploymentResource.RESOURCE_TYPE);
            if (deploymentResources.isEmpty()) {
                context.getLogger().debugf("No persistent deployments found.", new Object[0]);
                return ServerMigrationTaskResult.SKIPPED;
            }
            context.getLogger().infof("Persistent deployments found: %s", deploymentResources.stream().map(resource -> resource.getResourceName()).collect(Collectors.toList()));
            MigrationEnvironment environment = context.getMigrationEnvironment();
            boolean migrateDeployments = !new TaskEnvironment((Environment)environment, context.getTaskName()).isSkippedByEnvironment() && !new TaskEnvironment((Environment)environment, context.getParentTask().getTaskName()).isSkippedByEnvironment();
            boolean confirmEachDeployment = false;
            if (context.isInteractive()) {
                BasicResultHandlers.UserConfirmation skipDeploymentsUserConfirmationResultHandler = new BasicResultHandlers.UserConfirmation();
                UserConfirmation skipDeploymentsUserConfirmation = new UserConfirmation(context.getConsoleWrapper(), "This tool is not able to assert if persistent deployments found are compatible with the target server, skip persistent deployments migration?", "yes/no?", (UserConfirmation.ResultHandler)skipDeploymentsUserConfirmationResultHandler);
                do {
                    skipDeploymentsUserConfirmation.execute();
                } while (skipDeploymentsUserConfirmationResultHandler.getResult() == BasicResultHandlers.UserConfirmation.Result.ERROR);
                boolean bl = migrateDeployments = skipDeploymentsUserConfirmationResultHandler.getResult() == BasicResultHandlers.UserConfirmation.Result.NO;
                if (migrateDeployments && deploymentResources.size() > 1) {
                    BasicResultHandlers.UserConfirmation migrateAllDeploymentsUserConfirmationResultHandler = new BasicResultHandlers.UserConfirmation();
                    UserConfirmation migrateAllDeploymentsUserConfirmation = new UserConfirmation(context.getConsoleWrapper(), "Migrate all persistent deployments found?", "yes/no?", (UserConfirmation.ResultHandler)migrateAllDeploymentsUserConfirmationResultHandler);
                    do {
                        migrateAllDeploymentsUserConfirmation.execute();
                    } while (migrateAllDeploymentsUserConfirmationResultHandler.getResult() == BasicResultHandlers.UserConfirmation.Result.ERROR);
                    confirmEachDeployment = migrateAllDeploymentsUserConfirmationResultHandler.getResult() == BasicResultHandlers.UserConfirmation.Result.NO;
                }
            }
            for (DeploymentResource deploymentResource : deploymentResources) {
                boolean migrateDeployment;
                if (confirmEachDeployment) {
                    BasicResultHandlers.UserConfirmation migrateDeploymentUserConfirmationResultHandler = new BasicResultHandlers.UserConfirmation();
                    UserConfirmation migrateDeploymentUserConfirmation = new UserConfirmation(context.getConsoleWrapper(), "Migrate persistent deployment " + deploymentResource.getResourceName() + "?", "yes/no?", (UserConfirmation.ResultHandler)migrateDeploymentUserConfirmationResultHandler);
                    do {
                        migrateDeploymentUserConfirmation.execute();
                    } while (migrateDeploymentUserConfirmationResultHandler.getResult() == BasicResultHandlers.UserConfirmation.Result.ERROR);
                    migrateDeployment = migrateDeploymentUserConfirmationResultHandler.getResult() == BasicResultHandlers.UserConfirmation.Result.YES;
                } else {
                    migrateDeployment = migrateDeployments;
                }
                if (!migrateDeployment) {
                    RemoveDeploymentSubtask subtaskBuilder = new RemoveDeploymentSubtask(deploymentResource);
                    context.execute(subtaskBuilder.build(params));
                    continue;
                }
                context.getLogger().infof("Persistent deployment %s migrated.", (Object)deploymentResource.getResourceName());
            }
            return context.hasSucessfulSubtasks() ? ServerMigrationTaskResult.SUCCESS : ServerMigrationTaskResult.SKIPPED;
        });
    }

    public static class RemoveDeploymentSubtask<S extends JBossServer<S>>
    extends ManageableServerConfigurationLeafTask.Builder<JBossServerConfiguration<S>> {
        protected RemoveDeploymentSubtask(DeploymentResource resource) {
            this.nameBuilder(parameters -> new ServerMigrationTaskName.Builder("deployments.remove-persistent-deployment").addAttribute("resource", resource.getResourceAbsoluteName()).build());
            TaskRunnable.Builder runnableBuilder = params -> context -> {
                if (params.getServerConfiguration() instanceof HostControllerConfiguration) {
                    for (DeploymentResource serverGroupDeploymentResource : ManageableResourceSelectors.selectResources(ServerGroupResource.class).andThen(ManageableResourceSelectors.selectResources(DeploymentResource.class, resource.getResourceName())).fromResources(params.getServerConfiguration())) {
                        serverGroupDeploymentResource.removeResource();
                        context.getLogger().debugf("Persistent deployment (from server group) '%s' removed.", (Object)resource.getResourceAbsoluteName());
                    }
                }
                resource.removeResource();
                context.getLogger().debugf("Persistent deployment %s removed.", (Object)resource.getResourceName());
                return ServerMigrationTaskResult.SUCCESS;
            };
            this.runBuilder(runnableBuilder);
        }
    }

    public static class MigrateDeploymentSubtask<S extends JBossServer<S>>
    extends ManageableServerConfigurationLeafTask.Builder<JBossServerConfiguration<S>> {
        protected MigrateDeploymentSubtask(DeploymentResource resource) {
            this.nameBuilder(parameters -> new ServerMigrationTaskName.Builder("deployments.migrate-persistent-deployment").addAttribute("resource", resource.getResourceAbsoluteName()).build());
            TaskRunnable.Builder runnableBuilder = params -> context -> {
                ModelNode deploymentConfig = resource.getResourceConfiguration();
                if (!deploymentConfig.hasDefined("content")) {
                    throw new ServerMigrationFailureException("Unexpected deployment " + resource.getResourceName() + " configuration: " + deploymentConfig.asString());
                }
                for (ModelNode content : deploymentConfig.get("content").asList()) {
                    if (content.hasDefined("hash")) {
                        new MigrateContent(content.get("hash").asBytes(), (JBossServerConfiguration)params.getSource(), params.getServerConfiguration().getConfigurationPath()).run(context);
                        continue;
                    }
                    if (content.hasDefined("path")) {
                        new MigrateResolvablePathTaskRunnable(new ResolvablePath(content), (JBossServerConfiguration)params.getSource(), params.getServerConfiguration().getConfigurationPath()).run(context);
                        continue;
                    }
                    throw new ServerMigrationFailureException("Unexpected deployment " + resource.getResourceName() + " content: " + content.asString());
                }
                return ServerMigrationTaskResult.SUCCESS;
            };
            this.runBuilder(runnableBuilder);
        }
    }
}

